/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.swing.UIManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.bootstrap.bridge.FlatLafConfiguration;
import ru.turikhay.util.Lazy;

public class FlatLaf {
    private static final Logger LOGGER = LogManager.getLogger(FlatLaf.class);
    private static final String SUPPORTED_CONFIG_VERSION = "v1";
    private static final Lazy<Boolean> IS_SUPPORTED = Lazy.of(() -> {
        try {
            if (!TLauncher.getInstance().hasCapability("has_flatlaf")) {
                throw new RuntimeException("capability missing: has_flatlaf");
            }
            String configVersion = FlatLafConfiguration.getVersion();
            if (!configVersion.equals(SUPPORTED_CONFIG_VERSION)) {
                throw new RuntimeException("version not supported: " + configVersion);
            }
        }
        catch (Throwable t) {
            LOGGER.warn("FlatLafConfiguration not available: {}", (Object)t.toString());
            return false;
        }
        return true;
    });
    private static final Lazy<List<String>> STATES = Lazy.of(() -> {
        if (!FlatLaf.isSupported()) {
            return Collections.emptyList();
        }
        return Arrays.stream(FlatLafConfiguration.State.values()).map(FlatLafConfiguration.State::toString).collect(Collectors.toList());
    });

    public static Map<String, String> getDefaults() {
        if (FlatLaf.isSupported()) {
            return FlatLafConfiguration.getDefaults();
        }
        return Collections.emptyMap();
    }

    public static Optional<FlatLafConfiguration> parseFromMap(Map<String, String> map) {
        if (FlatLaf.isSupported()) {
            return Optional.of(FlatLafConfiguration.parseFromMap(map));
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage loadDefaultBackgroundFromThemeFile(String themeFile) {
        if (themeFile.startsWith(":")) return null;
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(themeFile), StandardCharsets.UTF_8);){
            JsonElement json = JsonParser.parseReader((Reader)reader);
            JsonObject o = json.getAsJsonObject();
            if (!o.has("_tl")) return null;
            JsonObject tlSection = o.getAsJsonObject("_tl");
            if (!tlSection.has("defaultBackground")) return null;
            String defaultBackgroundPath = tlSection.getAsJsonPrimitive("defaultBackground").getAsString();
            BufferedImage bufferedImage = ImageIO.read(new File(defaultBackgroundPath));
            return bufferedImage;
        }
        catch (IOException | RuntimeException e) {
            LOGGER.warn("Couldn't read default background from theme file: {}", (Object)themeFile, (Object)e);
        }
        return null;
    }

    public static Optional<FlatLafConfiguration.Theme> getSelectedNowTheme(Optional<FlatLafConfiguration> configuration) {
        if (FlatLaf.isSupported() && configuration.isPresent() && configuration.get().isEnabled()) {
            FlatLafConfiguration flatLafConfiguration = configuration.get();
            return Optional.of(flatLafConfiguration.getSelected().orElse(UIManager.getBoolean("laf.dark") ? FlatLafConfiguration.Theme.DARK : FlatLafConfiguration.Theme.LIGHT));
        }
        return Optional.empty();
    }

    public static boolean isSupported() {
        return IS_SUPPORTED.get();
    }

    public static List<String> getStates() {
        return STATES.get();
    }
}

