/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JSeparator;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.managers.AuthServerChecker;
import ru.turikhay.tlauncher.managers.ConnectivityManager;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.loc.LocalizableHTMLLabel;
import ru.turikhay.tlauncher.ui.loc.LocalizableLabel;
import ru.turikhay.tlauncher.ui.swing.ScrollPane;
import ru.turikhay.tlauncher.ui.swing.editor.EditorPane;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedFrame;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.util.SwingUtil;

public class ConnectivityWarning
extends ExtendedFrame
implements LocalizableComponent {
    private static final int WIDTH = SwingUtil.magnify(500);
    private static final int BORDER = SwingUtil.magnify(20);
    private static final int WIDTH_BORDERED = WIDTH - 2 * BORDER;
    private static final int HALF_BORDER = BORDER / 2;
    private final EditorPane body;
    private final ExtendedPanel entriesPanel;
    private boolean tlaunchNotAvailable;
    private boolean noConnection;

    public ConnectivityWarning() {
        this.setIconImages(SwingUtil.createFaviconList("warning"));
        this.setMaximumSize(new Dimension(WIDTH, Integer.MAX_VALUE));
        this.setDefaultCloseOperation(2);
        ExtendedPanel p = new ExtendedPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(BorderFactory.createEmptyBorder(BORDER, BORDER, BORDER, BORDER));
        this.setContentPane(p);
        LocalizableLabel title = new LocalizableLabel("connectivity.warning.title");
        title.setFont(title.getFont().deriveFont(1, title.getFont().getSize2D() + 3.0f));
        title.setIconTextGap(HALF_BORDER);
        title.setIcon(Images.getIcon24("plug-1"));
        this.add(title);
        this.add(Box.createRigidArea(new Dimension(1, BORDER)));
        this.body = new EditorPane();
        this.body.setContentType("text/html");
        this.body.setAlignmentX(0.0f);
        this.body.setAlignmentY(0.0f);
        this.add(this.body);
        this.add(Box.createRigidArea(new Dimension(1, BORDER)));
        this.entriesPanel = new ExtendedPanel();
        this.entriesPanel.setLayout(new GridBagLayout());
        this.entriesPanel.setAlignmentX(0.0f);
        this.entriesPanel.setAlignmentY(0.0f);
        ScrollPane scrollPane = new ScrollPane(this.entriesPanel);
        scrollPane.getViewport().setAlignmentY(0.0f);
        scrollPane.setAlignmentX(0.0f);
        scrollPane.setAlignmentY(0.0f);
        scrollPane.setHBPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scrollPane.setVBPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.add(scrollPane);
        this.updateLocale();
    }

    public void updateEntries(List<ConnectivityManager.Entry> entries) {
        this.entriesPanel.removeAll();
        List unavailableHosts = entries.stream().filter(ConnectivityManager.Entry::isQueued).filter(e -> !e.isReachable()).flatMap(e -> e.getHosts().stream()).sorted().collect(Collectors.toList());
        this.tlaunchNotAvailable = entries.stream().anyMatch(e -> e.getName().equals("llaun.ch") && !e.isReachable());
        this.noConnection = entries.stream().allMatch(e -> e.isDone() && !e.isReachable());
        List unreachableEntries = entries.stream().filter(ConnectivityManager.Entry::isQueued).filter(e -> !e.isReachable()).sorted(Comparator.comparing(ConnectivityManager.Entry::isDone, Boolean::compareTo).reversed().thenComparing(Comparator.comparing(ConnectivityManager.Entry::getPriority).reversed()).thenComparing(ConnectivityManager.Entry::getName)).collect(Collectors.toList());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        if (!this.noConnection && !unreachableEntries.isEmpty()) {
            ++c.gridy;
            this.entriesPanel.add((Component)new JSeparator(), c);
            ++c.gridy;
            this.entriesPanel.add(Box.createRigidArea(new Dimension(1, HALF_BORDER)), c);
            boolean officialRepoUnavailable = unreachableEntries.stream().filter(ConnectivityManager.Entry::isDone).anyMatch(e -> e.getName().equals("official_repo"));
            boolean officialRepoMirrorUnavailable = unreachableEntries.stream().filter(ConnectivityManager.Entry::isDone).anyMatch(e -> e.getName().equals("official_repo_proxy"));
            for (ConnectivityManager.Entry entry : unreachableEntries) {
                String path;
                if (entry.isReachable()) continue;
                BorderPanel panel = new BorderPanel();
                panel.setVgap(SwingUtil.magnify(HALF_BORDER));
                panel.setAlignmentX(0.0f);
                panel.setAlignmentY(0.0f);
                LocalizableLabel name = entry.getName().startsWith("repo_") ? new LocalizableLabel("connectivity.warning.list.name.repo", entry.getName().substring("repo_".length())) : (Localizable.nget(path = "connectivity.warning.list.name." + entry.getName()) != null ? new LocalizableLabel(path) : new LocalizableLabel("connectivity.warning.list.name.web", entry.getName()));
                if (entry.isDone()) {
                    name.setFont(name.getFont().deriveFont(1));
                    Object[] vars = new Object[]{};
                    if (entry.getName().equals("official_repo")) {
                        path = "connectivity.warning.list.hint.official_repo." + (officialRepoMirrorUnavailable ? "not_ok" : "ok");
                    } else if (entry.getName().equals("official_repo_proxy")) {
                        path = "connectivity.warning.list.hint.official_repo_proxy." + (officialRepoUnavailable ? "not_ok" : "ok");
                    } else {
                        path = "connectivity.warning.list.hint." + entry.getName();
                        if (entry.getChecker() instanceof AuthServerChecker && ((AuthServerChecker)entry.getChecker()).getDetectedThirdPartyAuthenticator() != null) {
                            path = path + ".third_party";
                            String thirdPartyAuthenticatorName = ((AuthServerChecker)entry.getChecker()).getDetectedThirdPartyAuthenticator().getName();
                            if (thirdPartyAuthenticatorName == null) {
                                path = path + ".unknown";
                            } else {
                                vars = new Object[]{thirdPartyAuthenticatorName};
                            }
                        }
                    }
                    if (Localizable.nget(path) != null) {
                        LocalizableHTMLLabel hint = new LocalizableHTMLLabel(path, vars);
                        hint.setLabelWidth(WIDTH_BORDERED);
                        panel.setSouth(hint);
                    }
                }
                panel.setWest(name);
                LocalizableLabel status = new LocalizableLabel("connectivity.warning.list.status." + (entry.isDone() ? "unreachable" : "waiting"));
                if (entry.isDone()) {
                    status.setIcon(Images.getIcon16("warning"));
                }
                panel.setEast(status);
                ++c.gridy;
                this.entriesPanel.add((Component)panel, c);
                ++c.gridy;
                this.entriesPanel.add(Box.createRigidArea(new Dimension(1, HALF_BORDER)), c);
                JSeparator s = new JSeparator();
                s.setAlignmentX(0.0f);
                s.setAlignmentY(0.0f);
                ++c.gridy;
                this.entriesPanel.add((Component)s, c);
                ++c.gridy;
                this.entriesPanel.add(Box.createRigidArea(new Dimension(1, HALF_BORDER)), c);
            }
            c.weighty = 1.0;
            ++c.gridy;
            if (unavailableHosts.isEmpty()) {
                this.entriesPanel.add(Box.createRigidArea(new Dimension(1, 1)), c);
            } else {
                this.entriesPanel.add(Box.createRigidArea(new Dimension(1, BORDER)), c);
                c.weighty = 0.0;
                ++c.gridy;
                BorderPanel hostsPanel = new BorderPanel();
                LocalizableButton hostsButton = new LocalizableButton("connectivity.warning.hosts.button");
                hostsButton.addActionListener(e -> Alert.showMessage("", "", String.join((CharSequence)"\n", unavailableHosts)));
                hostsPanel.setEast(hostsButton);
                this.entriesPanel.add((Component)hostsPanel, c);
            }
        }
        this.updateLocale();
        SwingUtil.later(() -> {
            this.revalidate();
            this.repaint();
        });
    }

    @Override
    public void updateLocale() {
        this.setTitle(Localizable.get("connectivity.warning.title"));
        ConnectivityType type = this.noConnection ? ConnectivityType.NONE : ConnectivityType.SOME;
        String bodySuffix = this.noConnection ? "empty" : "text";
        this.body.setText(String.format(Locale.ROOT, "%s <a href=\"%s\">%s</a>", Localizable.get("connectivity.warning.body." + bodySuffix), this.generateConnectivityLink(type), Localizable.get("connectivity.warning.body.link")));
        this.body.setPreferredSize(new Dimension(WIDTH_BORDERED, SwingUtil.getPrefHeight(this.body, WIDTH_BORDERED)));
        this.body.setMaximumSize(new Dimension(WIDTH_BORDERED, SwingUtil.getPrefHeight(this.body, WIDTH_BORDERED)));
    }

    private String generateConnectivityLink(ConnectivityType type) {
        String wikiLangPrefix = TLauncher.getInstance().getSettings().isLikelyRussianSpeakingLocale() ? "" : "en:";
        String linkPrefix = this.tlaunchNotAvailable ? "https://web.archive.org/web/" : "";
        return String.format(Locale.ROOT, "%shttps://wiki.llaun.ch/%sconnectivity:%s", linkPrefix, wikiLangPrefix, type.name().toLowerCase(Locale.ROOT));
    }

    private static enum ConnectivityType {
        SOME,
        NONE;

    }
}

