/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.repository;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.http.client.fluent.Request;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.repository.IRepo;
import ru.turikhay.tlauncher.repository.RepoList;
import ru.turikhay.tlauncher.repository.RepoPrefixV1;
import ru.turikhay.util.EHttpClient;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.StringUtil;
import ru.turikhay.util.U;

public class RepositoryProxy {
    private static final Logger PROXY_LOGGER = LogManager.getLogger(ProxyRepo.class);
    public static final List<String> PROXIFIED_HOSTS = Collections.unmodifiableList(Arrays.asList("launchermeta.mojang.com", "piston-meta.mojang.com", "libraries.minecraft.net", "launcher.mojang.com", "resources.download.minecraft.net", "files.minecraftforge.net", "maven.fabricmc.net", "piston-data.mojang.com"));
    private static final List<String> PROXIES = Collections.unmodifiableList(RepoPrefixV1.prefixesCdnLast().stream().map(prefix -> String.format(Locale.ROOT, "%s/proxy.php?url=", prefix)).collect(Collectors.toList()));
    private static boolean PROXY_WORKED = false;
    private static ProxyRepoList proxyRepoList;

    public static boolean canBeProxied(URL url) {
        return PROXIFIED_HOSTS.stream().anyMatch(host -> url.getHost().equals(host));
    }

    public static String requestMaybeProxy(String url) throws IOException {
        ArrayList<String> urls = new ArrayList<String>();
        urls.add(url);
        URL strictUrl = U.makeURL(url);
        if (RepositoryProxy.canBeProxied(strictUrl)) {
            RepositoryProxy.getProxyRepoList().getRelevant().getList().stream().filter(r -> r instanceof ProxyRepo).map(r -> ((ProxyRepo)r).prefixUrl(strictUrl)).forEach(urls::add);
        }
        IOException ex = null;
        for (String currentUrl : urls) {
            PROXY_LOGGER.debug("Requesting: {}", (Object)currentUrl);
            try {
                return EHttpClient.toString(Request.Get((String)currentUrl));
            }
            catch (IOException ioE) {
                PROXY_LOGGER.warn("Couldn't fetch url {}", (Object)url, (Object)ioE);
                if (ex == null) {
                    ex = ioE;
                    continue;
                }
                ex.addSuppressed(ioE);
            }
        }
        if (ex != null) {
            throw ex;
        }
        throw new IOException("Unable to fetch data over network due to unknown reason");
    }

    public static ProxyRepoList getProxyRepoList() {
        if (proxyRepoList == null) {
            proxyRepoList = new ProxyRepoList();
        }
        return proxyRepoList;
    }

    public static class ProxyRepoList
    extends RepoList {
        private ProxyRepoList() {
            super("ProxyRepo");
            ArrayList proxies = new ArrayList(PROXIES);
            Collections.shuffle(proxies);
            for (String proxy : proxies) {
                this.add(new ProxyRepo(proxy));
            }
        }

        @Override
        protected URLConnection connect(IRepo repo, String path, int timeout, Proxy proxy, int attempt) throws IOException {
            if (repo instanceof ProxyRepo) {
                return ((ProxyRepo)repo).get(path, timeout, proxy, attempt);
            }
            return super.connect(repo, path, timeout, proxy, attempt);
        }
    }

    public static class ProxyRepo
    implements IRepo {
        private static final Logger PROXY_REPO_LOGGER = LogManager.getLogger(ProxyRepo.class);
        private final String proxyPrefix;

        public ProxyRepo(String proxy) {
            this.proxyPrefix = StringUtil.requireNotBlank(proxy);
        }

        @Override
        public URLConnection get(String path, int timeout, Proxy proxy) throws IOException {
            return this.get(path, timeout, proxy, 1);
        }

        public String prefixUrl(URL url) {
            return this.proxyPrefix + ProxyRepo.encodeUrl(url);
        }

        @Override
        public List<String> getHosts() {
            return Collections.singletonList(U.parseHost(this.proxyPrefix));
        }

        public URLConnection get(String path, int timeout, Proxy proxy, int attempt) throws IOException {
            HttpURLConnection connection;
            String hostIp;
            URL originalUrl = ProxyRepo.makeHttpUrl(path);
            IOException ioE = new IOException("not a first attempt; failed");
            if (attempt == 1) {
                PROXY_REPO_LOGGER.debug("First attempt, no proxy: {}", (Object)originalUrl);
                try {
                    return ProxyRepo.openHttpConnection(originalUrl, proxy, timeout);
                }
                catch (IOException ioE1) {
                    ioE = ioE1;
                    PROXY_REPO_LOGGER.warn("Failed to open connection to {}; error: {}", (Object)originalUrl, (Object)ioE.toString());
                    PROXY_REPO_LOGGER.debug((Object)ioE);
                }
            } else {
                PROXY_REPO_LOGGER.debug("Using proxy: {}", (Object)path);
            }
            boolean accepted = false;
            for (String acceptedHost : PROXIFIED_HOSTS) {
                if (!acceptedHost.equals(originalUrl.getHost())) continue;
                accepted = true;
                break;
            }
            try {
                hostIp = InetAddress.getByName(originalUrl.getHost()).getHostAddress();
            }
            catch (Exception e) {
                hostIp = e.toString();
            }
            PROXY_REPO_LOGGER.info("Resolved host {}: {}", (Object)originalUrl.getHost(), (Object)hostIp);
            if (!accepted) {
                PROXY_REPO_LOGGER.warn("Host is not whitelisted to use proxy: {}", (Object)originalUrl.getHost());
                throw ioE;
            }
            String proxyRequestUrl = this.prefixUrl(originalUrl);
            PROXY_REPO_LOGGER.debug("Proxying request to {}: {}", (Object)originalUrl, (Object)proxyRequestUrl);
            try {
                connection = ProxyRepo.openHttpConnection(proxyRequestUrl, proxy, timeout);
            }
            catch (IOException oneMoreIOE) {
                PROXY_REPO_LOGGER.error("Proxying request failed! URL: {}", (Object)proxyRequestUrl);
                throw oneMoreIOE;
            }
            PROXY_REPO_LOGGER.warn("Using proxy ({}) to: {}", (Object)connection.getURL().getHost(), (Object)originalUrl);
            if (!PROXY_WORKED) {
                PROXY_WORKED = true;
            }
            return connection;
        }

        private static HttpURLConnection openHttpConnection(String path, Proxy proxy, int timeout) throws IOException {
            HttpURLConnection httpURLConnection = (HttpURLConnection)ProxyRepo.makeHttpUrl(path).openConnection(proxy);
            ProxyRepo.setupTimeout(httpURLConnection, timeout);
            return httpURLConnection;
        }

        private static HttpURLConnection openHttpConnection(URL url, Proxy proxy, int timeout) throws IOException {
            ProxyRepo.checkHttpUrl(url);
            HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection(proxy);
            ProxyRepo.setupTimeout(httpURLConnection, timeout);
            return httpURLConnection;
        }

        private static void setupTimeout(HttpURLConnection connection, int timeout) {
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
        }

        private static URL makeHttpUrl(String path) throws IOException {
            StringUtil.requireNotBlank(path, "path");
            URL url = new URL(path);
            ProxyRepo.checkHttpUrl(url);
            return url;
        }

        private static void checkHttpUrl(URL url) {
            Objects.requireNonNull(url, "url");
            if (!url.getProtocol().equals("http") && !url.getProtocol().equals("https")) {
                throw new IllegalArgumentException("not an http protocol: " + url);
            }
        }

        private static String encodeUrl(URL url) {
            try {
                return URLEncoder.encode(url.toExternalForm(), FileUtil.getCharset().name());
            }
            catch (UnsupportedEncodingException e) {
                throw new Error("UTF-8 not supported?");
            }
        }
    }
}

