/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.repository.AppenderRepoList;
import ru.turikhay.tlauncher.repository.RepoList;
import ru.turikhay.tlauncher.repository.RepositoryProxy;

public enum Repository {
    LOCAL_VERSION_REPO,
    OFFICIAL_VERSION_REPO(TLauncher.getOfficialRepo()),
    EXTRA_VERSION_REPO(TLauncher.getExtraRepo()),
    ASSETS_REPO(TLauncher.getAssetsRepo()),
    LIBRARY_REPO(TLauncher.getLibraryRepo()),
    SERVERLIST_REPO(TLauncher.getServerList()),
    PROXIFIED_REPO(RepositoryProxy.getProxyRepoList());

    private static final Logger LOGGER;
    public static final Repository[] VERSION_REPOS;
    private final RepoList defaultRepoList;
    private RepoList repoList;
    private final String lowerName = this.name().toLowerCase(Locale.ROOT);

    private Repository(List<String> urlList) {
        this.defaultRepoList = new AppenderRepoList(this.name(), Objects.requireNonNull(urlList, "defaultUrlList"));
    }

    private Repository(RepoList repoList) {
        this.defaultRepoList = Objects.requireNonNull(repoList, "repoList");
    }

    private Repository() {
        this(Collections.emptyList());
    }

    public RepoList getList() {
        return this.repoList == null ? this.defaultRepoList : this.repoList;
    }

    public RepoList.RelevantRepoList getRelevant() {
        return this.getList().getRelevant();
    }

    public InputStream get(String path) throws IOException {
        return this.getList().read(path);
    }

    public InputStreamReader read(String path) throws IOException {
        return new InputStreamReader(this.get(path), "UTF-8");
    }

    public boolean isRemote() {
        return this.getRelevant().getFirst() != null;
    }

    private void update(List<String> repoList) {
        if (repoList == null) {
            LOGGER.debug("repoList passed to is null; {} update discarded", (Object)this.name());
            return;
        }
        this.repoList = new AppenderRepoList(this.name(), repoList);
    }

    public static void updateList(Map<String, List<String>> repoMap) {
        if (repoMap == null) {
            LOGGER.debug("repoMap is null; update discarded");
            return;
        }
        block0: for (Map.Entry<String, List<String>> entry : repoMap.entrySet()) {
            for (Repository repo : Repository.values()) {
                if (!repo.lowerName.equals(entry.getKey())) continue;
                repo.update(entry.getValue());
                continue block0;
            }
        }
    }

    static {
        LOGGER = LogManager.getLogger(Repository.class);
        VERSION_REPOS = new Repository[]{LOCAL_VERSION_REPO, OFFICIAL_VERSION_REPO, EXTRA_VERSION_REPO};
    }
}

