/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.repository;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.repository.AppenderRepo;
import ru.turikhay.tlauncher.repository.IRepo;
import ru.turikhay.util.Time;
import ru.turikhay.util.U;

public class RepoList {
    private static final Logger LOGGER = LogManager.getLogger(RepoList.class);
    private static final int FILE_BUFFER = 8192;
    private static final long GLOBAL_BUFFER_MAX = 0xA00000L;
    private static final AtomicLong GLOBAL_BUFFER = new AtomicLong();
    private final String name;
    private final Object sync = new Object();
    private final ArrayList<IRepo> list = new ArrayList();
    private RelevantRepoList relevant = new RelevantRepoList();

    public RepoList(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("name");
        }
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public final RelevantRepoList getRelevant() {
        return this.relevant;
    }

    public InputStream read(String path, Proxy proxy) throws IOException {
        IOException ex = null;
        List<IRepo> l = this.getRelevant().getList();
        int timeout = U.getConnectionTimeout();
        Object total = new Object();
        Time.start(total);
        LOGGER.debug("Fetching from {}: \"{}\", timeout: {}, proxy: {}", (Object)this.name, (Object)path, (Object)(timeout / 1000), (Object)proxy);
        int attempt = 0;
        for (IRepo repo : l) {
            String _path;
            ++attempt;
            Object current = new Object();
            Time.start(current);
            if (repo instanceof AppenderRepo) {
                try {
                    _path = String.valueOf(((AppenderRepo)repo).makeUrl(path));
                }
                catch (IOException ioE) {
                    _path = "(failed to make url: \"" + path + "\")";
                }
            } else {
                _path = path;
            }
            try {
                InputStream result = this.read(this.connect(repo, path, timeout, proxy, attempt));
                long[] deltas = Time.stop(total, current);
                LOGGER.debug("Fetched successfully from {}: \"{}\": {} ms; total: {} ms, attempt: {}", (Object)this.name, (Object)_path, (Object)deltas[1], (Object)deltas[0], (Object)attempt);
                return result;
            }
            catch (IOException ioE) {
                LOGGER.error("Failed to fetch from {}: \"{}\": attempt: {}, exception: {}", (Object)this.name, (Object)_path, (Object)attempt, (Object)ioE.toString());
                if (ex == null) {
                    ex = ioE;
                    continue;
                }
                ex.addSuppressed(ioE);
            }
        }
        if (ex != null) {
            throw ex;
        }
        throw new IOException("Unable to fetch repo due to unknown reason");
    }

    public final InputStream read(String path) throws IOException {
        return this.read(path, U.getProxy());
    }

    protected URLConnection connect(IRepo repo, String path, int timeout, Proxy proxy, int attempt) throws IOException {
        return repo.get(path, timeout, proxy);
    }

    protected InputStream read(URLConnection connection) throws IOException {
        int size = connection instanceof HttpURLConnection ? connection.getContentLength() : -1;
        InputStream in = connection.getInputStream();
        return this.read(in, size);
    }

    private InputStream read(InputStream in, int size) throws IOException {
        try {
            return this.readIntoBuffer(in, size);
        }
        catch (BufferException bufferException) {
            try {
                return this.readIntoFile(in);
            }
            catch (BufferException repoException) {
                LOGGER.error("Could not read into file from {}", (Object)this.name, (Object)repoException);
                return in;
            }
        }
    }

    private InputStream readIntoBuffer(InputStream in, final int size) throws BufferException, IOException {
        if (size < 1) {
            throw new BufferException("input too small");
        }
        if (GLOBAL_BUFFER.addAndGet(size) > 0xA00000L) {
            throw new BufferException("buffer is full");
        }
        byte[] buffer = new byte[size];
        IOUtils.read((InputStream)in, (byte[])buffer);
        return new FilterInputStream(new ByteArrayInputStream(buffer)){

            @Override
            public void close() throws IOException {
                GLOBAL_BUFFER.addAndGet(-size);
                super.close();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream readIntoFile(InputStream in) throws BufferException, IOException {
        if (GLOBAL_BUFFER.addAndGet(8192L) > 0xA00000L) {
            throw new BufferException("buffer is full");
        }
        final File temp = File.createTempFile("tlauncher-repo", null);
        temp.deleteOnExit();
        try (FileOutputStream out = new FileOutputStream(temp);){
            IOUtils.copy((InputStream)new BufferedInputStream(in, 8192), (OutputStream)out);
        }
        finally {
            GLOBAL_BUFFER.addAndGet(-8192L);
        }
        return new FilterInputStream(new FileInputStream(temp)){

            @Override
            public void close() throws IOException {
                super.close();
                temp.delete();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(IRepo repo) {
        Object object = this.sync;
        synchronized (object) {
            if (this.list.contains(repo)) {
                throw new IllegalArgumentException("repo already added");
            }
            this.list.add(repo);
            this.relevant = this.makeRelevantRepoList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markInvalid(IRepo repo) {
        Object object = this.sync;
        synchronized (object) {
            int index = this.list.indexOf(repo);
            if (index == -1 || index == this.list.size() - 1) {
                return;
            }
            this.list.add(repo);
            this.list.remove(repo);
            this.relevant = this.makeRelevantRepoList();
        }
    }

    protected RelevantRepoList makeRelevantRepoList() {
        return new RelevantRepoList();
    }

    public class RelevantRepoList {
        private final List<IRepo> repoList;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected RelevantRepoList() {
            Object object = RepoList.this.sync;
            synchronized (object) {
                this.repoList = Collections.unmodifiableList(new ArrayList(RepoList.this.list));
            }
        }

        public List<IRepo> getList() {
            return this.repoList;
        }

        public IRepo getFirst() {
            return this.repoList.isEmpty() ? null : this.repoList.get(0);
        }
    }

    private static class BufferException
    extends Exception {
        BufferException(String description) {
            super(description);
        }
    }
}

