/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.repository;

import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.Objects;
import ru.turikhay.tlauncher.repository.IRepo;
import ru.turikhay.util.U;

public abstract class Repo
implements IRepo {
    private final String name;

    public Repo(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public final URLConnection get(String path, int timeout, Proxy proxy) throws IOException {
        URL url = Objects.requireNonNull(this.makeUrl(path), "url");
        return this.makeConnection(url, timeout, proxy);
    }

    public final URLConnection get(String path, int timeout) throws IOException {
        return this.get(path, timeout, U.getProxy());
    }

    public final URLConnection get(String path) throws IOException {
        return this.get(path, U.getReadTimeout());
    }

    protected URLConnection makeConnection(URL url, int timeout, Proxy proxy) throws IOException {
        URLConnection connection = url.openConnection(proxy);
        connection.setConnectTimeout(timeout);
        connection.setReadTimeout(timeout);
        connection.setUseCaches(false);
        connection.setDefaultUseCaches(false);
        connection.setRequestProperty("Cache-Control", "no-cache, no-store, must-revalidate");
        connection.setRequestProperty("Pragma", "no-cache");
        connection.setRequestProperty("Expires", "0");
        return connection;
    }

    protected abstract URL makeUrl(String var1) throws IOException;
}

