/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.repository;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import ru.turikhay.tlauncher.repository.Repo;
import ru.turikhay.util.U;

public class AppenderRepo
extends Repo {
    private final String prefix;
    private final String suffix;

    public AppenderRepo(String prefix, String suffix) {
        super(prefix);
        if (StringUtils.isEmpty((CharSequence)prefix)) {
            throw new IllegalArgumentException("prefix is empty");
        }
        if (StringUtils.isEmpty((CharSequence)suffix)) {
            suffix = null;
        }
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public AppenderRepo(String prefix) {
        this(prefix, null);
    }

    @Override
    protected URL makeUrl(String path) throws IOException {
        String url = this.suffix == null ? this.prefix + path : this.prefix + path + this.suffix;
        return new URL(url);
    }

    @Override
    public List<String> getHosts() {
        return Collections.singletonList(U.parseHost(this.prefix));
    }
}

