/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.portals;

import com.sun.jna.Library;
import com.sun.jna.Native;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.freedesktop.dbus.FileDescriptor;
import org.freedesktop.dbus.connections.IDisconnectCallback;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.types.Variant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.turikhay.tlauncher.portals.Portal;
import ru.turikhay.tlauncher.portals.dbus.OpenURIInterface;
import ru.turikhay.tlauncher.portals.dbus.SettingsInterface;

public class XDGPortal
implements Portal,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(XDGPortal.class);
    private final DBusConnection session;
    private final OpenURIInterface openURIInterface;
    private final SettingsInterface settingsInterface;

    private XDGPortal(DBusConnection session) throws DBusException {
        this.session = session;
        this.openURIInterface = (OpenURIInterface)session.getRemoteObject("org.freedesktop.portal.Desktop", "/org/freedesktop/portal/desktop", OpenURIInterface.class);
        this.settingsInterface = (SettingsInterface)session.getRemoteObject("org.freedesktop.portal.Desktop", "/org/freedesktop/portal/desktop", SettingsInterface.class);
    }

    @Override
    public void close() throws IOException {
        this.session.close();
    }

    @Override
    public boolean openURI(URI uri) {
        try {
            this.openURIInterface.OpenURI("", uri.toString(), Collections.emptyMap());
            return true;
        }
        catch (DBusExecutionException e) {
            return false;
        }
    }

    @Override
    public boolean openDirectory(Path path) {
        try {
            HashMap options = new HashMap();
            options.put("writable", new Variant((Object)false));
            int fd = CLibrary.INSTANCE.open(path.toString(), 524288);
            this.openURIInterface.OpenDirectory("", new FileDescriptor(fd), options);
            CLibrary.INSTANCE.close(fd);
            return true;
        }
        catch (DBusExecutionException e) {
            return false;
        }
    }

    @Override
    public boolean openFile(Path path) {
        try {
            HashMap options = new HashMap();
            options.put("writable", new Variant((Object)false));
            int fd = CLibrary.INSTANCE.open(path.toString(), 524288);
            this.openURIInterface.OpenFile("", new FileDescriptor(fd), options);
            CLibrary.INSTANCE.close(fd);
            return true;
        }
        catch (DBusExecutionException e) {
            return false;
        }
    }

    @Override
    public Portal.ColorScheme getColorScheme() {
        try {
            Variant colorScheme = (Variant)this.settingsInterface.Read("org.freedesktop.appearance", "color-scheme");
            switch (((UInt32)colorScheme.getValue()).intValue()) {
                default: {
                    return Portal.ColorScheme.NO_PREFERENCE;
                }
                case 1: {
                    return Portal.ColorScheme.PREFER_DARK;
                }
                case 2: 
            }
            return Portal.ColorScheme.PREFER_LIGHT;
        }
        catch (DBusExecutionException e) {
            return Portal.ColorScheme.NO_PREFERENCE;
        }
    }

    public static Optional<Portal> tryToCreate() {
        Callable<DBusConnection> sessionFactory = () -> ((DBusConnectionBuilder)DBusConnectionBuilder.forSessionBus().withDisconnectCallback((IDisconnectCallback)new DBusDisconnectionLogger())).build();
        try {
            return Optional.of(new XDGPortal(sessionFactory.call()));
        }
        catch (Throwable t) {
            LOGGER.warn("Couldn't open D-Bus connection", t);
            return Optional.empty();
        }
    }

    public static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.load((String)"c", CLibrary.class);
        public static final int O_RDONLY = 0;
        public static final int O_CLOEXEC = 524288;

        public int open(String var1, int var2);

        public int close(int var1);
    }

    private static class DBusDisconnectionLogger
    implements IDisconnectCallback {
        private DBusDisconnectionLogger() {
        }

        public void disconnectOnError(IOException e) {
            LOGGER.error("DBus session terminated due to an error", (Throwable)e);
        }
    }
}

