/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.pasta;

import java.net.URL;
import ru.turikhay.tlauncher.pasta.Pasta;

public abstract class PastaResult {
    private final Pasta pasta;

    PastaResult(Pasta pasta) {
        this.pasta = pasta;
    }

    public final Pasta getPaste() {
        return this.pasta;
    }

    public static class PastaUploaded
    extends PastaResult {
        private final URL url;

        PastaUploaded(Pasta pasta, URL url) {
            super(pasta);
            this.url = url;
        }

        public final URL getURL() {
            return this.url;
        }

        public String toString() {
            return "PastaUploaded{url='" + this.url + "'}";
        }
    }

    public static class PastaFailed
    extends PastaResult {
        private final Throwable error;

        PastaFailed(Pasta pasta, Throwable error) {
            super(pasta);
            this.error = error;
        }

        public final Throwable getError() {
            return this.error;
        }

        public String toString() {
            return "PastaFailed{error='" + this.error + "'}";
        }
    }
}

