/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.pasta;

import io.sentry.Sentry;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.interfaces.ExceptionInterface;
import io.sentry.event.interfaces.SentryInterface;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.logger.LogFile;
import ru.turikhay.tlauncher.pasta.PastaException;
import ru.turikhay.tlauncher.pasta.PastaFormat;
import ru.turikhay.tlauncher.pasta.PastaListener;
import ru.turikhay.tlauncher.pasta.PastaResult;
import ru.turikhay.tlauncher.pasta.PastaTooLong;
import ru.turikhay.tlauncher.pasta.PastaUnavailable;
import ru.turikhay.tlauncher.pasta.TooManyRequests;
import ru.turikhay.util.CharsetData;
import ru.turikhay.util.CharsetDataHttpEntity;
import ru.turikhay.util.EHttpClient;
import ru.turikhay.util.StringCharsetData;

public class Pasta {
    private static final Logger LOGGER = LogManager.getLogger(Pasta.class);
    private static final String CREATE_PASTE_URL = "https://pasta.llaun.ch/create/v1";
    private static final int RESPONSE_OK = 201;
    private static final int RESPONSE_ERROR_TOO_LONG = 413;
    private static final int RESPONSE_ERROR_TOO_MANY_REQUESTS = 429;
    private CharsetData data;
    private boolean ignoreTooManyRequests;
    private PastaFormat format = PastaFormat.LOGS;
    private final ArrayList<PastaListener> listeners = new ArrayList();
    private PastaResult result;

    public void setIgnoreTooManyRequests() {
        this.ignoreTooManyRequests = true;
    }

    public void setData(CharsetData data) {
        this.data = data;
    }

    public void setFormat(PastaFormat format) {
        this.format = format;
    }

    public void addListener(PastaListener listener) {
        this.listeners.add(listener);
    }

    public PastaResult getResult() {
        return this.result;
    }

    public PastaResult paste() {
        for (PastaListener l : this.listeners) {
            l.pasteUploading(this);
        }
        try {
            this.result = this.doPaste();
        }
        catch (Throwable e) {
            LOGGER.error("Could not upload paste", e);
            if (!(e instanceof PastaException)) {
                Sentry.capture((EventBuilder)new EventBuilder().withMessage("pasta not sent").withExtra("sample", (Object)this.getSample()).withLevel(Event.Level.ERROR).withSentryInterface((SentryInterface)new ExceptionInterface(e)));
            }
            this.result = new PastaResult.PastaFailed(this, e);
        }
        for (PastaListener l : this.listeners) {
            l.pasteDone(this);
        }
        return this.result;
    }

    private PastaResult.PastaUploaded doPaste() throws IOException {
        CharsetData data = this.data;
        boolean ignoreTmr = this.ignoreTooManyRequests;
        PastaFormat format = this.format;
        if (data == null) {
            throw new NullPointerException("data");
        }
        long length = data.length();
        if (length == 0L) {
            throw new RuntimeException("data is empty");
        }
        try (CloseableHttpClient httpClient = EHttpClient.createRepeatable();){
            PastaResult.PastaUploaded result = null;
            for (int attempt = 1; attempt <= 2; ++attempt) {
                try {
                    result = this.makeRequest((HttpClient)httpClient, data, format);
                    break;
                }
                catch (TooManyRequests tmr) {
                    if (ignoreTmr) {
                        throw tmr;
                    }
                    int waitTime = (attempt > 1 ? 61 : 31) + new Random().nextInt(10);
                    LOGGER.warn("Pasta could not be sent because of the rate limit (attempt {}, wait time {}s)", (Object)attempt, (Object)waitTime);
                    try {
                        Thread.sleep((long)waitTime * 1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("interrupted", e);
                    }
                }
            }
            if (result == null) {
                throw new TooManyRequests();
            }
            LOGGER.info("Pasta has been sent successfully: {}", (Object)result.getURL());
            PastaResult.PastaUploaded pastaUploaded = result;
            return pastaUploaded;
        }
    }

    private PastaResult.PastaUploaded makeRequest(HttpClient httpClient, CharsetData data, PastaFormat format) throws IOException {
        HttpPost httpPost = new HttpPost(CREATE_PASTE_URL);
        httpPost.setHeader("Content-Type", format.getContentType().withCharset(StandardCharsets.UTF_8).toString());
        httpPost.setEntity((HttpEntity)new CharsetDataHttpEntity(data));
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        int statusCode = response.getStatusLine().getStatusCode();
        switch (statusCode) {
            case 201: {
                return this.readSuccess(response);
            }
            case 413: {
                throw new PastaTooLong(data.length());
            }
            case 429: {
                throw new TooManyRequests();
            }
        }
        throw new PastaUnavailable(statusCode, EntityUtils.toString((HttpEntity)response.getEntity()));
    }

    private PastaResult.PastaUploaded readSuccess(HttpResponse response) throws IOException {
        String result = EntityUtils.toString((HttpEntity)response.getEntity());
        if (result.startsWith("http")) {
            URL urlLink;
            try {
                urlLink = new URL(result);
            }
            catch (MalformedURLException e) {
                urlLink = null;
            }
            if (urlLink != null) {
                return new PastaResult.PastaUploaded(this, urlLink);
            }
        }
        throw new PastaUnavailable(response.getStatusLine().getStatusCode(), result);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getSample() {
        try (Reader reader = this.data.read();){
            StringWriter writer;
            block16: {
                String string;
                writer = new StringWriter();
                try {
                    char[] buffer = new char[256];
                    int read = reader.read(buffer);
                    if (read > 0) {
                        writer.write(buffer, 0, read);
                        break block16;
                    }
                    string = "empty sample";
                }
                catch (Throwable throwable) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                writer.close();
                return string;
            }
            String string = writer.toString();
            writer.close();
            return string;
        }
        catch (IOException e) {
            LOGGER.warn("Error reading sample", (Throwable)e);
            return "couldn't get sample: " + e;
        }
    }

    public static String paste(CharsetData data, PastaFormat format) {
        Pasta pasta = new Pasta();
        pasta.setData(data);
        pasta.setIgnoreTooManyRequests();
        pasta.setFormat(format);
        PastaResult result = pasta.paste();
        if (result instanceof PastaResult.PastaUploaded) {
            return ((PastaResult.PastaUploaded)result).getURL().toExternalForm();
        }
        if (result instanceof PastaResult.PastaFailed) {
            return "pasta: " + ((PastaResult.PastaFailed)result).getError().toString();
        }
        return "pasta: not available";
    }

    public static String paste(String data, PastaFormat format) {
        if (data == null) {
            return "pasta: input null";
        }
        if (StringUtils.isBlank((CharSequence)data)) {
            return "pasta: input blank";
        }
        return Pasta.paste(new StringCharsetData(data), format);
    }

    public static String pasteJson(String json) {
        return Pasta.paste(json, PastaFormat.JSON);
    }

    public static String pasteFile(File file, PastaFormat format, Charset charset) {
        if (file == null) {
            return "pasta: file null";
        }
        if (!file.isFile()) {
            return "pasta: not a file: " + file.getAbsolutePath();
        }
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        return Pasta.paste(new LogFile(file, charset), format);
    }

    public static String pasteFile(File file, PastaFormat format) {
        return Pasta.pasteFile(file, format, null);
    }

    public static String pasteFile(File file) {
        return Pasta.pasteFile(file, PastaFormat.PLAIN);
    }
}

