/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft.launcher.hooks;

import com.sun.jna.platform.win32.WinReg;
import io.sentry.Sentry;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.interfaces.ExceptionInterface;
import io.sentry.event.interfaces.SentryInterface;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.jna.JNAException;
import ru.turikhay.tlauncher.jna.JNAWindows;
import ru.turikhay.tlauncher.minecraft.launcher.ProcessHook;
import ru.turikhay.util.OS;

public class WindowsGpuPreferenceHook
implements ProcessHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowsGpuPreferenceHook.class);
    private static final int GPU_PREFERENCE_WINDOWS_BUILD = 20190;
    private static final String GPU_PREFERENCE_REG_KEY = "Software\\Microsoft\\DirectX\\UserGpuPreferences";
    private static final String GPU_PREFERENCE_VALUE = "GpuPreference=%d;";
    private final Preference preference;

    public WindowsGpuPreferenceHook(Preference preference) {
        this.preference = preference;
    }

    @Override
    public void enrichProcess(ProcessBuilder process) {
        String currentValue;
        if (!WindowsGpuPreferenceHook.isSupported()) {
            return;
        }
        Optional<Integer> buildOpt = JNAWindows.getBuildNumber();
        if (!buildOpt.isPresent()) {
            LOGGER.warn("Couldn't find current Windows build. Is JNA enabled? Setting GPU performance is disabled");
            return;
        }
        List<String> command = process.command();
        if (command.isEmpty()) {
            LOGGER.info("Process command is empty, wat?");
            return;
        }
        Path path = Paths.get(command.get(0), new String[0]);
        if (!path.isAbsolute()) {
            LOGGER.warn("JRE executable is not absolute ({}), setting GPU performance is disabled", (Object)path);
            Sentry.capture((EventBuilder)new EventBuilder().withLevel(Event.Level.INFO).withMessage("jreExec is not absolute").withExtra("jreExec", (Object)path));
            return;
        }
        Optional<JNAWindows.Registry> registryOpt = JNAWindows.getRegistry();
        if (!registryOpt.isPresent()) {
            LOGGER.warn("Registry is not available");
            return;
        }
        JNAWindows.Registry reg = registryOpt.get();
        String expectedValue = String.format(GPU_PREFERENCE_VALUE, this.preference.registryValue);
        try {
            currentValue = reg.getString(WinReg.HKEY_CURRENT_USER, GPU_PREFERENCE_REG_KEY, path.toString());
        }
        catch (JNAException e) {
            Sentry.capture((EventBuilder)new EventBuilder().withLevel(Event.Level.ERROR).withMessage("couldn't get GpuPreference").withSentryInterface((SentryInterface)new ExceptionInterface((Throwable)e)).withExtra("windowsBuild", (Object)buildOpt.get()).withExtra("jreExec", (Object)path));
            LOGGER.error("Couldn't fetch current GPU preference. Setting it was skipped.", (Throwable)e);
            return;
        }
        if (expectedValue.equals(currentValue)) {
            LOGGER.debug("Skipping setting GPU Preference. Current value is matched expected one for {}: {}", (Object)path, (Object)currentValue);
            return;
        }
        LOGGER.info("Setting GpuPreference value for {}: {}", (Object)path, (Object)expectedValue);
        try {
            reg.setString(WinReg.HKEY_CURRENT_USER, GPU_PREFERENCE_REG_KEY, path.toString(), expectedValue);
        }
        catch (JNAException e) {
            Sentry.capture((EventBuilder)new EventBuilder().withLevel(Event.Level.ERROR).withMessage("couldn't set GpuPreference").withSentryInterface((SentryInterface)new ExceptionInterface((Throwable)e)).withExtra("windowsBuild", (Object)buildOpt.get()).withExtra("jreExec", (Object)path));
            LOGGER.error("Couldn't set current GPU preference", (Throwable)e);
        }
    }

    public static boolean isSupported() {
        if (!OS.WINDOWS.isCurrent() || !TLauncher.getInstance().getSettings().getBoolean("windows.gpuperf")) {
            return false;
        }
        Optional<Integer> buildOpt = JNAWindows.getBuildNumber();
        if (!buildOpt.isPresent()) {
            LOGGER.warn("Couldn't find current Windows build. Is JNA enabled? Setting GPU performance is disabled");
            return false;
        }
        if (buildOpt.get() < 20190) {
            LOGGER.info("Current Windows build ({}) doesn't support setting GPU preference through registry", (Object)buildOpt.get());
            return false;
        }
        return true;
    }

    public static enum Preference {
        Unspecified(0),
        MinimumPower(1),
        HighPerformance(2);

        private final int registryValue;

        private Preference(int registryValue) {
            this.registryValue = registryValue;
        }

        public int getRegistryValue() {
            return this.registryValue;
        }
    }
}

