/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft.launcher.hooks;

import com.sun.jna.Library;
import com.sun.jna.Native;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.freedesktop.dbus.FileDescriptor;
import org.freedesktop.dbus.connections.IDisconnectCallback;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.turikhay.tlauncher.minecraft.launcher.ProcessHook;
import ru.turikhay.tlauncher.minecraft.launcher.hooks.GameModeInterface;
import ru.turikhay.util.JavaVersion;

public class GameModeHook
implements ProcessHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(GameModeHook.class);
    private final GameModeInterface gameModeInterface;
    private final Map<Process, GameModeEntry> fdMap = new WeakHashMap<Process, GameModeEntry>();

    public GameModeHook(DBusConnection session) throws DBusException {
        this.gameModeInterface = (GameModeInterface)session.getRemoteObject("com.feralinteractive.GameMode", "/com/feralinteractive/GameMode", GameModeInterface.class);
    }

    protected static Optional<ProcessHook> tryToCreate() {
        try {
            Callable<DBusConnection> sessionFactory = () -> ((DBusConnectionBuilder)DBusConnectionBuilder.forSessionBus().withDisconnectCallback((IDisconnectCallback)new DBusDisconnectionLogger())).build();
            try {
                return Optional.of(new GameModeHook(sessionFactory.call()));
            }
            catch (Throwable t) {
                return Optional.empty();
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return Optional.empty();
        }
    }

    @Override
    public void processCreated(Process process) {
        try {
            int gamePidFd;
            int callerPidFd;
            int callerPid = (int)ProcessHandle.current().pid();
            int gamePid = (int)process.pid();
            try {
                callerPidFd = CLibrary.INSTANCE.pidfd_open(callerPid, 0);
                gamePidFd = CLibrary.INSTANCE.pidfd_open(gamePid, 0);
            }
            catch (UnsatisfiedLinkError e) {
                callerPidFd = -1;
                gamePidFd = -1;
            }
            if (callerPidFd >= 0 && gamePidFd >= 0) {
                this.fdMap.put(process, new GameModeEntry(callerPid, gamePid, new FileDescriptor(callerPidFd), new FileDescriptor(gamePidFd)));
                this.gameModeInterface.RegisterGameByPIDFd(new FileDescriptor(callerPidFd), new FileDescriptor(gamePidFd));
                LOGGER.info("Minecraft process registered in GameMode. Pids: {} / {}, FDs: {} / {}", new Object[]{callerPid, gamePid, callerPidFd, gamePidFd});
            } else {
                this.fdMap.put(process, new GameModeEntry(callerPid, gamePid));
                this.gameModeInterface.RegisterGameByPID(callerPid, gamePid);
                LOGGER.info("Minecraft process registered in GameMode. Pids: {} / {}", (Object)callerPid, (Object)gamePid);
            }
        }
        catch (DBusExecutionException dBusExecutionException) {
            // empty catch block
        }
    }

    @Override
    public void processDestroyed(Process process) {
        try {
            GameModeEntry entry = this.fdMap.remove(process);
            if (entry == null) {
                LOGGER.warn("GameMode registration lost (that's a bug), trying to unregister with generic way...");
                int callerPid = (int)ProcessHandle.current().pid();
                int gamePid = (int)process.pid();
                this.gameModeInterface.UnregisterGameByPID(callerPid, gamePid);
                LOGGER.info("Minecraft process unregistered in GameMode. Pids: {} / {}", (Object)callerPid, (Object)gamePid);
            } else if (entry.getCallerPidFd() != null && entry.getGamePidFd() != null) {
                this.gameModeInterface.UnregisterGameByPIDFd(entry.getCallerPidFd(), entry.getGamePidFd());
                LOGGER.info("Minecraft process unregistered in GameMode. Pids: {} / {}, FDs: {} / {}", new Object[]{entry.getCallerPid(), entry.getGamePid(), entry.getCallerPidFd().getIntFileDescriptor(), entry.getGamePidFd().getIntFileDescriptor()});
                CLibrary.INSTANCE.close(entry.getGamePidFd().getIntFileDescriptor());
                CLibrary.INSTANCE.close(entry.getCallerPidFd().getIntFileDescriptor());
            } else {
                this.gameModeInterface.UnregisterGameByPID(entry.getCallerPid(), entry.getGamePid());
                LOGGER.info("Minecraft process unregistered in GameMode. Pids: {} / {}", (Object)entry.getCallerPid(), (Object)entry.getGamePid());
            }
        }
        catch (DBusExecutionException dBusExecutionException) {
            // empty catch block
        }
    }

    public static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.load((String)"c", CLibrary.class);
        public static final int SYS_pidfd_open = 434;

        public int close(int var1);

        public int syscall(int var1, Object ... var2);

        default public int pidfd_open(int pid, int flags) {
            return this.syscall(434, pid, flags);
        }
    }

    private static class GameModeEntry {
        private final int callerPid;
        private final int gamePid;
        @Nullable
        private final FileDescriptor callerPidFd;
        @Nullable
        private final FileDescriptor gamePidFd;

        GameModeEntry(int callerPid, int gamePid, @Nullable FileDescriptor callerPidFd, @Nullable FileDescriptor gamePidFd) {
            this.callerPid = callerPid;
            this.gamePid = gamePid;
            this.callerPidFd = callerPidFd;
            this.gamePidFd = gamePidFd;
        }

        GameModeEntry(int callerPid, int gamePid) {
            this(callerPid, gamePid, null, null);
        }

        public int getCallerPid() {
            return this.callerPid;
        }

        public int getGamePid() {
            return this.gamePid;
        }

        @Nullable
        public FileDescriptor getCallerPidFd() {
            return this.callerPidFd;
        }

        @Nullable
        public FileDescriptor getGamePidFd() {
            return this.gamePidFd;
        }
    }

    private static class DBusDisconnectionLogger
    implements IDisconnectCallback {
        private DBusDisconnectionLogger() {
        }

        public void disconnectOnError(IOException e) {
            LOGGER.error("DBus session terminated due to an error", (Throwable)e);
        }
    }

    public static class Loader {
        private static final Logger LOGGER = LoggerFactory.getLogger(Loader.class);

        public static Optional<ProcessHook> tryToCreate() {
            if (JavaVersion.getCurrent().getMajor() >= 11) {
                return GameModeHook.tryToCreate();
            }
            LOGGER.info("GameModeHook is not available because it requires Java 11+");
            return Optional.empty();
        }
    }
}

