/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft.launcher;

import java.util.Objects;
import ru.turikhay.tlauncher.minecraft.crash.CrashManager;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftException;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftListener;
import ru.turikhay.util.SwingUtil;

public class SwingMinecraftListener
implements MinecraftListener {
    private final MinecraftListener listener;

    public SwingMinecraftListener(MinecraftListener listener) {
        this.listener = Objects.requireNonNull(listener, "listener");
    }

    @Override
    public void onMinecraftPrepare() {
        SwingUtil.later(this.listener::onMinecraftPrepare);
    }

    @Override
    public void onMinecraftAbort() {
        SwingUtil.later(this.listener::onMinecraftAbort);
    }

    @Override
    public void onMinecraftLaunch() {
        SwingUtil.later(this.listener::onMinecraftLaunch);
    }

    @Override
    public void onMinecraftClose() {
        SwingUtil.later(this.listener::onMinecraftClose);
    }

    @Override
    public void onMinecraftError(Throwable var1) {
        SwingUtil.later(() -> this.listener.onMinecraftError(var1));
    }

    @Override
    public void onMinecraftKnownError(MinecraftException var1) {
        SwingUtil.later(() -> this.listener.onMinecraftKnownError(var1));
    }

    @Override
    public void onCrashManagerInit(CrashManager manager) {
        SwingUtil.wait(() -> this.listener.onCrashManagerInit(manager));
    }
}

