/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft.launcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public interface ProcessHook {
    default public void enrichProcess(ProcessBuilder process) {
    }

    default public void processCreated(Process process) {
    }

    default public void processDestroyed(Process process) {
    }

    default public ProcessHook then(ProcessHook hook) {
        return new Merger(this, hook);
    }

    public static class Merger
    implements ProcessHook {
        private final Collection<ProcessHook> hooks;

        public Merger(Collection<ProcessHook> hooks) {
            this.hooks = hooks;
        }

        public Merger(ProcessHook ... hooks) {
            this(Arrays.asList(hooks));
        }

        @Override
        public ProcessHook then(ProcessHook hook) {
            ArrayList<ProcessHook> hooks = new ArrayList<ProcessHook>(this.hooks.size() + 1);
            hooks.addAll(this.hooks);
            hooks.add(hook);
            return new Merger(hooks);
        }

        @Override
        public void enrichProcess(ProcessBuilder process) {
            this.hooks.forEach(hook -> hook.enrichProcess(process));
        }

        @Override
        public void processCreated(Process process) {
            this.hooks.forEach(hook -> hook.processCreated(process));
        }

        @Override
        public void processDestroyed(Process process) {
            this.hooks.forEach(hook -> hook.processDestroyed(process));
        }
    }

    public static class None
    implements ProcessHook {
        public static final ProcessHook INSTANCE = new None();

        private None() {
        }

        @Override
        public ProcessHook then(ProcessHook hook) {
            return hook;
        }
    }
}

