/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft.launcher;

import com.google.gson.Gson;
import io.sentry.Sentry;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.interfaces.ExceptionInterface;
import io.sentry.event.interfaces.SentryInterface;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import me.cortex.jarscanner.Detector;
import net.minecraft.launcher.process.JavaProcess;
import net.minecraft.launcher.process.JavaProcessLauncher;
import net.minecraft.launcher.process.JavaProcessListener;
import net.minecraft.launcher.process.PrintStreamType;
import net.minecraft.launcher.updater.AssetIndex;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.ArgumentType;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.CurrentLaunchFeatureMatcher;
import net.minecraft.launcher.versions.ExtractRules;
import net.minecraft.launcher.versions.Library;
import net.minecraft.launcher.versions.ModpackType;
import net.minecraft.launcher.versions.ReleaseType;
import net.minecraft.launcher.versions.Rule;
import net.minecraft.launcher.versions.json.DateTypeAdapter;
import net.minecraft.options.OptionsFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import ru.turikhay.app.nstweaker.NSTweaker;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.downloader.AbortedDownloadException;
import ru.turikhay.tlauncher.downloader.DownloadableContainer;
import ru.turikhay.tlauncher.downloader.Downloader;
import ru.turikhay.tlauncher.jna.JNAWindows;
import ru.turikhay.tlauncher.jre.JavaPlatform;
import ru.turikhay.tlauncher.jre.JavaRuntimeLocal;
import ru.turikhay.tlauncher.jre.JavaRuntimeRemote;
import ru.turikhay.tlauncher.managers.AssetsManager;
import ru.turikhay.tlauncher.managers.AssetsNotFoundException;
import ru.turikhay.tlauncher.managers.ComponentManager;
import ru.turikhay.tlauncher.managers.GPUManager;
import ru.turikhay.tlauncher.managers.JavaManager;
import ru.turikhay.tlauncher.managers.JavaManagerConfig;
import ru.turikhay.tlauncher.managers.McleaksManager;
import ru.turikhay.tlauncher.managers.MemoryAllocationService;
import ru.turikhay.tlauncher.managers.ProfileManager;
import ru.turikhay.tlauncher.managers.VersionManager;
import ru.turikhay.tlauncher.managers.VersionSyncInfoContainer;
import ru.turikhay.tlauncher.minecraft.ModList;
import ru.turikhay.tlauncher.minecraft.NBTServer;
import ru.turikhay.tlauncher.minecraft.PromotedServer;
import ru.turikhay.tlauncher.minecraft.PromotedServerAddStatus;
import ru.turikhay.tlauncher.minecraft.Server;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.minecraft.crash.CrashManager;
import ru.turikhay.tlauncher.minecraft.launcher.ChildProcessLogger;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftException;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftExtendedListener;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftLauncherAssistant;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftListener;
import ru.turikhay.tlauncher.minecraft.launcher.hooks.GameModeHook;
import ru.turikhay.tlauncher.pasta.Pasta;
import ru.turikhay.tlauncher.pasta.PastaFormat;
import ru.turikhay.tlauncher.stats.Stats;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.user.PlainUser;
import ru.turikhay.tlauncher.user.User;
import ru.turikhay.util.CharsetDetect;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.JavaVersion;
import ru.turikhay.util.JavaVersionDetector;
import ru.turikhay.util.JavaVersionNotDetectedException;
import ru.turikhay.util.MinecraftUtil;
import ru.turikhay.util.OS;
import ru.turikhay.util.U;
import ru.turikhay.util.async.AsyncThread;

public class MinecraftLauncher
implements JavaProcessListener {
    private static final Logger LOGGER = LogManager.getLogger(MinecraftLauncher.class);
    public static final String SENTRY_CONTEXT_NAME = "minecraftLauncher";
    public static final String CAPABLE_WITH = "1.6.84-j";
    private static final int OFFICIAL_VERSION = 21;
    private static final int ALTERNATIVE_VERSION = 13;
    private static final int MIN_WORK_TIME = 5000;
    private boolean working;
    private boolean killed;
    private final Thread parentThread;
    private final Gson gson;
    private final DateTypeAdapter dateAdapter;
    private final Downloader downloader;
    private final Configuration settings;
    private final boolean forceUpdate;
    private final boolean assistLaunch;
    private final VersionManager vm;
    private final AssetsManager am;
    private final ProfileManager pm;
    private final List<MinecraftListener> listeners;
    private final List<MinecraftExtendedListener> extListeners;
    private final List<MinecraftLauncherAssistant> assistants;
    private MinecraftLauncherStep step;
    private Account.AccountType librariesForType;
    private String oldMainclass;
    private String versionName;
    private VersionSyncInfo versionSync;
    private CompleteVersion version;
    private CompleteVersion deJureVersion;
    private boolean isLauncher;
    private Account<?> account;
    private String family;
    private File rootDir;
    private File gameDir;
    private File localAssetsDir;
    private File nativeDir;
    private File globalAssetsDir;
    private File assetsIndexesDir;
    private File assetsObjectsDir;
    private int[] windowSize;
    private boolean fullCommand;
    private int ramSize;
    private OptionsFile optionsFile;
    private JavaProcessLauncher launcher;
    private boolean minecraftWorking;
    private long startupTime;
    private int exitCode;
    private Server server;
    private List<PromotedServer> promotedServers;
    private List<PromotedServer> outdatedPromotedServers;
    private PromotedServerAddStatus promotedServerAddStatus = PromotedServerAddStatus.NONE;
    private int serverId;
    private static boolean ASSETS_WARNING_SHOWN;
    private JavaProcess process;
    private final Rule.FeatureMatcher featureMatcher = this.createFeatureMatcher();
    private ChildProcessLogger processLogger;
    private Charset charset;
    private final JavaManager javaManager;
    private final GPUManager gpuManager;
    private JavaManagerConfig javaManagerConfig;
    private JavaManagerConfig.JreType jreType;
    private String jreExec;
    private CompleteVersion.JavaVersion recommendedJavaVersion;
    private static final List<String> ARGS_LEGACY_REMOVED;
    private static final List<String> ARGS_CENSORED;
    private static final List<String> CENSORED;
    private static final int BLACKLIST_MODE_REMOVE = 0;
    private static final int BLACKLIST_MODE_CENSOR = 1;
    private static final int ZGC_WINDOWS_BUILD = 17134;
    private AssetsManager.ResourceChecker resourceChecker;
    private static final Marker CHILD_STDOUT;
    private static final Marker CHILD_STDERR;
    private static final Marker[] MARKERS;
    private JavaVersion javaVersion;
    private static final String LOG4J_CORE = "org.apache.logging.log4j:log4j-core:";
    private static final int JARSCANNER_VERSION = 2;

    public ChildProcessLogger getProcessLogger() {
        return this.processLogger;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public JavaManagerConfig.JreType getJreType() {
        return this.jreType;
    }

    public Downloader getDownloader() {
        return this.downloader;
    }

    public Configuration getConfiguration() {
        return this.settings;
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    public boolean isLaunchAssist() {
        return this.assistLaunch;
    }

    public MinecraftLauncherStep getStep() {
        return this.step;
    }

    public boolean isWorking() {
        return this.working;
    }

    public boolean isMinecraftRunning() {
        return this.working && this.minecraftWorking && !this.killed;
    }

    private MinecraftLauncher(ComponentManager manager, Downloader downloader, Configuration configuration, boolean forceUpdate, boolean exit) {
        if (manager == null) {
            throw new NullPointerException("Ti sovsem s duba ruhnul?");
        }
        if (downloader == null) {
            throw new NullPointerException("Downloader is NULL!");
        }
        if (configuration == null) {
            throw new NullPointerException("Configuration is NULL!");
        }
        this.parentThread = Thread.currentThread();
        this.gson = new Gson();
        this.dateAdapter = new DateTypeAdapter(true);
        this.downloader = downloader;
        this.settings = configuration;
        this.assistants = manager.getComponentsOf(MinecraftLauncherAssistant.class);
        this.vm = manager.getComponent(VersionManager.class);
        this.am = manager.getComponent(AssetsManager.class);
        this.pm = manager.getComponent(ProfileManager.class);
        this.javaManager = TLauncher.getInstance().getJavaManager();
        this.gpuManager = TLauncher.getInstance().getGpuManager();
        this.forceUpdate = forceUpdate;
        this.assistLaunch = !exit;
        this.listeners = Collections.synchronizedList(new ArrayList());
        this.extListeners = Collections.synchronizedList(new ArrayList());
        this.step = MinecraftLauncherStep.NONE;
        LOGGER.info("Alternative Minecraft Launcher ({}) has initialized", (Object)13);
        LOGGER.info("Compatible with official version: {}", (Object)21);
    }

    public MinecraftLauncher(TLauncher t, boolean forceUpdate) {
        this(t.getManager(), t.getDownloader(), t.getSettings(), forceUpdate, t.getSettings().getActionOnLaunch() == Configuration.ActionOnLaunch.EXIT);
    }

    public void addListener(MinecraftListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (listener instanceof MinecraftExtendedListener) {
            this.extListeners.add((MinecraftExtendedListener)listener);
        }
        this.listeners.add(listener);
    }

    public void start() {
        this.checkWorking();
        this.working = true;
        try {
            this.collectInfo();
        }
        catch (Throwable var5) {
            LOGGER.error("Caught an exception", var5);
            if (var5 instanceof MinecraftException) {
                MinecraftException listener2 = (MinecraftException)var5;
                for (MinecraftListener listener3 : this.listeners) {
                    listener3.onMinecraftKnownError(listener2);
                }
            } else if (var5 instanceof MinecraftLauncherAborted) {
                for (MinecraftListener listener : this.listeners) {
                    listener.onMinecraftAbort();
                }
            } else {
                Sentry.capture((EventBuilder)new EventBuilder().withMessage("minecraft launcher exception").withSentryInterface((SentryInterface)new ExceptionInterface(var5)).withLevel(Event.Level.ERROR));
                for (MinecraftListener listener : this.listeners) {
                    listener.onMinecraftError(var5);
                }
            }
        }
        this.working = false;
        this.step = MinecraftLauncherStep.NONE;
        LOGGER.info("Launcher has stopped.");
    }

    public void stop() {
        if (this.step == MinecraftLauncherStep.NONE) {
            throw new IllegalStateException();
        }
        if (this.step == MinecraftLauncherStep.DOWNLOADING) {
            this.downloader.stopDownload();
        }
        this.working = false;
    }

    public String getVersion() {
        return this.version.getID();
    }

    public CompleteVersion getCompleteVersion() {
        return this.version;
    }

    public void setVersion(String name) {
        this.checkWorking();
        this.versionName = name;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server, int id) {
        this.checkWorking();
        this.server = server;
        this.serverId = id;
    }

    public void setPromotedServers(List<PromotedServer> serverList, List<PromotedServer> outdatedServerList) {
        this.promotedServers = new ArrayList<PromotedServer>(serverList);
        this.outdatedPromotedServers = outdatedServerList;
        Collections.shuffle(this.promotedServers);
    }

    public OptionsFile getOptionsFile() {
        return this.optionsFile;
    }

    private void collectInfo() throws MinecraftException {
        String accountName;
        this.checkStep(MinecraftLauncherStep.NONE, MinecraftLauncherStep.COLLECTING);
        LOGGER.info("Collecting info...");
        for (MinecraftListener type : this.listeners) {
            type.onMinecraftPrepare();
        }
        for (MinecraftExtendedListener type1 : this.extListeners) {
            type1.onMinecraftCollecting();
        }
        LOGGER.info("Is force updating: {}", (Object)this.forceUpdate);
        if (this.versionName == null) {
            this.versionName = this.settings.get("login.version");
        }
        if (this.versionName == null || this.versionName.isEmpty()) {
            throw new IllegalArgumentException("Version name is NULL or empty!");
        }
        LOGGER.info("Version id: {}", (Object)this.versionName);
        this.versionSync = this.vm.getVersionSyncInfo(this.versionName);
        if (this.versionSync == null) {
            throw new IllegalArgumentException("Cannot find version " + this.versionName);
        }
        LOGGER.debug("Version sync info: {}", (Object)this.versionSync);
        try {
            this.deJureVersion = this.versionSync.resolveCompleteVersion(this.vm, this.forceUpdate);
        }
        catch (IOException e) {
            throw new MinecraftException(false, "Can't resolve version", "could-not-fetch-complete-version", new Object[0]);
        }
        try {
            this.deJureVersion.validate();
        }
        catch (RuntimeException rE) {
            throw new RuntimeException("Invalid version", rE);
        }
        if (this.deJureVersion.getReleaseType() == ReleaseType.LAUNCHER) {
            this.isLauncher = true;
        }
        if ((accountName = this.settings.get("login.account")) != null && !accountName.isEmpty()) {
            Account.AccountType type2 = Account.AccountType.parse(this.settings.get("login.account.type"));
            this.account = this.pm.getAuthDatabase().getByUsername(accountName, type2);
        }
        if (this.account == null) {
            if (this.isLauncher) {
                LOGGER.debug("Account is not required, setting user \"launcher\"");
                accountName = "launcher";
                this.account = new Account<PlainUser>(new PlainUser(accountName, new UUID(0L, 0L)));
            } else {
                throw new NullPointerException("account");
            }
        }
        LOGGER.info("Selected account: {}", (Object)((User)this.account.getUser()).getDisplayName());
        LOGGER.debug("Account info: {}", this.account);
        if (!this.isLauncher) {
            Account.AccountType lookupLibrariesForType;
            switch (this.account.getType()) {
                case MCLEAKS: {
                    if (McleaksManager.isUnsupported()) {
                        throw new MinecraftException(false, "MCLeaks is not supported", "mcleaks-unsupported", new Object[0]);
                    }
                    lookupLibrariesForType = Account.AccountType.MCLEAKS;
                    this.oldMainclass = this.deJureVersion.getMainClass();
                    break;
                }
                case ELY: 
                case ELY_LEGACY: {
                    lookupLibrariesForType = Account.AccountType.ELY;
                    break;
                }
                case PLAIN: {
                    if (TLauncher.getInstance().getLibraryManager().isAllowElyEverywhere() && this.settings.getBoolean("ely.globally")) {
                        lookupLibrariesForType = Account.AccountType.ELY;
                        break;
                    }
                    lookupLibrariesForType = Account.AccountType.PLAIN;
                    break;
                }
                default: {
                    lookupLibrariesForType = this.account.getType();
                }
            }
            this.librariesForType = lookupLibrariesForType;
            LOGGER.debug("Looking up replacement libraries for {}", (Object)this.librariesForType);
            TLauncher.getInstance().getLibraryManager().refreshComponent();
            if (TLauncher.getInstance().getLibraryManager().hasLibraries(this.deJureVersion, this.librariesForType.toString())) {
                this.version = TLauncher.getInstance().getLibraryManager().process(this.deJureVersion, this.librariesForType.toString());
                LOGGER.info("Some libraries will be replaced");
            } else {
                this.version = this.deJureVersion;
                LOGGER.info("No library will be replaced");
            }
        } else {
            this.version = this.deJureVersion;
        }
        LOGGER.trace("Version: {}", (Object)this.version);
        this.family = this.version.getFamily();
        if (StringUtils.isEmpty((CharSequence)this.family)) {
            this.family = "unknown";
        }
        LOGGER.debug("Family: {}", (Object)this.family);
        this.javaManagerConfig = this.settings.get(JavaManagerConfig.class);
        this.jreType = this.javaManagerConfig.getJreTypeOrDefault();
        this.rootDir = new File(this.settings.get("minecraft.gamedir"));
        long freeSpace = this.rootDir.getUsableSpace();
        if (freeSpace > 0L && freeSpace < 65536L) {
            throw new MinecraftException(true, "Insufficient space " + this.rootDir.getAbsolutePath() + "(" + freeSpace + ")", "free-space", this.rootDir);
        }
        this.gameDir = MinecraftLauncher.getGameDir(this.rootDir, this.family, this.version.getID(), this.settings.getSeparateDirs());
        this.detectCharsetOnWindows();
        if (this.charset == null) {
            this.charset = StandardCharsets.UTF_8;
            LOGGER.info("Using standard charset: {}", (Object)this.charset);
        }
        try {
            FileUtil.createFolder(this.rootDir);
        }
        catch (Exception var9) {
            throw new MinecraftException(true, "Cannot create working directory!", "folder-not-found", var9);
        }
        if (!this.isLauncher) {
            try {
                FileUtil.createFolder(this.gameDir);
            }
            catch (Exception var9) {
                throw new MinecraftException(true, "Cannot create game directory!", "folder-not-found", var9);
            }
        }
        LOGGER.info("Root directory: {}", (Object)this.rootDir);
        LOGGER.info("Game directory: {}", (Object)this.gameDir);
        this.optionsFile = new OptionsFile(new File(this.gameDir, "options.txt"));
        if (this.optionsFile.getFile().isFile()) {
            try {
                this.optionsFile.read();
            }
            catch (IOException ioE) {
                LOGGER.warn("Could not read options file {}", (Object)this.optionsFile.getFile(), (Object)ioE);
            }
        }
        LOGGER.info("Options: {}", (Object)this.optionsFile);
        this.globalAssetsDir = new File(this.rootDir, "assets");
        if (!this.isLauncher) {
            LOGGER.trace("Global assets dir: {}", (Object)this.globalAssetsDir);
            try {
                FileUtil.createFolder(this.globalAssetsDir);
            }
            catch (IOException var8) {
                throw new RuntimeException("Cannot create assets directory!", var8);
            }
        }
        this.assetsIndexesDir = new File(this.globalAssetsDir, "indexes");
        if (!this.isLauncher) {
            LOGGER.trace("Assets indexes dir: {}", (Object)this.assetsIndexesDir);
            try {
                FileUtil.createFolder(this.assetsIndexesDir);
            }
            catch (IOException var7) {
                throw new RuntimeException("Cannot create assets indexes directory!", var7);
            }
        }
        this.assetsObjectsDir = new File(this.globalAssetsDir, "objects");
        if (!this.isLauncher) {
            LOGGER.trace("Asset objects dir: {}", (Object)this.assetsIndexesDir);
            try {
                FileUtil.createFolder(this.assetsObjectsDir);
            }
            catch (IOException var6) {
                throw new RuntimeException("Cannot create assets objects directory!", var6);
            }
        }
        this.nativeDir = new File(this.rootDir, "versions/" + this.version.getID() + "/natives");
        LOGGER.trace("Natives dir: {}", (Object)this.nativeDir);
        try {
            FileUtil.createFolder(this.nativeDir);
        }
        catch (IOException var5) {
            throw new RuntimeException("Cannot create native files directory!", var5);
        }
        this.windowSize = this.settings.getClientWindowSize();
        LOGGER.trace("Window size: {}", (Object)this.windowSize);
        if (this.windowSize[0] < 1) {
            throw new IllegalArgumentException("Invalid window width!");
        }
        if (this.windowSize[1] < 1) {
            throw new IllegalArgumentException("Invalid window height!");
        }
        boolean fullScreen = this.settings.getBoolean("minecraft.fullscreen");
        String xmx = this.settings.get("minecraft.xmx");
        if ("auto".equals(xmx)) {
            MemoryAllocationService.Hint hint;
            Future<MemoryAllocationService.Hint> hintFuture = null;
            try {
                hintFuture = TLauncher.getInstance().getMemoryAllocationService().queryHint(new MemoryAllocationService.VersionContext(this.version, this.gameDir.toPath()));
                hint = hintFuture.get();
            }
            catch (InterruptedException e) {
                throw new MinecraftLauncherAborted(e);
            }
            catch (ExecutionException e) {
                LOGGER.warn("Couldn't query hint for {}: {}", (Object)this.version.getID(), (Object)e);
                hint = TLauncher.getInstance().getMemoryAllocationService().getFallbackHint();
            }
            LOGGER.debug("Memory allocation hint for {}: {}", (Object)this.version.getID(), (Object)hint);
            if (hint.isUnderAllocation()) {
                LOGGER.warn("Memory allocation service reported that setting desired memory amount is not possible. Desired: {} MiB", (Object)hint.getDesired());
            }
            this.ramSize = hint.getActual();
        } else {
            this.ramSize = this.settings.getInteger("minecraft.xmx");
            if (this.ramSize <= 0) {
                int fallbackRamSize = TLauncher.getInstance().getMemoryAllocationService().getFallbackHint().getActual();
                LOGGER.warn("Using fallback value for -Xmx ({}), because minecraft.memory <= 0 (= {})", (Object)fallbackRamSize, (Object)this.ramSize);
                this.ramSize = fallbackRamSize;
            }
        }
        this.fullCommand = this.settings.getBoolean("gui.logger.fullcommand");
        for (MinecraftLauncherAssistant assistant : this.assistants) {
            assistant.collectInfo();
        }
        LOGGER.info("Checking conditions...");
        if (this.version.getMinimumCustomLauncherVersion() > 13) {
            throw new MinecraftException(false, "Alternative launcher is incompatible with launching version!", "incompatible", new Object[0]);
        }
        if (this.version.getMinimumCustomLauncherVersion() == 0 && this.version.getMinimumLauncherVersion() > 21) {
            LOGGER.warn("Required launcher version is newer: {} > {}", (Object)this.version.getMinimumLauncherVersion(), (Object)21);
            Alert.showLocWarning("launcher.warning.title", "launcher.warning.incompatible.launcher", null);
        }
        if (!this.version.appliesToCurrentEnvironment(this.featureMatcher)) {
            Alert.showLocWarning("launcher.warning.title", "launcher.warning.incompatible.environment", null);
        }
        this.downloadResources();
    }

    public static File getGameDir(File rootDir, String family, String id, Configuration.SeparateDirs separateDirs) {
        switch (separateDirs) {
            case NONE: {
                return rootDir;
            }
            case FAMILY: {
                return new File(rootDir, "home/" + family);
            }
            case VERSION: {
                return new File(rootDir, "home/" + id);
            }
        }
        throw new RuntimeException("unknown value: " + (Object)((Object)separateDirs));
    }

    private void detectCharsetOnWindows() {
        if (!OS.WINDOWS.isCurrent()) {
            return;
        }
        if (StringUtils.isAsciiPrintable((CharSequence)this.gameDir.getAbsolutePath())) {
            LOGGER.debug("Path to the game directory only contains ASCII characters.");
            LOGGER.debug("I reckon it's fine to use standard UTF-8");
            return;
        }
        String systemCharsetName = System.getProperty("tlauncher.systemCharset");
        if (systemCharsetName == null) {
            LOGGER.warn("System charset is unknown");
            this.detectUsingCharsetDetectTool();
        } else {
            this.useSystemCharsetFromSysProp(systemCharsetName);
        }
    }

    private void useSystemCharsetFromSysProp(String systemCharsetName) {
        Charset charset;
        try {
            charset = Charset.forName(systemCharsetName);
        }
        catch (RuntimeException rE) {
            LOGGER.warn("Couldn't find charset {}. It was passed as a system charset.", (Object)systemCharsetName, (Object)rE);
            Sentry.capture((EventBuilder)new EventBuilder().withLevel(Event.Level.ERROR).withMessage("couldn't find system charset \"" + systemCharsetName + "\"").withSentryInterface((SentryInterface)new ExceptionInterface((Throwable)rE)));
            return;
        }
        LOGGER.debug("Using system charset from system properties: {}", (Object)charset.name());
        this.charset = charset;
    }

    private void detectUsingCharsetDetectTool() {
        Charset charset;
        try {
            charset = AsyncThread.future(() -> CharsetDetect.detect(OS.getJavaPath())).get(10L, TimeUnit.SECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            LOGGER.warn("Couldn't detect system charset using {} tool", (Object)CharsetDetect.class.getSimpleName(), (Object)e);
            if (!(e instanceof TimeoutException)) {
                Sentry.capture((EventBuilder)new EventBuilder().withLevel(Event.Level.ERROR).withMessage("couldn't detect system charset").withSentryInterface((SentryInterface)new ExceptionInterface((Throwable)e)));
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            throw new MinecraftLauncherAborted(interruptedException);
        }
        LOGGER.debug("Detected system charset: {}", (Object)charset);
        this.charset = charset;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public File getGameDir() {
        return this.gameDir;
    }

    private void downloadResources() throws MinecraftException {
        VersionSyncInfoContainer versionContainer;
        this.checkStep(MinecraftLauncherStep.COLLECTING, MinecraftLauncherStep.DOWNLOADING);
        this.executeJarScanner();
        boolean fastCompare = this.versionSync.isInstalled() ? !this.forceUpdate : false;
        for (MinecraftExtendedListener assets : this.extListeners) {
            assets.onMinecraftComparingAssets(fastCompare);
        }
        List<AssetIndex.AssetObject> assets1 = this.compareAssets(fastCompare);
        DownloadableContainer jreContainer = null;
        if (this.jreType instanceof JavaManagerConfig.Recommended) {
            this.recommendedJavaVersion = this.version.getJavaVersion();
            if (this.recommendedJavaVersion == null) {
                LOGGER.debug("Current Minecraft version doesn't have JRE requirements");
                this.recommendedJavaVersion = this.javaManager.getFallbackRecommendedVersion(this.version, true);
                if (this.recommendedJavaVersion != null) {
                    LOGGER.debug("Will use fallback recommended version: {}", (Object)this.recommendedJavaVersion);
                }
            }
            if (JavaPlatform.CURRENT_PLATFORM_CANDIDATES.isEmpty()) {
                LOGGER.warn("Current platform is unsupported");
                this.jreType = new JavaManagerConfig.Current();
                Alert.showWarning("", Localizable.get("launcher.warning.jre-platform-unknown"));
            } else if (this.recommendedJavaVersion == null) {
                this.jreType = new JavaManagerConfig.Current();
            } else {
                Optional<JavaRuntimeLocal> latestLocalOpt;
                String jreName = this.recommendedJavaVersion.getComponent();
                LOGGER.debug("Will use JRE: {}", (Object)this.recommendedJavaVersion);
                try {
                    latestLocalOpt = this.javaManager.getLatestVersionInstalled(jreName);
                }
                catch (InterruptedException interruptedException) {
                    throw new MinecraftLauncherAborted(interruptedException);
                }
                if (latestLocalOpt.isPresent() && (latestLocalOpt.get().hasOverride() || !this.forceUpdate)) {
                    LOGGER.debug("Latest version of required JRE is installed");
                    this.jreExec = latestLocalOpt.get().getExecutableFile().getAbsolutePath();
                } else {
                    boolean runtimeNotSupported;
                    Optional<JavaRuntimeRemote> remoteRuntimeOpt;
                    LOGGER.debug("Will install required JRE");
                    try {
                        remoteRuntimeOpt = this.javaManager.getFetcher().fetchNow().getCurrentPlatformFirstRuntimeCandidate(jreName);
                        runtimeNotSupported = !remoteRuntimeOpt.isPresent();
                    }
                    catch (ExecutionException e) {
                        LOGGER.error("Couldn't fetch remote JRE list", (Throwable)e);
                        remoteRuntimeOpt = Optional.empty();
                        runtimeNotSupported = false;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new MinecraftLauncherAborted(interruptedException);
                    }
                    if (remoteRuntimeOpt.isPresent()) {
                        JavaRuntimeRemote remoteRuntime = remoteRuntimeOpt.get();
                        File javaRootDir = this.javaManager.getDiscoverer().getRootDir();
                        try {
                            boolean continueWithoutInstallation;
                            if (!this.javaManager.hasEnoughSpaceToInstall(remoteRuntime) && !(continueWithoutInstallation = Alert.showQuestion("", Localizable.get("launcher.warning.jre-will-take-remaining-space", remoteRuntime.getManifest().countBytes() / 1024L / 1024L)))) {
                                throw new MinecraftLauncherAborted("JRE will take up all remaining space");
                            }
                            jreContainer = this.javaManager.installVersionNow(remoteRuntime, javaRootDir, this.forceUpdate);
                            this.downloader.add(jreContainer);
                            this.jreExec = remoteRuntime.toLocal(javaRootDir).getExecutableFile().getAbsolutePath();
                        }
                        catch (ExecutionException e) {
                            LOGGER.warn("Couldn't fetch manifest", (Throwable)e);
                            Sentry.capture((EventBuilder)new EventBuilder().withLevel(Event.Level.WARNING).withMessage("couldn't fetch manifest").withSentryInterface((SentryInterface)new ExceptionInterface((Throwable)e)).withExtra("jreName", (Object)jreName).withExtra("version", (Object)this.versionName));
                            Optional<JavaRuntimeLocal> localRuntimeOpt = this.javaManager.getDiscoverer().getCurrentPlatformRuntime(jreName);
                            if (localRuntimeOpt.isPresent()) {
                                LOGGER.info("But local JRE is found. Will use it instead.");
                                if (Alert.showQuestion("", Localizable.get("launcher.warning.jre-manifest-unavailable.use-local"))) {
                                    JavaRuntimeLocal localRuntime = localRuntimeOpt.get();
                                    LOGGER.info("We can continue with the local JRE: {}", (Object)localRuntime);
                                    this.jreExec = localRuntime.getWorkingDirectory().getAbsolutePath();
                                }
                                throw new MinecraftLauncherAborted("Couldn't fetch jre");
                            }
                            LOGGER.info("But local JRE is not found");
                            if (Alert.showQuestion("", Localizable.get("launcher.warning.jre-manifest-unavailable.use-current"))) {
                                LOGGER.info("We can continue with the current JRE");
                                this.jreType = new JavaManagerConfig.Current();
                            }
                            throw new MinecraftLauncherAborted("Couldn't fetch jre");
                        }
                        catch (InterruptedException e) {
                            throw new MinecraftLauncherAborted("interrupted while waiting for manifest");
                        }
                    } else {
                        String path;
                        if (runtimeNotSupported) {
                            LOGGER.warn("Runtime is not found. This platform is probably not supported.");
                            path = "jre-platform-unsupported";
                        } else {
                            LOGGER.warn("Couldn't find required JRE");
                            path = "jre-not-found";
                        }
                        if (Alert.showQuestion("", Localizable.get("launcher.warning." + path))) {
                            LOGGER.info("User selected to fall back to current JRE");
                            this.jreType = new JavaManagerConfig.Current();
                        } else {
                            throw new MinecraftLauncherAborted("Couldn't find required JRE");
                        }
                    }
                }
            }
        }
        if (this.jreType instanceof JavaManagerConfig.Custom) {
            this.jreExec = ((JavaManagerConfig.Custom)this.jreType).getPath().orElse(OS.getJavaPath());
        }
        if (this.jreType instanceof JavaManagerConfig.Current) {
            this.jreExec = OS.getJavaPath();
        }
        for (MinecraftExtendedListener execContainer1 : this.extListeners) {
            execContainer1.onMinecraftDownloading();
        }
        try {
            versionContainer = this.vm.downloadVersion(this.versionSync, this.librariesForType, this.forceUpdate);
        }
        catch (IOException var8) {
            throw new MinecraftException(false, "Cannot download version!", "download-jar", var8);
        }
        this.checkAborted();
        if (assets1 != null) {
            DownloadableContainer assetsContainer = this.am.downloadResources(this.version, assets1);
            this.downloader.add(assetsContainer);
        }
        this.downloader.add(versionContainer);
        for (MinecraftLauncherAssistant e : this.assistants) {
            e.collectResources(this.downloader);
        }
        this.downloader.startDownloadAndWait();
        if (versionContainer.isAborted() || jreContainer != null && jreContainer.isAborted()) {
            throw new MinecraftLauncherAborted(new AbortedDownloadException());
        }
        if (!versionContainer.getErrors().isEmpty() || jreContainer != null && !jreContainer.getErrors().isEmpty()) {
            throw new MinecraftException(false, "Cannot download all required files", "download", new Object[0]);
        }
        this.deJureVersion.setUpdatedTime(U.getUTC().getTime());
        try {
            this.vm.getLocalList().saveVersion(this.deJureVersion);
        }
        catch (IOException var7) {
            LOGGER.warn("Cannot save version", (Throwable)var7);
        }
        this.constructProcess();
    }

    private void constructProcess() throws MinecraftException {
        Optional<GPUManager.GPU> gpu;
        String gpuName;
        Library log4jLibrary;
        this.checkStep(MinecraftLauncherStep.DOWNLOADING, MinecraftLauncherStep.CONSTRUCTING);
        this.extListeners.forEach(MinecraftExtendedListener::onMinecraftReconstructingAssets);
        try {
            this.localAssetsDir = this.reconstructAssets();
        }
        catch (IOException var8) {
            throw new MinecraftException(false, "Cannot reconstruct assets!", "reconstruct-assets", var8);
        }
        this.extListeners.forEach(MinecraftExtendedListener::onMinecraftUnpackingNatives);
        try {
            this.unpackNatives(this.forceUpdate);
        }
        catch (IOException var7) {
            throw new MinecraftException(false, "Cannot unpack natives!", "unpack-natives", var7);
        }
        this.checkAborted();
        this.extListeners.forEach(MinecraftExtendedListener::onMinecraftDeletingEntries);
        try {
            this.deleteEntries();
        }
        catch (IOException var6) {
            throw new MinecraftException(false, "Cannot delete entries!", "delete-entries", var6);
        }
        try {
            this.deleteLibraryEntries();
        }
        catch (Exception var5) {
            throw new MinecraftException(false, "Cannot delete library entries!", "delete-entries", var5);
        }
        this.checkAborted();
        LOGGER.info("Constructing process...");
        this.extListeners.forEach(MinecraftExtendedListener::onMinecraftConstructing);
        ArrayList<String> jvmArgs = new ArrayList<String>();
        ArrayList<String> programArgs = new ArrayList<String>();
        this.createJvmArgs(jvmArgs);
        this.javaManagerConfig.getMinecraftArgs().ifPresent(s -> {
            List<String> userArgs = Arrays.asList(StringUtils.split((String)s, (char)' '));
            LOGGER.info("Appending user args (after classpath): {}", userArgs);
            programArgs.addAll(userArgs);
        });
        this.launcher = new JavaProcessLauncher(this.charset, Objects.requireNonNull(this.jreExec, "jreExec"), new String[0]);
        this.launcher.directory(this.isLauncher ? this.rootDir : this.gameDir);
        try {
            this.fixResourceFolder();
        }
        catch (Exception ioE) {
            LOGGER.warn("Cannot check resource folder. This could have been fixed [MCL-3732].", (Throwable)ioE);
        }
        if (!this.isLauncher) {
            LinkedHashSet<NBTServer> nbtServerList = new LinkedHashSet<NBTServer>();
            try {
                LinkedHashSet<Object> exisingServerList;
                File file = new File(this.gameDir, "servers.dat");
                if (file.isFile()) {
                    try {
                        FileUtil.copyFile(file, new File(file.getAbsolutePath() + ".bak"), true);
                    }
                    catch (IOException ioE) {
                        LOGGER.warn("Could not make backup for servers.dat", (Throwable)ioE);
                    }
                    try {
                        exisingServerList = NBTServer.loadSet(file);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Could not read servers.dat.We'll have to overwrite it as it can't be read by Minecraft neither", (Throwable)e);
                        exisingServerList = new LinkedHashSet();
                    }
                } else {
                    FileUtil.createFile(file);
                    exisingServerList = new LinkedHashSet();
                }
                if (this.server != null) {
                    nbtServerList.add(new NBTServer(this.server));
                }
                if (this.outdatedPromotedServers != null) {
                    Iterator<Object> i = exisingServerList.iterator();
                    block20: while (i.hasNext()) {
                        NBTServer existingServer = (NBTServer)i.next();
                        for (PromotedServer outdatedServer : this.outdatedPromotedServers) {
                            if (!existingServer.equals(outdatedServer) || !existingServer.getName().equals(outdatedServer.getName())) continue;
                            LOGGER.debug("Removed outdated server: {}", (Object)existingServer);
                            i.remove();
                            continue block20;
                        }
                    }
                }
                if (this.settings.getBoolean("minecraft.servers.promoted.ingame")) {
                    if (this.promotedServers != null) {
                        for (PromotedServer promotedServer : this.promotedServers) {
                            if (!promotedServer.getFamily().isEmpty() && !promotedServer.getFamily().contains(this.family) || promotedServer.equals(this.server)) continue;
                            NBTServer existingServer = null;
                            for (NBTServer nBTServer : exisingServerList) {
                                if (!promotedServer.equals(nBTServer)) continue;
                                existingServer = nBTServer;
                                break;
                            }
                            if (existingServer != null) {
                                nbtServerList.add(existingServer);
                                exisingServerList.remove(existingServer);
                                continue;
                            }
                            nbtServerList.add(new NBTServer(promotedServer));
                        }
                    } else {
                        this.promotedServerAddStatus = PromotedServerAddStatus.EMPTY;
                    }
                } else {
                    this.promotedServerAddStatus = PromotedServerAddStatus.DISABLED;
                }
                nbtServerList.addAll(exisingServerList);
                FileUtil.copyFile(file, new File(this.gameDir, "servers.dat.bak"), true);
                NBTServer.saveSet(nbtServerList, file);
                if (this.promotedServerAddStatus == PromotedServerAddStatus.NONE) {
                    this.promotedServerAddStatus = PromotedServerAddStatus.SUCCESS;
                }
            }
            catch (Exception e) {
                LOGGER.warn("Couldn't reconstruct server list", (Throwable)e);
                this.promotedServerAddStatus = PromotedServerAddStatus.ERROR;
            }
        }
        if (!this.isLauncher) {
            try {
                this.fixForNewerVersions();
            }
            catch (Exception e) {
                LOGGER.warn("Could not make it compatible with older versions", (Throwable)e);
            }
        }
        if ((log4jLibrary = this.findLog4j2Library()) == null) {
            LOGGER.info("Version doesn't use log4j2 library");
        } else {
            Log4jVersion log4jVersion = this.parseLog4jVersion(log4jLibrary);
            if (log4jVersion != null && log4jVersion.major != 2) {
                LOGGER.info("Log4j version is not 2.x.x, it's {}", (Object)log4jVersion);
            } else {
                int minor = log4jVersion == null ? 0 : log4jVersion.minor;
                try {
                    if (minor >= 15) {
                        LOGGER.info("No vulnerability fix is required. Library version is 2.15.0+: {}", (Object)log4jVersion);
                    } else if (minor >= 10) {
                        LOGGER.info("Setting JVM argument: -Dlog4j2.formatMsgNoLookups=true");
                        jvmArgs.add("-Dlog4j2.formatMsgNoLookups=true");
                    } else {
                        String patchedLog4j2ConfigVariant = minor >= 7 ? "7" : "0";
                        File logConfigsDir = new File(this.globalAssetsDir, "log_configs");
                        FileUtil.createFolder(logConfigsDir);
                        LOGGER.info("Using patched log4j config variant: {}", (Object)patchedLog4j2ConfigVariant);
                        String patchedLogFilePath = this.savePatchedConfiguration(logConfigsDir, patchedLog4j2ConfigVariant);
                        LOGGER.debug("Log4j2 configuration file: {}", (Object)patchedLogFilePath);
                        jvmArgs.add("-Dlog4j.configurationFile=" + patchedLogFilePath);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Vulnerable logging configuration patch failure", (Throwable)e);
                    Sentry.capture((EventBuilder)new EventBuilder().withLevel(Event.Level.WARNING).withMessage("vulnerable logging configuration patch failure").withSentryInterface((SentryInterface)new ExceptionInterface((Throwable)e)).withExtra("versionJson", (Object)Pasta.pasteFile(new File(this.rootDir, "versions/" + this.version.getID() + "/" + this.version.getID() + ".json"), PastaFormat.JSON)));
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.librariesForType == Account.AccountType.PLAIN) {
            jvmArgs.addAll(Arrays.asList("-Dminecraft.api.auth.host=https://0.0.0.0", "-Dminecraft.api.account.host=https://0.0.0.0", "-Dminecraft.api.session.host=https://0.0.0.0", "-Dminecraft.api.services.host=https://0.0.0.0"));
        }
        StrSubstitutor argumentsSubstitutor = this.createArgumentsSubstitutor();
        jvmArgs.addAll(this.version.addArguments(ArgumentType.JVM, this.featureMatcher, argumentsSubstitutor));
        programArgs.addAll(this.version.addArguments(ArgumentType.GAME, this.featureMatcher, argumentsSubstitutor));
        this.fixArguments(jvmArgs, ArgumentType.JVM);
        this.fixArguments(programArgs, ArgumentType.GAME);
        if (!this.isLauncher && this.server != null) {
            programArgs.addAll(Arrays.asList("--server", this.server.getAddress()));
            if (this.server.getPort() != 25565) {
                programArgs.addAll(Arrays.asList("--port", String.valueOf(this.server.getPort())));
            }
        }
        programArgs.addAll(this.processModpack());
        for (String arg : jvmArgs) {
            this.launcher.addCommand(arg);
        }
        this.launcher.addCommand(this.version.getMainClass());
        if (!this.fullCommand) {
            ArrayList<String> l = new ArrayList<String>(this.launcher.getCommands());
            l.addAll(programArgs);
            LOGGER.info("Half command (not escaped):");
            LOGGER.info(this.launcher.getJvmPath() + " " + this.joinList((Collection<String>)l, ARGS_CENSORED, 1));
        }
        for (String arg : programArgs) {
            this.launcher.addCommand(arg);
        }
        if (this.settings.getBoolean("minecraft.deleteTlSkinCape")) {
            LOGGER.info("Deleting TLSkinCape mod. Disable this feature in config file if you want");
            this.deleteMod("tl.?skin.?cape.*\\.jar");
        }
        if ((gpuName = this.settings.get("minecraft.gpu")).equalsIgnoreCase(GPUManager.GPU.DEFAULT.getName())) {
            gpu = Optional.of(GPUManager.GPU.DEFAULT);
            LOGGER.info("Using system GPU settings");
        } else if (gpuName.equalsIgnoreCase(GPUManager.GPU.INTEGRATED.getName())) {
            gpu = this.gpuManager.findIntegratedGPU();
            gpu.ifPresent(value -> LOGGER.info("GPU name {} resolved to {}", (Object)gpuName, (Object)value.getName()));
        } else if (gpuName.equalsIgnoreCase(GPUManager.GPU.DISCRETE.getName())) {
            gpu = this.gpuManager.findDiscreteGPU();
            gpu.ifPresent(value -> LOGGER.info("GPU name {} resolved to {}", (Object)gpuName, (Object)value.getName()));
        } else {
            gpu = this.gpuManager.findGPU(gpuName);
            if (!gpu.isPresent()) {
                LOGGER.warn("Unable to find GPU {}", (Object)gpuName);
            }
        }
        gpu.ifPresent(value -> this.launcher.addHook(value.getHook(this.gpuManager)));
        if (OS.LINUX.isCurrent() && this.settings.getBoolean("minecraft.gamemode")) {
            GameModeHook.Loader.tryToCreate().ifPresent(this.launcher::addHook);
        }
        if (this.fullCommand) {
            LOGGER.info("Full command (not escaped):");
            LOGGER.info(this.launcher.getCommandsAsString());
        }
        this.launchMinecraft();
    }

    private void fixArguments(List<String> args, ArgumentType type) {
        if (type == ArgumentType.JVM && this.ramSize >= 2048) {
            args.removeIf(it -> it.startsWith("-Xss"));
            args.add("-Xss2M");
        }
    }

    private void deleteMod(String ... names) {
        File[] files = new File(this.gameDir, "mods").listFiles(file -> {
            if (!file.isFile()) return false;
            if (!Arrays.stream(names).anyMatch(file.getName().toLowerCase(Locale.ROOT)::matches)) return false;
            return true;
        });
        if (files == null) {
            return;
        }
        for (File file2 : files) {
            LOGGER.debug("Removing {}", (Object)file2.getName());
            if (file2.delete()) continue;
            LOGGER.error("error removing mod {}", (Object)file2.getName());
        }
    }

    private File reconstructAssets() throws IOException {
        String assetVersion = this.version.getAssetIndex().getId();
        if (assetVersion == null) {
            LOGGER.warn("Asset version is unknown");
            assetVersion = "unknown";
        }
        File indexFile = new File(this.assetsIndexesDir, assetVersion + ".json");
        File virtualRoot = new File(new File(this.globalAssetsDir, "virtual"), assetVersion);
        if (!indexFile.isFile()) {
            LOGGER.warn("No assets index file {}; can't reconstruct assets", (Object)virtualRoot);
        } else {
            AssetIndex index;
            try {
                index = Objects.requireNonNull((AssetIndex)this.gson.fromJson((Reader)new FileReader(indexFile), AssetIndex.class), "json response");
            }
            catch (Exception var9) {
                LOGGER.warn("Couldn't read index file", (Throwable)var9);
                return virtualRoot;
            }
            if (index.isMapToResources()) {
                virtualRoot = new File(this.gameDir, "resources");
            }
            if (index.isVirtual() || index.isMapToResources()) {
                LOGGER.info("Reconstructing virtual assets folder at {}", (Object)virtualRoot);
                for (Map.Entry<String, AssetIndex.AssetObject> stringAssetObjectEntry : index.getFileMap().entrySet()) {
                    this.checkAborted();
                    File target = new File(virtualRoot, stringAssetObjectEntry.getKey());
                    File original = new File(new File(this.assetsObjectsDir, stringAssetObjectEntry.getValue().getHash().substring(0, 2)), stringAssetObjectEntry.getValue().getHash());
                    if (!original.isFile()) {
                        LOGGER.warn("Skipped reconstructing: {}", (Object)original);
                        continue;
                    }
                    if (!this.forceUpdate && target.isFile()) continue;
                    FileUtils.copyFile((File)original, (File)target, (boolean)false);
                    LOGGER.debug("{} -> {}", (Object)original, (Object)target);
                }
                FileUtil.writeFile(new File(virtualRoot, ".lastused"), this.dateAdapter.format(new Date()));
            }
        }
        return virtualRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackNatives(boolean force) throws IOException {
        LOGGER.info("Unpacking natives...");
        Collection<Library> libraries = this.version.getRelevantLibraries(this.featureMatcher);
        if (force) {
            this.nativeDir.delete();
        }
        for (Library library : libraries) {
            ZipFile zip;
            String natives;
            Map<OS, String> nativesPerOs = library.getNatives();
            if (nativesPerOs == null || (natives = nativesPerOs.get((Object)OS.CURRENT)) == null) continue;
            File file = new File(MinecraftUtil.getWorkingDirectory(), "libraries/" + library.getArtifactPath(natives));
            if (!file.isFile()) {
                throw new IOException("Required archive doesn't exist: " + file.getAbsolutePath());
            }
            try {
                zip = new ZipFile(file);
            }
            catch (IOException var18) {
                throw new IOException("Error opening ZIP archive: " + file.getAbsolutePath(), var18);
            }
            try {
                ExtractRules extractRules = library.getExtractRules();
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory() || entry.getName().startsWith("META-INF/") || extractRules != null && !extractRules.shouldExtract(entry.getName())) continue;
                    File targetFile = new File(this.nativeDir, entry.getName());
                    if (!force && targetFile.isFile()) continue;
                    FileUtil.createFolder(targetFile.getParentFile());
                    InputStream input = zip.getInputStream(entry);
                    try (FileOutputStream output = new FileOutputStream(targetFile);){
                        IOUtils.copy((InputStream)input, (OutputStream)output);
                    }
                    finally {
                        if (input == null) continue;
                        input.close();
                    }
                }
            }
            finally {
                zip.close();
            }
        }
    }

    private void deleteEntries() throws IOException {
        List<String> entries = this.version.getDeleteEntries();
        if (entries != null && entries.size() != 0) {
            LOGGER.info("Removing entries...");
            File file = this.version.getFile(this.rootDir);
            this.removeFrom(file, entries);
        }
    }

    private void deleteLibraryEntries() throws IOException {
        for (Library lib : this.version.getLibraries()) {
            List<String> entries = lib.getDeleteEntriesList();
            if (entries == null || entries.isEmpty()) continue;
            LOGGER.debug("Processing entries of {}", (Object)lib.getName());
            this.removeFrom(new File(this.rootDir, "libraries/" + lib.getArtifactPath()), entries);
        }
    }

    private String constructClassPath(CompleteVersion version) throws MinecraftException {
        LOGGER.info("Constructing classpath...");
        StringBuilder result = new StringBuilder();
        Collection<File> classPath = version.getClassPath(OS.CURRENT, this.featureMatcher, this.rootDir);
        String separator = System.getProperty("path.separator");
        for (File file : classPath) {
            if (!file.isFile()) {
                throw new MinecraftException(true, "Classpath is not found: " + file, "classpath", file);
            }
            if (result.length() > 0) {
                result.append(separator);
            }
            result.append(file.getAbsolutePath());
        }
        return result.toString();
    }

    private void fixForNewerVersions() {
        boolean needSave = false;
        if (this.version.getMinecraftArguments() != null && this.version.hasModernArguments()) {
            this.deJureVersion.setMinecraftArguments(null);
            needSave = true;
        }
        if (needSave) {
            try {
                this.vm.getLocalList().saveVersion(this.deJureVersion);
            }
            catch (IOException var7) {
                LOGGER.warn("Cannot save legacy arguments!", (Throwable)var7);
            }
        }
    }

    private String makeLegacyArgumentString(ArgumentType type) {
        List<String> argList = this.version.addArguments(type, this.featureMatcher, null);
        return this.joinList(argList, ARGS_LEGACY_REMOVED, 0);
    }

    private void removeOldModlistFiles() {
        File[] fileList = this.gameDir.listFiles();
        if (fileList == null) {
            LOGGER.warn("Cannot get file list in {}", (Object)this.rootDir);
            return;
        }
        for (File file : fileList) {
            if (!file.getName().startsWith("tempModList-")) continue;
            FileUtil.deleteFile(file);
        }
    }

    private List<String> processModpack() {
        this.removeOldModlistFiles();
        List<Library> mods = this.version.getMods(this.featureMatcher);
        if (mods.size() == 0) {
            return Collections.emptyList();
        }
        ModpackType modpackType = this.version.getModpackType();
        switch (modpackType) {
            case FORGE_LEGACY: 
            case FORGE_LEGACY_ABSOLUTE: {
                ModList modList = new ModList(new File(this.rootDir, "libraries"), modpackType == ModpackType.FORGE_LEGACY_ABSOLUTE);
                mods.forEach(modList::addMod);
                String modListFilename = "tempModList-" + System.currentTimeMillis();
                try {
                    modList.save(new File(this.gameDir, modListFilename));
                }
                catch (IOException e) {
                    LOGGER.warn("Cannot generate mod list file", (Throwable)e);
                    return Collections.emptyList();
                }
                return Arrays.asList("--modListFile", modListFilename);
            }
            case FORGE_1_13: {
                return Arrays.asList("--fml.mods", mods.stream().map(Library::getName).collect(Collectors.joining(",")), "--fml.mavenRoots", this.settings.getSeparateDirs() == Configuration.SeparateDirs.NONE ? "libraries" : "../../libraries");
            }
        }
        return Collections.emptyList();
    }

    private String joinList(Collection<String> l, Collection<String> blackList, int blacklistMode) {
        StringBuilder b = new StringBuilder();
        Iterator<String> i = l.iterator();
        while (i.hasNext()) {
            String arg = i.next();
            if (!blackList.contains(arg)) {
                b.append(' ').append(arg);
                continue;
            }
            if (blacklistMode != 1) continue;
            b.append(' ').append(arg).append(" [").append(U.getRandom(CENSORED)).append("]");
            if (!i.hasNext()) continue;
            i.next();
        }
        if (b.length() > 1) {
            return b.substring(1);
        }
        return null;
    }

    private void addCMSOptimizedArguments(List<String> args) {
        args.add("-XX:+DisableExplicitGC");
        args.add("-XX:+UseConcMarkSweepGC");
        args.add("-XX:-UseAdaptiveSizePolicy");
        args.add("-XX:+CMSParallelRemarkEnabled");
        args.add("-XX:+CMSClassUnloadingEnabled");
        args.add("-XX:+UseCMSInitiatingOccupancyOnly");
        args.add("-XX:ConcGCThreads=" + Math.max(1, OS.Arch.AVAILABLE_PROCESSORS / 2));
    }

    private void addG1OptimizedArguments(List<String> args) {
        args.add("-XX:+UnlockExperimentalVMOptions");
        args.add("-XX:+UseG1GC");
        args.add("-XX:G1NewSizePercent=20");
        args.add("-XX:G1ReservePercent=20");
        args.add("-XX:MaxGCPauseMillis=50");
        args.add("-XX:G1HeapRegionSize=32M");
        args.add("-XX:+DisableExplicitGC");
        args.add("-XX:+AlwaysPreTouch");
        args.add("-XX:+ParallelRefProcEnabled");
    }

    private void addZGCOptimizedArguments(List<String> args) {
        args.add("-XX:+UnlockExperimentalVMOptions");
        args.add("-XX:+UseZGC");
        args.add("-XX:-ZUncommit");
        args.add("-XX:ZCollectionInterval=5");
        args.add("-XX:ZAllocationSpikeTolerance=2.0");
        args.add("-XX:+AlwaysPreTouch");
        args.add("-XX:+ParallelRefProcEnabled");
        args.add("-XX:+DisableExplicitGC");
    }

    private void addOptimizedArguments(List<String> args) {
        boolean supportsZgc;
        int jreMajorVersion = this.getJreMajorVersion();
        if (jreMajorVersion == 0) {
            jreMajorVersion = 8;
        }
        if ((supportsZgc = OS.WINDOWS.isCurrent() ? JNAWindows.getBuildNumber().filter(build -> build >= 17134).isPresent() : true) && jreMajorVersion >= 15 && OS.Arch.AVAILABLE_PROCESSORS >= 8 && this.ramSize >= 8192) {
            this.addZGCOptimizedArguments(args);
            return;
        }
        if (jreMajorVersion >= 11 || jreMajorVersion >= 8 && OS.Arch.AVAILABLE_PROCESSORS >= 4) {
            this.addG1OptimizedArguments(args);
            return;
        }
        this.addCMSOptimizedArguments(args);
    }

    private void createJvmArgs(List<String> args) {
        this.javaManagerConfig.getArgs().ifPresent(s -> {
            List<String> userArgs = Arrays.asList(StringUtils.split((String)s, (char)' '));
            LOGGER.info("Appending user JVM arguments: {}", userArgs);
            args.addAll(userArgs);
        });
        if (this.javaManagerConfig.useOptimizedArguments()) {
            this.addOptimizedArguments(args);
        }
        args.add("-Xms" + Math.min(this.ramSize, 2048) + "M");
        args.add("-Xmx" + this.ramSize + "M");
        if (this.librariesForType == Account.AccountType.MCLEAKS) {
            args.add("-Dru.turikhay.mcleaks.nstweaker.hostname=true");
            args.add("-Dru.turikhay.mcleaks.nstweaker.hostname.list=" + NSTweaker.toTweakHostnameList(McleaksManager.getConnector().getList()));
            args.add("-Dru.turikhay.mcleaks.nstweaker.ssl=true");
            args.add("-Dru.turikhay.mcleaks.nstweaker.mainclass=" + this.oldMainclass);
        }
        if (!OS.WINDOWS.isCurrent() || StringUtils.isAsciiPrintable((CharSequence)this.nativeDir.getAbsolutePath())) {
            args.add("-Dfile.encoding=" + this.charset.name());
        }
    }

    private List<AssetIndex.AssetObject> compareAssets(boolean fastCompare) {
        AssetsManager.ResourceChecker checker;
        if (this.version.getAssetIndex() != null && "none".equals(this.version.getAssetIndex().getId())) {
            LOGGER.info("Assets comparison skipped");
            return null;
        }
        LOGGER.info("Checking assets...");
        try {
            checker = this.am.checkResources(this.version, fastCompare);
        }
        catch (AssetsNotFoundException e) {
            LOGGER.warn("Couldn't check resources", (Throwable)e);
            return null;
        }
        try {
            this.resourceChecker = checker;
            boolean showTimerWarning = true;
            AssetIndex.AssetObject lastObject = null;
            int timer = 0;
            while (this.working && checker.checkWorking()) {
                AssetIndex.AssetObject object = checker.getCurrent();
                if (object != null) {
                    LOGGER.debug("Instant state on: {}", (Object)object);
                    if (showTimerWarning && object == lastObject) {
                        if (++timer == 10) {
                            LOGGER.warn("We're checking this object for too long: {}", (Object)object);
                            AsyncThread.execute(() -> Alert.showLocWarning("launcher.warning.assets.long"));
                            showTimerWarning = false;
                        }
                    } else {
                        timer = 0;
                    }
                    U.sleepFor(1000L);
                }
                lastObject = object;
            }
        }
        catch (InterruptedException inE) {
            throw new MinecraftLauncherAborted(inE);
        }
        this.checkAborted();
        List<AssetIndex.AssetObject> result = checker.getAssetList();
        if (result == null) {
            LOGGER.error("Could not check assets", (Throwable)checker.getError());
            return Collections.emptyList();
        }
        LOGGER.info("Compared assets in {} ms", (Object)checker.getDelta());
        return result;
    }

    private void fixResourceFolder() throws Exception {
        if (this.isLauncher) {
            return;
        }
        File serverResourcePacksFolder = new File(this.gameDir, "server-resource-packs");
        if (serverResourcePacksFolder.isDirectory()) {
            File[] files;
            for (File file : files = Objects.requireNonNull(serverResourcePacksFolder.listFiles(), "files of " + serverResourcePacksFolder.getAbsolutePath())) {
                if (file.length() != 0L) continue;
                FileUtil.deleteFile(file);
            }
        }
        FileUtil.createFolder(serverResourcePacksFolder);
    }

    private void launchMinecraft() throws MinecraftException {
        this.checkStep(MinecraftLauncherStep.CONSTRUCTING, MinecraftLauncherStep.LAUNCHING);
        for (MinecraftListener e : this.listeners) {
            e.onMinecraftLaunch();
        }
        try {
            this.processLogger = ChildProcessLogger.create(this.charset);
        }
        catch (IOException e) {
            LOGGER.warn("Cannot create process logger", (Throwable)e);
        }
        if (this.version.getReleaseType() != null) {
            switch (this.version.getReleaseType()) {
                case RELEASE: 
                case SNAPSHOT: {
                    LOGGER.info("Starting Minecraft {}", (Object)this.version.getID());
                    break;
                }
                default: {
                    LOGGER.info("Starting {}", (Object)this.version.getID());
                }
            }
        }
        LOGGER.debug("Launching in: {}", (Object)this.gameDir);
        this.startupTime = System.currentTimeMillis();
        try {
            ProcessBuilder b = this.launcher.createProcess();
            Map<String, String> env = b.environment();
            LOGGER.debug("Found global _JAVA_OPTIONS=\"" + Optional.ofNullable(System.getenv("_JAVA_OPTIONS")).orElse("null") + "\"");
            if (env != null) {
                Optional<String> old = Optional.ofNullable(env.put("_JAVA_OPTIONS", ""));
                LOGGER.debug("Replaced process _JAVA_OPTIONS=\"" + old.orElse("null") + "\" with nothing");
            }
            this.process = new JavaProcess(b.start(), this.charset, this.launcher.getHook());
            this.process.safeSetExitRunnable(this);
            this.minecraftWorking = true;
            MinecraftLauncher.updateLoggerActions();
        }
        catch (Exception e) {
            this.notifyClose();
            if (e.getMessage() != null && e.getMessage().contains("CreateProcess error=2,")) {
                throw new MinecraftException(false, "Executable is not found: \"" + e.getMessage() + "\"", "exec-not-found", new Object[0]);
            }
            throw new MinecraftException(true, "Cannot start the game!", "start", e);
        }
        this.postLaunch();
    }

    private static void updateLoggerActions() {
        TLauncher.getInstance().updateLoggerUIActions();
    }

    private void postLaunch() {
        this.checkStep(MinecraftLauncherStep.LAUNCHING, MinecraftLauncherStep.POSTLAUNCH);
        LOGGER.info("Post-launch actions are proceeding");
        for (MinecraftExtendedListener listener : this.extListeners) {
            listener.onMinecraftPostLaunch();
        }
        Stats.minecraftLaunched(this.account, this.version, this.server, this.serverId, this.promotedServerAddStatus);
        if (this.assistLaunch) {
            LOGGER.info("Waiting child process to close");
            this.waitForClose();
        } else {
            LOGGER.info("Going to close in 30 seconds");
            U.sleepFor(30000L);
            if (this.minecraftWorking) {
                TLauncher.kill();
            }
        }
    }

    public void killProcess() {
        if (!this.minecraftWorking) {
            throw new IllegalStateException();
        }
        LOGGER.info("Killing child process forcefully");
        this.killed = true;
        MinecraftLauncher.updateLoggerActions();
        this.process.stop();
    }

    private void checkThread() {
        if (!Thread.currentThread().equals(this.parentThread)) {
            throw new IllegalStateException("Illegal thread!");
        }
    }

    private void checkStep(MinecraftLauncherStep prevStep, MinecraftLauncherStep currentStep) {
        this.checkAborted();
        if (prevStep != null && currentStep != null) {
            if (!this.step.equals((Object)prevStep)) {
                throw new IllegalStateException("Called from illegal step: " + (Object)((Object)this.step));
            }
        } else {
            throw new NullPointerException("NULL: " + (Object)((Object)prevStep) + " " + (Object)((Object)currentStep));
        }
        this.checkThread();
        this.step = currentStep;
    }

    private void checkAborted() {
        if (!this.working) {
            throw new MinecraftLauncherAborted("Aborted at step: " + (Object)((Object)this.step));
        }
    }

    private void checkWorking() {
        if (this.working) {
            throw new IllegalStateException("Launcher is working!");
        }
    }

    @Override
    public void onJavaProcessPrint(JavaProcess process, PrintStreamType streamType, String line) {
        LOGGER.info(MARKERS[streamType.ordinal()], line);
        if (this.processLogger != null && streamType == PrintStreamType.OUT) {
            this.processLogger.log(line);
        }
    }

    @Override
    public void onJavaProcessEnded(JavaProcess jp) {
        this.notifyClose();
        int exit = jp.getExitCode();
        LOGGER.info("Child process closed with exit code: {} ({})", (Object)exit, (Object)("0x" + Integer.toHexString(exit)));
        this.exitCode = exit;
        if (this.processLogger != null) {
            try {
                this.processLogger.close();
            }
            catch (IOException e) {
                LOGGER.warn("Process logger failed to close", (Throwable)e);
            }
        }
        if (this.settings.getBoolean("minecraft.crash") && !this.killed && (System.currentTimeMillis() - this.startupTime < 5000L || exit != 0)) {
            CrashManager crashManager = new CrashManager(this);
            for (MinecraftListener listener : this.listeners) {
                listener.onCrashManagerInit(crashManager);
            }
            crashManager.startAndJoin();
            if (crashManager.getCrash().getEntry() == null || !crashManager.getCrash().getEntry().isFake()) {
                return;
            }
        }
        if (!this.assistLaunch) {
            TLauncher.kill();
        }
    }

    @Override
    public void onJavaProcessError(JavaProcess jp, Throwable e) {
        this.notifyClose();
        for (MinecraftListener listener : this.listeners) {
            listener.onMinecraftError(e);
        }
    }

    private synchronized void waitForClose() {
        while (this.minecraftWorking) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void notifyClose() {
        this.minecraftWorking = false;
        MinecraftLauncher.updateLoggerActions();
        if (System.currentTimeMillis() - this.startupTime < 5000L) {
            U.sleepFor(1000L);
        }
        this.notifyAll();
        for (MinecraftListener listener : this.listeners) {
            listener.onMinecraftClose();
        }
    }

    private void removeFrom(File zipFile, List<String> entries) throws IOException {
        File tempFile = new File(zipFile.getAbsolutePath() + "." + System.currentTimeMillis());
        tempFile.delete();
        tempFile.deleteOnExit();
        boolean renameOk = zipFile.renameTo(tempFile);
        if (!renameOk) {
            throw new IOException("Could not rename the file " + zipFile.getAbsolutePath() + " -> " + tempFile.getAbsolutePath());
        }
        LOGGER.debug("Removing entries from {}", (Object)zipFile);
        byte[] buf = new byte[1024];
        ZipInputStream zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(tempFile)));
        ZipOutputStream zout = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
        ZipEntry entry = zin.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            if (entries.contains(name)) {
                LOGGER.debug("Removed: {}", (Object)name);
            } else {
                int len;
                zout.putNextEntry(new ZipEntry(name));
                while ((len = zin.read(buf)) > 0) {
                    zout.write(buf, 0, len);
                }
            }
            entry = zin.getNextEntry();
        }
        zin.close();
        zout.close();
        tempFile.delete();
    }

    private Rule.FeatureMatcher createFeatureMatcher() {
        return new CurrentLaunchFeatureMatcher();
    }

    private StrSubstitutor createArgumentsSubstitutor() throws MinecraftException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("clientid", "");
        map.put("auth_xuid", "");
        map.putAll(((User)this.account.getUser()).getLoginCredentials().map());
        map.put("version_name", this.version.getID());
        map.put("game_directory", this.gameDir.getAbsolutePath());
        map.put("game_assets", this.localAssetsDir.getAbsolutePath());
        map.put("assets_root", this.globalAssetsDir.getAbsolutePath());
        map.put("assets_index_name", this.version.getAssetIndex().getId());
        map.put("version_type", this.version.getType());
        String libraryDirPath = new File(this.rootDir, "libraries").getAbsolutePath();
        map.put("library_directory", libraryDirPath);
        map.put("game_libraries_directory", libraryDirPath);
        map.put("forge_transformers", this.version.getTransformers(this.featureMatcher).stream().map(Library::getName).collect(Collectors.joining(",")));
        if (this.windowSize[0] > 0 && this.windowSize[1] > 0) {
            map.put("resolution_width", String.valueOf(this.windowSize[0]));
            map.put("resolution_height", String.valueOf(this.windowSize[1]));
        } else {
            map.put("resolution_width", "");
            map.put("resolution_height", "");
        }
        map.put("language", "en-us");
        if (this.resourceChecker != null) {
            for (AssetIndex.AssetObject asset : this.resourceChecker.getAssetList()) {
                String hash = asset.getHash();
                String path = new File(this.assetsObjectsDir, hash.substring(0, 2) + "/" + hash).getAbsolutePath();
                map.put("asset=" + asset.getHash(), path);
            }
        }
        map.put("launcher_name", "java-minecraft-launcher");
        map.put("launcher_version", CAPABLE_WITH);
        map.put("natives_directory", this.nativeDir.getAbsolutePath());
        map.put("classpath", this.constructClassPath(this.version));
        map.put("classpath_separator", System.getProperty("path.separator"));
        map.put("primary_jar", new File(this.rootDir, "versions/" + this.version.getID() + "/" + this.version.getID() + ".jar").getAbsolutePath());
        return new StrSubstitutor(map);
    }

    private int getJreMajorVersion() throws MinecraftLauncherAborted {
        if (this.javaVersion == null) {
            if (this.jreType instanceof JavaManagerConfig.Current) {
                this.javaVersion = OS.JAVA_VERSION;
            } else {
                JavaVersionDetector detector = new JavaVersionDetector(Objects.requireNonNull(this.jreExec, "jreExec"));
                try {
                    this.javaVersion = detector.detect();
                }
                catch (JavaVersionNotDetectedException e) {
                    LOGGER.warn("Couldn't detect Java version", (Throwable)e);
                    if (this.jreType instanceof JavaManagerConfig.Recommended) {
                        if (this.recommendedJavaVersion != null) {
                            LOGGER.warn("Falling back to JavaVersion: {}", (Object)this.recommendedJavaVersion.getMajorVersion());
                            return this.recommendedJavaVersion.getMajorVersion();
                        }
                        LOGGER.warn("recommendedJavaVersion == null");
                    }
                    this.javaVersion = JavaVersion.UNKNOWN;
                }
                catch (InterruptedException interruptedException) {
                    throw new MinecraftLauncherAborted(interruptedException);
                }
            }
        }
        return this.javaVersion.getMajor();
    }

    private Library findLog4j2Library() {
        return this.version.getLibraries().stream().filter(l -> l.getName().startsWith(LOG4J_CORE)).findAny().orElse(null);
    }

    private Log4jVersion parseLog4jVersion(Library log4jLibrary) {
        String libraryVersion;
        Pattern log4jVersionPattern = Pattern.compile("(?<major>\\d+)\\.(?<minor>\\d+)(?:\\.(?<patch>\\d+))?(?:-.+)?");
        Matcher matcher = log4jVersionPattern.matcher(libraryVersion = log4jLibrary.getName().substring(LOG4J_CORE.length()));
        if (matcher.matches()) {
            int major = Integer.parseInt(matcher.group("major"));
            int minor = Integer.parseInt(matcher.group("minor"));
            return new Log4jVersion(major, minor);
        }
        LOGGER.warn("Unknown log4j2 version: {}", (Object)libraryVersion);
        Sentry.capture((EventBuilder)new EventBuilder().withLevel(Event.Level.WARNING).withMessage("unknown log4j2 version: " + libraryVersion));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String savePatchedConfiguration(File logConfigsDir, String variant) throws IOException {
        InputStream loggingFileStream = this.getClass().getResourceAsStream("logging/log4j2-" + variant + ".xml");
        if (loggingFileStream == null) {
            throw new IOException("patched logging file not found: " + variant);
        }
        File file = new File(logConfigsDir, "patched-variant-2." + variant + ".xml");
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            IOUtils.copy((InputStream)loggingFileStream, (OutputStream)outputStream);
        }
        finally {
            loggingFileStream.close();
        }
        return file.getAbsolutePath();
    }

    private void executeJarScanner() throws MinecraftLauncherAborted {
        if (this.settings.getInteger("jarscanner") >= 2) {
            LOGGER.info("jarscanner skipped: already scanned");
            return;
        }
        Path modsFolder = this.gameDir.toPath().resolve("mods");
        if (!Files.isDirectory(modsFolder, new LinkOption[0])) {
            LOGGER.info("jarscanner skipped: no mods folder");
            return;
        }
        for (MinecraftExtendedListener type1 : this.extListeners) {
            type1.onMinecraftMalwareScanning();
        }
        this.settings.set("jarscanner", 2);
        long startTime = System.currentTimeMillis();
        final ExecutorService service = Executors.newFixedThreadPool(2);
        final AtomicBoolean found = new AtomicBoolean();
        try {
            Files.walkFileTree(modsFolder, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    JarFile jarFile;
                    if (!file.toString().endsWith(".jar")) {
                        return FileVisitResult.CONTINUE;
                    }
                    try {
                        jarFile = new JarFile(file.toFile());
                    }
                    catch (Exception e) {
                        LOGGER.warn("Couldn't open {}", (Object)file);
                        return FileVisitResult.CONTINUE;
                    }
                    service.submit(() -> MinecraftLauncher.this.scanJarFile(jarFile, infectedEntry -> {
                        LOGGER.warn("jarscanner detected in {}: {}", (Object)file, infectedEntry);
                        found.set(true);
                        Stats.jarscannedDetected(file.getFileName().toString(), infectedEntry, FileUtil.getChecksum(file.toFile(), "SHA-256"));
                    }));
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Couldn't walk mods folder; skipping it entirely", (Throwable)e);
            this.settings.set("jarscanner", 2);
            return;
        }
        service.shutdown();
        int minutes = 1;
        while (true) {
            boolean terminated;
            try {
                terminated = service.awaitTermination(minutes, TimeUnit.MINUTES);
            }
            catch (InterruptedException ignored) {
                service.shutdownNow();
                throw new MinecraftLauncherAborted("jarscanner aborted");
            }
            if (terminated) break;
            if (!Alert.showQuestion("", Localizable.get("jarscanner.takes-time"))) {
                LOGGER.info("User chose to skip scanning");
                service.shutdownNow();
                return;
            }
            LOGGER.info("User chose to continue scanning; will ask again in 10 minutes");
            minutes = 10;
        }
        long delta = System.currentTimeMillis() - startTime;
        LOGGER.info("jarscanner done in {} ms", (Object)delta);
        Stats.jarscannedCompleted(delta / 1000L);
        if (found.get()) {
            LOGGER.warn("jarscanner has detected malware signatures");
            this.settings.set("jarscanner", 0);
            Alert.showError("", Localizable.get("jarscanner.detected"));
            throw new MinecraftLauncherAborted("jarscanner detected malware");
        }
        LOGGER.info("jarscanner hasn't detected malware signatures");
    }

    private void scanJarFile(JarFile jarFile, Consumer<String> callback) {
        try {
            this.scanJarFile0(jarFile, callback);
        }
        catch (IOException e) {
            LOGGER.warn("Error scanning: {}", (Object)jarFile.getName(), (Object)e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanJarFile0(JarFile jarFile, Consumer<String> callback) throws IOException, InterruptedException {
        LOGGER.info("Scanning: {} ({} entries)", (Object)jarFile.getName(), (Object)jarFile.size());
        try {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                byte[] classBytes;
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                if (!entry.getName().endsWith(".class")) continue;
                try (InputStream stream = jarFile.getInputStream(entry);){
                    classBytes = IOUtils.toByteArray((InputStream)stream);
                }
                if (!Detector.scanClass((byte[])classBytes)) continue;
                callback.accept(entry.getName());
                return;
            }
        }
        finally {
            jarFile.close();
        }
    }

    static {
        ARGS_LEGACY_REMOVED = Collections.unmodifiableList(Arrays.asList("--width", "${resolution_width}", "--height", "${resolution_height}"));
        ARGS_CENSORED = Collections.singletonList("--accessToken");
        CENSORED = Collections.unmodifiableList(Arrays.asList("not for you", "censored", "nothinginteresting", "boiiiiiiiiii", "Minecraft is a lie", "vk.cc/7iPiB9", "worp-worp"));
        CHILD_STDOUT = MarkerManager.getMarker((String)"child_stdout");
        CHILD_STDERR = MarkerManager.getMarker((String)"child_stderr");
        PrintStreamType[] types = PrintStreamType.values();
        Validate.isTrue((types.length == 2 ? 1 : 0) != 0, (String)("please check " + PrintStreamType.class.getSimpleName() + "values"), (Object[])new Object[0]);
        MARKERS = new Marker[types.length];
        MinecraftLauncher.MARKERS[PrintStreamType.OUT.ordinal()] = CHILD_STDOUT;
        MinecraftLauncher.MARKERS[PrintStreamType.ERR.ordinal()] = CHILD_STDERR;
    }

    public static enum MinecraftLauncherStep {
        NONE,
        COLLECTING,
        DOWNLOADING,
        CONSTRUCTING,
        LAUNCHING,
        POSTLAUNCH;

    }

    static class MinecraftLauncherAborted
    extends RuntimeException {
        MinecraftLauncherAborted(String message) {
            super(message);
        }

        MinecraftLauncherAborted(Throwable cause) {
            super(cause);
        }
    }

    private static class Log4jVersion {
        final int major;
        final int minor;

        public Log4jVersion(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        public String toString() {
            return this.major + "." + this.minor;
        }
    }

    public static enum LoggerVisibility {
        ALWAYS,
        ON_CRASH,
        NONE;

    }
}

