/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft.launcher;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.logger.LogFile;

public class ChildProcessLogger
implements Closeable {
    private static final Logger LOGGER = LogManager.getLogger(ChildProcessLogger.class);
    private final LogFile logFile;
    private Writer writer;

    public ChildProcessLogger(LogFile logFile) throws IOException {
        this.logFile = logFile;
        this.writer = logFile.write();
    }

    public LogFile getLogFile() {
        return this.logFile;
    }

    public void log(String line) {
        if (this.writer == null) {
            LOGGER.warn("Tried to log after closing: {}", (Object)line);
            return;
        }
        try {
            this.writer.write(line);
            this.writer.write(10);
        }
        catch (IOException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Couldn't write into logger", (Throwable)e);
            }
            LOGGER.warn("Couldn't write into logger: {}", (Object)e.toString());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    public static ChildProcessLogger create(Charset charset) throws IOException {
        File tempFile = File.createTempFile("tl-logger", ".txt");
        tempFile.deleteOnExit();
        return new ChildProcessLogger(new LogFile(tempFile, charset));
    }
}

