/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft.crash;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.ToStringBuilder;
import ru.turikhay.tlauncher.minecraft.crash.CrashEntry;
import ru.turikhay.tlauncher.minecraft.crash.CrashManager;
import ru.turikhay.tlauncher.minecraft.launcher.ChildProcessLogger;

public class PatternEntry
extends CrashEntry {
    private final Pattern pattern;
    private Matcher match;

    public PatternEntry(CrashManager manager, String name, Pattern pattern) {
        super(manager, name);
        this.pattern = Objects.requireNonNull(pattern, "pattern");
    }

    protected Matcher getMatch() {
        return this.match;
    }

    @Override
    protected boolean checkCapability() throws Exception {
        if (!super.checkCapability()) {
            return false;
        }
        try (Scanner scanner = this.getScanner();){
            while (scanner.hasNextLine()) {
                Matcher matcher = this.pattern.matcher(scanner.nextLine());
                if (!matcher.matches()) continue;
                this.match = matcher;
                this.getManager().getCrash().addExtra("pattern:" + this.pattern, matcher.toString());
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    Scanner getScanner() throws IOException {
        return PatternEntry.getScanner(this.getManager().getProcessLogger());
    }

    static Scanner getScanner(ChildProcessLogger processLogger) throws IOException {
        return new Scanner(processLogger.getLogFile().read());
    }

    static boolean matchPatterns(Scanner scanner, List<Pattern> patterns, ArrayList<String> matches) {
        int expectedPatternIndex = 0;
        while (scanner.hasNextLine()) {
            String line;
            Pattern expectedPattern = patterns.get(expectedPatternIndex);
            Matcher m = expectedPattern.matcher(line = scanner.nextLine());
            if (!m.matches()) continue;
            if (matches != null) {
                for (int i = 1; i <= m.groupCount(); ++i) {
                    matches.add(m.group(i));
                }
            }
            if (++expectedPatternIndex != patterns.size()) continue;
            break;
        }
        return expectedPatternIndex == patterns.size();
    }

    @Override
    public ToStringBuilder buildToString() {
        return super.buildToString().append("pattern", (Object)this.pattern);
    }
}

