/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft.crash;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.ToStringBuilder;
import ru.turikhay.tlauncher.minecraft.crash.CrashEntry;
import ru.turikhay.tlauncher.minecraft.crash.CrashManager;
import ru.turikhay.tlauncher.minecraft.crash.PatternEntry;

public abstract class PatternContainerEntry
extends CrashEntry {
    private final List<PatternEntry> patternEntries = new ArrayList<PatternEntry>();
    private boolean anyPatternMakesCapable;

    public PatternContainerEntry(CrashManager manager, String name) {
        super(manager, name);
    }

    public final boolean isAnyPatternMakesCapable() {
        return this.anyPatternMakesCapable;
    }

    protected final void setAnyPatternMakesCapable(boolean anyPatternMakesCapable) {
        this.anyPatternMakesCapable = anyPatternMakesCapable;
    }

    protected final void addPattern(PatternEntry entry) {
        this.patternEntries.add(entry);
    }

    protected final PatternEntry addPattern(String name, Pattern pattern) {
        PatternEntry entry = new PatternEntry(this.getManager(), name, pattern);
        this.addPattern(entry);
        return entry;
    }

    @Override
    protected boolean checkCapability() throws Exception {
        if (!super.checkCapability()) {
            return false;
        }
        ArrayList<PatternEntry> capablePatterns = new ArrayList<PatternEntry>();
        for (PatternEntry entry : this.patternEntries) {
            if (!entry.checkCapability()) continue;
            capablePatterns.add(entry);
            if (!this.anyPatternMakesCapable) continue;
            break;
        }
        return !capablePatterns.isEmpty() && this.checkCapability(capablePatterns);
    }

    protected abstract boolean checkCapability(List<PatternEntry> var1);

    @Override
    public ToStringBuilder buildToString() {
        return super.buildToString().append("patterns", this.patternEntries);
    }
}

