/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft.crash;

import java.util.Locale;
import java.util.regex.Pattern;
import net.minecraft.launcher.versions.CompleteVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.managers.JavaManager;
import ru.turikhay.tlauncher.managers.JavaManagerConfig;
import ru.turikhay.tlauncher.minecraft.crash.CrashManager;
import ru.turikhay.tlauncher.minecraft.crash.PatternEntry;
import ru.turikhay.tlauncher.ui.loc.Localizable;

public class Java16Entry
extends PatternEntry {
    private static final Logger LOGGER = LogManager.getLogger(Java16Entry.class);

    public Java16Entry(CrashManager manager) {
        super(manager, "java16", Pattern.compile("^Exception in thread \"main\" java.lang.UnsupportedClassVersionError: .+ has been compiled by a more recent version of the Java Runtime \\(class file version (?<classFileVersion>.+)\\), this version of the Java Runtime only recognizes class file versions up to .+$"));
    }

    @Override
    protected boolean checkCapability() throws Exception {
        if (!super.checkCapability()) {
            return false;
        }
        CompleteVersion version = this.getManager().getLauncher().getCompleteVersion();
        String requiredJavaVersion = this.getMatch() == null ? "???" : this.guessJavaVersionFromClassFileVersion(this.getMatch().group("classFileVersion"));
        String jreType = TLauncher.getInstance().getSettings().get(JavaManagerConfig.class).getJreTypeOrDefault().getType();
        if (jreType.equals("recommended")) {
            if (version.getReleaseTime() != null && version.getReleaseTime().toInstant().compareTo(JavaManager.JAVA16_UPGRADE_POINT) >= 0) {
                if (this.getManager().getLauncher().getJreType().getType().equals("current") && version.getJavaVersion() == null) {
                    this.setPath("force-update-version", new Object[0]);
                    this.addButton(this.getManager().getButton("force-update"));
                    return true;
                }
            } else {
                this.setPath("old-java", requiredJavaVersion);
            }
        } else {
            this.setPath("change-to-recommended", requiredJavaVersion);
            this.newButton("retry-with-recommended", () -> {
                TLauncher.getInstance().getFrame().mp.defaultScene.settingsForm.get().jre.setValue("recommended");
                TLauncher.getInstance().getFrame().mp.defaultScene.settingsForm.get().saveValues();
                TLauncher.getInstance().getUIListeners().getMinecraftUIListener().getCrashProcessingFrame().get().getCrashFrame().setVisible(false);
                TLauncher.getInstance().getFrame().mp.defaultScene.loginForm.startLauncher();
            }, new Object[0]);
            this.setPermitHelp(false);
        }
        return true;
    }

    private String guessJavaVersionFromClassFileVersion(String input) {
        double classFileVersion;
        try {
            classFileVersion = Double.parseDouble(input);
            if (classFileVersion < 52.0) {
                throw new RuntimeException("class file version is too old: " + classFileVersion);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Can't parse class file version: {}", (Object)input, (Object)e);
            return Localizable.get(this.getLocPath("version.unknown"));
        }
        return String.format(Locale.ROOT, "%.0f%s", classFileVersion - 44.0, classFileVersion > 62.0 ? " " + Localizable.get(this.getLocPath("version.guessed")) : "");
    }
}

