/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft.crash;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.minecraft.crash.Action;
import ru.turikhay.tlauncher.minecraft.crash.CrashManager;
import ru.turikhay.tlauncher.minecraft.crash.PatternContainerEntry;
import ru.turikhay.tlauncher.minecraft.crash.PatternEntry;
import ru.turikhay.util.OS;
import ru.turikhay.util.sysinfo.GraphicsCard;
import ru.turikhay.util.sysinfo.SystemInfo;

public class GraphicsEntry
extends PatternContainerEntry {
    private static final Logger LOGGER = LogManager.getLogger(GraphicsEntry.class);
    private final Pattern intelWin10BugJrePattern;
    private final Pattern intelWin10BugCardNamePattern;
    private final Pattern intelBugMinecraft1_10Pattern;
    private final PatternEntry amd;
    private final PatternEntry intel;

    public GraphicsEntry(CrashManager manager) {
        super(manager, "graphics");
        this.setAnyPatternMakesCapable(true);
        this.intelWin10BugJrePattern = manager.getVar("intel-win10-bug-jre-pattern") == null ? null : Pattern.compile("1\\.(?:[8-9]|[1-9][0-9]+)\\.[0-9](?:-.+|_(?!60)([1-9]?)(?:(1)[0-9]|[6-9])[0-9])");
        this.intelWin10BugCardNamePattern = manager.getVar("intel-win10-bug-card-pattern") == null ? Pattern.compile("Intel HD Graphics(?: [2-3]000)?") : Pattern.compile(manager.getVar("intel-win10-bug-card-pattern"));
        this.intelBugMinecraft1_10Pattern = manager.getVar("intel-bug-minecraft-1.10") == null ? Pattern.compile(".*1\\.(?:1[0-9]|[2-9][0-9])(?:\\.[\\d]+|)(?:-.+|)") : Pattern.compile(manager.getVar("intel-bug-minecraft-1.10"));
        this.addPattern("general", Pattern.compile("[\\s]*org\\.lwjgl\\.LWJGLException: Pixel format not accelerated"));
        this.addPattern("general", Pattern.compile("WGL: The driver does not appear to support OpenGL"));
        this.amd = this.addPattern("amd", Pattern.compile(manager.getVar("amd-pattern") == null ? "^#[ ]+C[ ]+\\[atio(?:gl|[0-9a-z]{2,})xx\\.dll\\+0x[0-9a-z]+]$" : manager.getVar("amd-pattern")));
        this.intel = this.addPattern("intel", Pattern.compile(manager.getVar("intel-pattern") == null ? "^# C[ ]+\\[ig[0-9a-z]+icd(?:32|64)\\.dll\\+0x[0-9a-z]+]$" : manager.getVar("intel-pattern")));
    }

    @Override
    protected boolean requiresSysInfo() {
        return true;
    }

    @Override
    protected boolean checkCapability(List<PatternEntry> capablePatterns) {
        boolean haveAmd;
        Optional<GraphicsCard> intelGraphics;
        SystemInfo sysInfo;
        if (!OS.WINDOWS.isCurrent()) {
            this.setPath("general-linux", new Object[0]);
            return true;
        }
        this.setPath("general", new Object[0]);
        if (capablePatterns.contains(this.amd)) {
            LOGGER.info("{} is relevant because the crash logs explicitly mention AMD graphics card drivers", (Object)this.getName());
            return this.setToUpdateDrivers("AMD");
        }
        if (capablePatterns.contains(this.intel)) {
            LOGGER.info("{} is relevant because the crash logs explicitly mention Intel graphics card drivers", (Object)this.getName());
            this.setToUpdateDrivers("Intel");
            if (this.intelBugMinecraft1_10Pattern.matcher(this.getManager().getVersion()).matches()) {
                LOGGER.info("We're currently running Minecraft 1.10+, but still having Intel HD graphics driver issue.");
                this.setPath("intel.1.10", new Object[0]);
                this.addButton(this.getManager().getButton("open-settings"));
            }
            return true;
        }
        try {
            sysInfo = this.getManager().getSystemInfoReporter().getReport().get();
        }
        catch (Exception e) {
            LOGGER.warn("Could not get system info result", (Throwable)e);
            return true;
        }
        if (OS.VERSION.contains("10.") && (intelGraphics = GraphicsEntry.getDisplayDevice(sysInfo, "intel")).filter(card -> this.intelWin10BugCardNamePattern.matcher(card.getName()).matches()).isPresent()) {
            LOGGER.info("Using DxDiag we found out that the machine is running on 1st or 2nd generation of Intel graphics chipset");
            LOGGER.debug("External pattern: {}", (Object)this.intelWin10BugJrePattern);
            if (this.intelWin10BugJrePattern == null ? (OS.JAVA_VERSION.getMajor() == 8 ? OS.JAVA_VERSION.getUpdate() > 60 : OS.JAVA_VERSION.getMajor() > 8) : this.intelWin10BugJrePattern.matcher(System.getProperty("java.version")).matches()) {
                LOGGER.info("We're currently running Java version on Windows 10 that have known incompatibility bug with 1st and 2nd generation Intel HD graphics chipsets");
                this.clearButtons();
                this.setPath("intel.downgrade-to-jre8u60", new Object[0]);
                this.newButton("intel.buttons.downgrade-to-jre8u60", new VarUrlAction("intel-bug-jre-link", "https://yadi.sk/d/dvzmBSqttQXhy/Java%208%20update%2045/Installers"), new Object[0]);
                return true;
            }
        }
        boolean haveIntel = GraphicsEntry.getDisplayDevice(sysInfo, "intel").isPresent();
        boolean haveNvidia = GraphicsEntry.getDisplayDevice(sysInfo, "nvidia").isPresent();
        boolean bl = haveAmd = GraphicsEntry.getDisplayDevice(sysInfo, "amd").isPresent() || GraphicsEntry.getDisplayDevice(sysInfo, "ati ").isPresent();
        if (haveIntel) {
            if (haveNvidia) {
                this.setToUpdateDrivers("Intel", "NVIDIA");
                this.newButton("intel-nvidia-select", new VarUrlAction("intel-nvidia-select-url", "https://wiki.llaun.ch/guide:gpu-select:nvidia"), new Object[0]);
                return true;
            }
            if (haveAmd) {
                this.setToUpdateDrivers("Intel", "AMD");
                this.newButton("intel-amd-select", new VarUrlAction("intel-nvidia-select-url", "https://wiki.llaun.ch/guide:gpu-select:amd"), new Object[0]);
                return true;
            }
            return this.setToUpdateDrivers("Intel");
        }
        if (haveAmd && haveNvidia) {
            return this.setToUpdateDrivers("AMD", "NVIDIA");
        }
        if (haveNvidia) {
            return this.setToUpdateDrivers("NVIDIA");
        }
        if (haveAmd) {
            return this.setToUpdateDrivers("AMD");
        }
        this.setPermitHelp(false);
        return true;
    }

    private boolean setToUpdateDrivers(String ... manufacturers) {
        this.clearButtons();
        StringBuilder nameBuilder = new StringBuilder();
        for (String manufacturerName : manufacturers) {
            nameBuilder.append(", ").append(manufacturerName);
            String manufacturer = manufacturerName.toLowerCase(Locale.ROOT);
            this.newButton("driver-update", new VarUrlAction(manufacturer + "-driver-update", "https://wiki.llaun.ch/update:driver:" + manufacturer), manufacturerName);
        }
        this.setPath("update-driver", nameBuilder.substring(", ".length()));
        if (manufacturers.length == 1) {
            this.setImage("logo-" + manufacturers[0].toLowerCase(Locale.ROOT) + "@32");
        }
        return true;
    }

    private static Optional<GraphicsCard> getDisplayDevice(SystemInfo systemInfo, String name) {
        name = name.toLowerCase(Locale.ROOT);
        for (GraphicsCard card : systemInfo.getGraphicsCards()) {
            if (card.getName() == null || !card.getName().toLowerCase(Locale.ROOT).contains(name)) continue;
            return Optional.of(card);
        }
        return Optional.empty();
    }

    private class VarUrlAction
    implements Action {
        private final String url;

        VarUrlAction(String varName, String fallbackUrl) {
            String url = GraphicsEntry.this.getManager().getVar(varName);
            if (url == null) {
                url = fallbackUrl;
            }
            this.url = url;
        }

        @Override
        public void execute() {
            OS.openLink(this.url);
        }
    }
}

