/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft.crash;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapterFactory;
import com.moandjiezana.toml.Toml;
import io.sentry.Sentry;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.interfaces.ExceptionInterface;
import io.sentry.event.interfaces.SentryInterface;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import net.minecraft.launcher.versions.json.LowerCaseEnumTypeAdapterFactory;
import net.minecraft.options.OptionsFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.configuration.ConfigurationDefaults;
import ru.turikhay.tlauncher.minecraft.crash.ArgsAction;
import ru.turikhay.tlauncher.minecraft.crash.BadMainClassEntry;
import ru.turikhay.tlauncher.minecraft.crash.BindableAction;
import ru.turikhay.tlauncher.minecraft.crash.Button;
import ru.turikhay.tlauncher.minecraft.crash.Crash;
import ru.turikhay.tlauncher.minecraft.crash.CrashEntry;
import ru.turikhay.tlauncher.minecraft.crash.CrashEntryList;
import ru.turikhay.tlauncher.minecraft.crash.CrashManagerListener;
import ru.turikhay.tlauncher.minecraft.crash.Entry;
import ru.turikhay.tlauncher.minecraft.crash.GraphicsEntry;
import ru.turikhay.tlauncher.minecraft.crash.IEntry;
import ru.turikhay.tlauncher.minecraft.crash.Java16Entry;
import ru.turikhay.tlauncher.minecraft.crash.PatternEntry;
import ru.turikhay.tlauncher.minecraft.launcher.ChildProcessLogger;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftLauncher;
import ru.turikhay.tlauncher.repository.Repository;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.scenes.DefaultScene;
import ru.turikhay.util.Compressor;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.OS;
import ru.turikhay.util.Time;
import ru.turikhay.util.async.ExtendedThread;
import ru.turikhay.util.sysinfo.DxDiagSystemInfoReporter;
import ru.turikhay.util.sysinfo.NoopSystemInfoReporter;
import ru.turikhay.util.sysinfo.OSHISystemInfoReporter;
import ru.turikhay.util.sysinfo.SequentialSystemInfoReporter;
import ru.turikhay.util.sysinfo.SystemInfo;
import ru.turikhay.util.sysinfo.SystemInfoReporter;

public final class CrashManager {
    private static final Logger LOGGER = LogManager.getLogger(CrashManager.class);
    private static final Marker LOG_FLUSHER = MarkerManager.getMarker((String)"log_flusher");
    private final ArrayList<CrashManagerListener> listeners = new ArrayList();
    private final Watchdog watchdog = new Watchdog();
    private final Gson gson;
    private final Crash crash;
    private final MinecraftLauncher launcher;
    private final String version;
    private final ChildProcessLogger processLogger;
    private final Charset charset;
    private final int exitCode;
    private final CrashEntryList.ListDeserializer listDeserializer;
    private final Map<String, IEntry> crashEntries = new LinkedHashMap<String, IEntry>();
    private final Map<String, BindableAction> actionsMap = new HashMap<String, BindableAction>();
    private List<String> skipFolders = new ArrayList<String>();
    private final SystemInfoReporter systemInfoReporter = this.initSystemInfoPrinter();
    private final Entry generatedFilesSeekerEntry = new GeneratedFilesSeeker();
    private final Entry crashDescriptionSeeker = new CrashDescriptionSeeker();
    private final Entry logFlusherEntry = new LogFlusherEntry();
    private final List<String> modVersionsFilter = Arrays.asList("forge", "fabric", "rift", "liteloader");
    private volatile boolean cancelled;

    private void setupActions() {
        this.actionsMap.clear();
        this.addAction(new BrowseAction(this.launcher == null ? new File("") : this.launcher.getGameDir()));
        this.addAction(new SetAction());
        this.addAction(new GuiAction());
        this.addAction(new ExitAction());
        this.addAction(new SetOptionAction(this.launcher == null ? new OptionsFile(new File("test.txt")) : this.launcher.getOptionsFile()));
        this.addAction(new ForceUpdateAction());
    }

    SystemInfoReporter getSystemInfoReporter() {
        return this.systemInfoReporter;
    }

    private void setupEntries() {
        this.crashEntries.clear();
        this.addEntry(new Java16Entry(this));
        this.addEntry(this.generatedFilesSeekerEntry);
        this.addEntry(this.crashDescriptionSeeker);
        this.addEntry(new ErroredModListAnalyzer());
        CrashEntryList internal = this.buildInternalSignatures();
        CrashEntryList external = this.buildExternalSignatures(internal);
        if (external == null) {
            this.addAllEntries(internal, "internal");
            this.skipFolders = internal.getSkipFolders();
        } else {
            this.addAllEntries(external, "external");
            this.skipFolders = external.getSkipFolders();
            LOGGER.info("Using external entries, because their revision ({}) is newer than the revision of the internal ones ({})", (Object)external.getRevision(), (Object)internal.getRevision());
        }
        this.addEntry(new GraphicsEntry(this));
        this.addEntry(new BadMainClassEntry(this));
        this.addEntry(this.logFlusherEntry);
    }

    private SystemInfoReporter initSystemInfoPrinter() {
        Optional<SystemInfoReporter> oshi = OSHISystemInfoReporter.createIfAvailable();
        if (OS.WINDOWS.isCurrent()) {
            DxDiagSystemInfoReporter dxDiag = new DxDiagSystemInfoReporter();
            return oshi.isPresent() ? new SequentialSystemInfoReporter(oshi.get(), dxDiag) : dxDiag;
        }
        return oshi.orElseGet(NoopSystemInfoReporter::new);
    }

    @Nonnull
    private CrashEntryList buildInternalSignatures() {
        try {
            return this.loadEntries(this.getClass().getResourceAsStream("signature.json"), "internal");
        }
        catch (Exception e) {
            throw new RuntimeException("could not load local signatures", e);
        }
    }

    @Nullable
    private CrashEntryList buildExternalSignatures(CrashEntryList internal) {
        CrashEntryList external;
        try {
            external = this.loadEntries(Compressor.uncompressMarked(Repository.EXTRA_VERSION_REPO.get("libraries/signature.json")), "external");
        }
        catch (Exception e) {
            LOGGER.warn("Could not load external entries", (Throwable)e);
            Sentry.capture((EventBuilder)new EventBuilder().withLevel(Event.Level.WARNING).withMessage("cannot load external crash entries").withSentryInterface((SentryInterface)new ExceptionInterface((Throwable)e)));
            return null;
        }
        if (external.getRevision() <= internal.getRevision()) {
            LOGGER.info("External signatures are older or the same: {}", (Object)external.getRevision());
            return null;
        }
        return external;
    }

    private CrashManager(MinecraftLauncher launcher, String version, ChildProcessLogger processLogger, Charset charset, int exitCode) {
        this.launcher = launcher;
        this.version = version;
        this.processLogger = processLogger;
        this.charset = Objects.requireNonNull(charset, "charset");
        this.exitCode = exitCode;
        this.listDeserializer = new CrashEntryList.ListDeserializer(this);
        this.gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new LowerCaseEnumTypeAdapterFactory()).registerTypeAdapter(CrashEntryList.class, (Object)this.listDeserializer).create();
        this.crash = new Crash(this);
    }

    public CrashManager(MinecraftLauncher launcher) {
        this(launcher, launcher.getVersion(), launcher.getProcessLogger(), launcher.getCharset(), launcher.getExitCode());
    }

    public CrashManager(String version, ChildProcessLogger processLogger, Charset charset, int exitCode) {
        this(null, version, processLogger, charset, exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAndJoin() {
        Watchdog watchdog = this.watchdog;
        synchronized (watchdog) {
            this.checkWorking();
            this.watchdog.unlockThread("start");
            try {
                this.watchdog.join();
            }
            catch (InterruptedException e) {
                LOGGER.debug("Thread was interrupted", (Throwable)e);
            }
        }
    }

    public void cancel() {
        this.cancelled = true;
        if (this.watchdog.executor != null) {
            this.watchdog.executor.interrupt();
        }
    }

    private void addAction(BindableAction action) {
        this.actionsMap.put(Objects.requireNonNull(action).getName(), action);
    }

    private <T extends IEntry> T addEntry(T entry) {
        if (this.crashEntries.containsKey(entry.getName())) {
            LOGGER.trace("Removing {}", (Object)this.crashEntries.get(entry.getName()));
        }
        this.crashEntries.put(entry.getName(), entry);
        return entry;
    }

    private CrashEntry addEntry(String name) {
        return this.addEntry(new CrashEntry(this, name));
    }

    private PatternEntry addEntry(String name, boolean fake, Pattern pattern) {
        PatternEntry entry = new PatternEntry(this, name, pattern);
        entry.setFake(fake);
        return this.addEntry(entry);
    }

    private PatternEntry addEntry(String name, Pattern pattern) {
        return this.addEntry(name, false, pattern);
    }

    private void addAllEntries(CrashEntryList entryList, String type) {
        for (CrashEntry entry : entryList.getSignatures()) {
            this.addEntry(entry);
        }
    }

    private CrashEntryList loadEntries(InputStream input, String type) throws Exception {
        LOGGER.trace("Loading {} entries...", (Object)type);
        try (InputStreamReader reader = new InputStreamReader(input, "UTF-8");){
            CrashEntryList crashEntryList = (CrashEntryList)this.gson.fromJson((Reader)reader, CrashEntryList.class);
            return crashEntryList;
        }
    }

    public MinecraftLauncher getLauncher() {
        return this.launcher;
    }

    public String getVersion() {
        return this.version;
    }

    public ChildProcessLogger getProcessLogger() {
        return Objects.requireNonNull(this.processLogger, "processLogger");
    }

    public boolean hasProcessLogger() {
        return this.processLogger != null;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Crash getCrash() {
        if (Thread.currentThread() != this.watchdog && Thread.currentThread() != this.watchdog.executor) {
            this.checkAlive();
        }
        Watchdog watchdog = this.watchdog;
        synchronized (watchdog) {
            return this.crash;
        }
    }

    BindableAction getAction(String name) {
        return this.actionsMap.get(name);
    }

    String getVar(String key) {
        return this.listDeserializer.getVars().get(key);
    }

    Button getButton(String name) {
        return this.listDeserializer.getButtons().get(name);
    }

    public Exception getError() {
        this.checkAlive();
        return this.watchdog.executor.error;
    }

    public void addListener(CrashManagerListener listener) {
        this.checkWorking();
        this.listeners.add(Objects.requireNonNull(listener, "listener"));
    }

    private void checkAlive() {
        if (this.watchdog.isAlive()) {
            throw new IllegalStateException("thread is alive");
        }
    }

    private void checkWorking() {
        if (this.watchdog.isWorking()) {
            throw new IllegalStateException("thread is working");
        }
    }

    private Scanner getCrashFileScanner() throws IOException {
        File crashFile = this.crash.getCrashFile();
        if (crashFile == null || !crashFile.isFile()) {
            LOGGER.info("Crash report file doesn't exist. May be looking into logs?");
            return PatternEntry.getScanner(this.getProcessLogger());
        }
        LOGGER.info("Crash report file exist. We'll scan it.");
        return new Scanner(new InputStreamReader((InputStream)new FileInputStream(crashFile), FileUtil.getCharset()));
    }

    private static class BrowseAction
    extends ArgsAction {
        private final File gameDir;

        BrowseAction(File gameDir) {
            super("browse", new String[]{"www", "folder"});
            this.gameDir = gameDir;
        }

        @Override
        void execute(OptionSet args) {
            String folderName;
            File folder;
            if (args.has("www")) {
                OS.openLink(args.valueOf("www").toString());
                return;
            }
            if (args.has("folder") && (folder = (folderName = args.valueOf("folder").toString()).startsWith(".") ? new File(this.gameDir, folderName.substring(1)) : new File(folderName)).isDirectory()) {
                OS.openFolder(folder);
            }
        }
    }

    private static class SetAction
    extends ArgsAction {
        private static final Logger LOGGER = LogManager.getLogger(SetAction.class);
        private final Map<OptionSpec<String>, String> optionMap = new HashMap<OptionSpec<String>, String>();

        SetAction() {
            super("set");
            for (String key : ConfigurationDefaults.getInstance().getMap().keySet()) {
                this.optionMap.put((OptionSpec<String>)this.parser.accepts(key).withRequiredArg().ofType(String.class), key);
            }
        }

        @Override
        void execute(OptionSet args) {
            for (OptionSpec spec : args.specs()) {
                String key = this.optionMap.get(spec);
                if (key == null) {
                    LOGGER.warn("Could not find key for spec {}", (Object)spec);
                    continue;
                }
                String value = (String)spec.value(args);
                if ("minecraft.memory".equals(key) && "fix".equals(value)) {
                    LOGGER.info("Migrating minecraft.memory = fix => minecraft.xmx = \"auto\"");
                    key = "minecraft.xmx";
                    value = "auto";
                }
                LOGGER.info("Set configuration key {} = {}", (Object)key, (Object)value);
                TLauncher.getInstance().getSettings().set(key, value);
                if (!TLauncher.getInstance().getFrame().mp.defaultScene.settingsForm.isLoaded()) continue;
                TLauncher.getInstance().getFrame().mp.defaultScene.settingsForm.get().updateValues();
            }
        }
    }

    private static class GuiAction
    extends BindableAction {
        public GuiAction() {
            super("gui");
        }

        @Override
        public void execute(String args) {
            if (args.startsWith("settings")) {
                TLauncher.getInstance().getFrame().mp.setScene(TLauncher.getInstance().getFrame().mp.defaultScene);
                TLauncher.getInstance().getFrame().mp.defaultScene.setSidePanel(DefaultScene.SidePanel.SETTINGS);
                if (args.equals("settings-tlauncher")) {
                    TLauncher.getInstance().getFrame().mp.defaultScene.settingsForm.get().getTabPane().setSelectedIndex(1);
                }
                return;
            }
            if (args.equals("accounts")) {
                TLauncher.getInstance().getFrame().mp.setScene(TLauncher.getInstance().getFrame().mp.accountManager.get());
            }
            if (args.equals("versions")) {
                TLauncher.getInstance().getFrame().mp.setScene(TLauncher.getInstance().getFrame().mp.versionManager.get());
            }
        }
    }

    private static class ExitAction
    extends BindableAction {
        public ExitAction() {
            super("exit");
        }

        @Override
        public void execute(String arg) {
            TLauncher.getInstance().getUIListeners().getMinecraftUIListener().getCrashProcessingFrame().get().getCrashFrame().setVisible(false);
        }
    }

    private static class SetOptionAction
    extends BindableAction {
        private final OptionsFile file;

        public SetOptionAction(OptionsFile file) {
            super("option");
            this.file = Objects.requireNonNull(file, "file");
        }

        @Override
        public void execute(String arg) throws Exception {
            for (String optionPair : StringUtils.split((String)arg, (char)';')) {
                String[] pair = StringUtils.split((String)optionPair, (char)':');
                String key = pair[0];
                String value = pair[1];
                this.file.set(key, value);
            }
            this.file.save();
            Alert.showLocMessage("crash.actions.set-options");
        }
    }

    private static class ForceUpdateAction
    extends BindableAction {
        public ForceUpdateAction() {
            super("force-update");
        }

        @Override
        public void execute(String arg) {
            TLauncher.getInstance().getUIListeners().getMinecraftUIListener().getCrashProcessingFrame().get().getCrashFrame().setVisible(false);
            TLauncher.getInstance().getFrame().mp.defaultScene.loginForm.checkbox.forceupdate.setSelected(true);
            TLauncher.getInstance().getFrame().mp.defaultScene.loginForm.startLauncher();
        }
    }

    private class ErroredModListAnalyzer
    extends CrashEntry {
        private final Pattern modPattern;
        private final ArrayList<Pattern> patterns;

        ErroredModListAnalyzer() {
            super(CrashManager.this, "errored mod list analyzer");
            this.patterns = new ArrayList();
            this.modPattern = Pattern.compile("^[\\W]+[ULCHIJAD]*([ULCHIJADE])[\\W]+.+\\{.+}[\\W]+\\[(.+)][\\W]+\\((.+)\\).*");
            this.patterns.add(Pattern.compile("^-- System Details --$"));
            this.patterns.add(Pattern.compile("^[\\W]+FML: MCP .+$"));
            this.patterns.add(Pattern.compile("^[\\W]+States: .+$"));
        }

        @Override
        protected boolean checkCapability() throws Exception {
            ArrayList<ErroredMod> errorModList = new ArrayList<ErroredMod>();
            try (Scanner scanner = CrashManager.this.getCrashFileScanner();){
                if (PatternEntry.matchPatterns(scanner, this.patterns, null)) {
                    LOGGER.debug("Not all patterns met. Skipping");
                    boolean bl = false;
                    return bl;
                }
                LOGGER.debug("All patterns are met. Working on a mod list");
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    Matcher matcher = this.modPattern.matcher(line);
                    if (!matcher.matches() || !"e".equalsIgnoreCase(matcher.group(1))) continue;
                    ErroredMod mod = new ErroredMod(matcher);
                    errorModList.add(mod);
                    LOGGER.debug("Added: {}", (Object)mod);
                }
            }
            if (errorModList.isEmpty()) {
                LOGGER.info("Could not find mods that caused the crash.");
                return false;
            }
            LOGGER.info("Crash probably caused by the following mods: {}", errorModList);
            boolean multiple = errorModList.size() > 1;
            this.setTitle("crash.analyzer.errored-mod.title", multiple ? StringUtils.join(errorModList, (String)", ") : errorModList.get(0));
            StringBuilder body = new StringBuilder();
            if (multiple) {
                for (ErroredMod mod : errorModList) {
                    body.append("\u2013 ");
                    mod.append(body);
                    body.append("\n");
                }
            } else {
                body.append(((ErroredMod)errorModList.get(0)).name);
            }
            this.setBody("crash.analyzer.errored-mod.body." + (multiple ? "multiple" : "single"), body.toString(), ((ErroredMod)errorModList.get(0)).fileName);
            this.addButton(CrashManager.this.getButton("logs"));
            if (CrashManager.this.getLauncher() != null) {
                this.newButton("errored-mod-delete." + (multiple ? "multiple" : "single"), () -> {
                    String prefix = "crash.analyzer.buttons.errored-mod-delete.";
                    File modsDir = new File(CrashManager.this.getLauncher().getGameDir(), "mods");
                    if (!modsDir.isDirectory()) {
                        Alert.showLocError("crash.analyzer.buttons.errored-mod-delete.error.title", "crash.analyzer.buttons.errored-mod-delete.error.no-mods-folder");
                        return;
                    }
                    boolean success = true;
                    for (ErroredMod mod : errorModList) {
                        File modFile = new File(modsDir, mod.fileName);
                        if (modFile.delete() || !modFile.isFile()) continue;
                        Alert.showLocError("crash.analyzer.buttons.errored-mod-delete.error.title", "crash.analyzer.buttons.errored-mod-delete.error.could-not-delete", modFile);
                        success = false;
                    }
                    if (success) {
                        Alert.showLocMessage("crash.analyzer.buttons.errored-mod-delete.success.title", "crash.analyzer.buttons.errored-mod-delete.success." + (errorModList.size() > 1 ? "multiple" : "single"), null);
                    }
                    CrashManager.this.getAction("exit").execute("");
                }, new Object[0]);
            }
            CrashManager.this.crash.addExtra("erroredModList", ((Object)errorModList).toString());
            return true;
        }
    }

    private class Watchdog
    extends ExtendedThread {
        private final Executor executor;

        Watchdog() {
            this.executor = new Executor();
            this.startAndWait();
        }

        boolean isWorking() {
            return this.isAlive() && !this.isThreadLocked();
        }

        @Override
        public void run() {
            this.lockThread("start");
            for (Iterator listener : CrashManager.this.listeners) {
                listener.onCrashManagerProcessing(CrashManager.this);
            }
            try {
                this.watchExecutor();
            }
            catch (CrashManagerInterrupted interrupted) {
                for (CrashManagerListener listener : CrashManager.this.listeners) {
                    listener.onCrashManagerCancelled(CrashManager.this);
                }
                return;
            }
            catch (Exception e) {
                Sentry.capture((EventBuilder)new EventBuilder().withMessage("crash manager crashed").withSentryInterface((SentryInterface)new ExceptionInterface((Throwable)e)).withExtra("crash", (Object)CrashManager.this.crash));
                for (CrashManagerListener listener : CrashManager.this.listeners) {
                    listener.onCrashManagerFailed(CrashManager.this, e);
                }
                return;
            }
            for (Iterator listener : CrashManager.this.listeners) {
                listener.onCrashManagerComplete(CrashManager.this, CrashManager.this.crash);
            }
        }

        private void watchExecutor() throws Exception {
            this.executor.unlockThread("start");
            try {
                this.executor.join();
            }
            catch (InterruptedException e) {
                throw new CrashManagerInterrupted(e);
            }
            if (this.executor.error != null) {
                throw this.executor.error;
            }
        }
    }

    private class GeneratedFilesSeeker
    extends Entry {
        final Pattern crashFilePattern;
        final Pattern nativeCrashFilePattern;

        GeneratedFilesSeeker() {
            super(CrashManager.this, "generated files seeker");
            this.crashFilePattern = Pattern.compile("^.*#@!@# Game crashed!.+@!@# (.+)$");
            this.nativeCrashFilePattern = Pattern.compile("# (.+)$");
        }

        @Override
        protected void execute() throws Exception {
            try (Scanner scanner = PatternEntry.getScanner(CrashManager.this.getProcessLogger());){
                while (scanner.hasNextLine()) {
                    String nativeCrashFile;
                    String line = scanner.nextLine();
                    String crashFile = this.get(this.crashFilePattern, line);
                    if (crashFile != null) {
                        CrashManager.this.crash.setCrashFile(crashFile);
                        continue;
                    }
                    if (!line.equals("# An error report file with more information is saved as:") || !scanner.hasNextLine() || (nativeCrashFile = this.get(this.nativeCrashFilePattern, line = scanner.nextLine())) == null) continue;
                    CrashManager.this.crash.setNativeCrashFile(nativeCrashFile);
                }
            }
        }

        private String get(Pattern pattern, String line) {
            Matcher matcher = pattern.matcher(line);
            if (matcher.matches() && matcher.groupCount() == 1) {
                return matcher.group(1);
            }
            return null;
        }
    }

    private class CrashDescriptionSeeker
    extends Entry {
        private final List<Pattern> patternList;

        CrashDescriptionSeeker() {
            super(CrashManager.this, "crash description seeker");
            this.patternList = Arrays.asList(Pattern.compile(".*[-]+.*Minecraft Crash Report.*[-]+"), Pattern.compile(".*Description: (?i:(?!.*debug.*))(.*)"));
        }

        @Override
        protected void execute() throws Exception {
            LOGGER.debug("Looking for crash description...");
            try (Scanner scanner = CrashManager.this.getCrashFileScanner();){
                ArrayList<String> matches = new ArrayList<String>();
                String description = null;
                if (PatternEntry.matchPatterns(scanner, this.patternList, matches)) {
                    if (matches.isEmpty()) {
                        LOGGER.debug("No description?");
                    } else {
                        description = matches.get(0);
                    }
                }
                if (description == null) {
                    LOGGER.info("Could not find crash description");
                    return;
                }
                String line = null;
                if (scanner.hasNextLine() && (StringUtils.isBlank((CharSequence)(line = scanner.nextLine())) || line.endsWith("[STDOUT] "))) {
                    line = scanner.nextLine();
                }
                if (StringUtils.isBlank(line) || line.endsWith("[STDOUT] ")) {
                    LOGGER.debug("Stack trace line is empty?");
                    StringBuilder moreLines = new StringBuilder();
                    for (int additionalLines = 0; scanner.hasNextLine() && additionalLines < 10; ++additionalLines) {
                        moreLines.append('\n').append(scanner.nextLine());
                    }
                    CrashManager.this.crash.addExtra("moreLines", moreLines.toString());
                    CrashManager.this.crash.addExtra("stackTraceLineIsEmpty", "");
                    return;
                }
                CrashManager.this.crash.setJavaDescription(line);
                StringBuilder stackTraceBuilder = new StringBuilder();
                while (scanner.hasNextLine() && !StringUtils.isBlank((CharSequence)(line = scanner.nextLine()))) {
                    stackTraceBuilder.append('\n').append(line);
                }
                if (stackTraceBuilder.length() > 1) {
                    CrashManager.this.crash.setStackTrace(stackTraceBuilder.substring(1));
                }
            }
        }
    }

    private class LogFlusherEntry
    extends Entry {
        public LogFlusherEntry() {
            super(CrashManager.this, "log flusher");
        }

        @Override
        protected void execute() {
            this.readFile(CrashManager.this.getCrash().getCrashFile());
            this.readFile(CrashManager.this.getCrash().getNativeCrashFile());
            if (CrashManager.this.getLauncher() != null) {
                if (CrashManager.this.modVersionsFilter.stream().anyMatch(CrashManager.this.getVersion().toLowerCase(Locale.ROOT)::contains)) {
                    File modsDir = new File(CrashManager.this.getLauncher().getGameDir(), "mods");
                    if (!modsDir.isDirectory()) {
                        LOGGER.info("No \"mods\" folder found");
                    } else {
                        this.treeDir(modsDir, 2);
                    }
                    this.writeDelimiter();
                }
            }
            if (TLauncher.getInstance() != null) {
                SystemInfo systemInfo;
                try {
                    systemInfo = CrashManager.this.systemInfoReporter.getReport().get();
                }
                catch (InterruptedException | ExecutionException e) {
                    LOGGER.warn("Could not retrieve system info", (Throwable)e);
                    systemInfo = null;
                }
                if (systemInfo == null) {
                    LOGGER.warn("No system info is available");
                } else {
                    LOGGER.info("System info:");
                    systemInfo.getLines().forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
                }
            }
        }

        private void writeDelimiter() {
            LOGGER.info("++++++++++++++++++++++++++++++++++");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readFile(File file) {
            if (file == null) {
                return;
            }
            try {
                if (!file.isFile()) {
                    LOGGER.warn("File doesn't exist: {}", (Object)file);
                    return;
                }
                LOGGER.info("Reading file: {}", (Object)file);
                try (Scanner scanner = new Scanner(new InputStreamReader((InputStream)new FileInputStream(file), CrashManager.this.charset));){
                    while (scanner.hasNextLine()) {
                        LOGGER.info(LOG_FLUSHER, scanner.nextLine());
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Could not read file: {}", (Object)file, (Object)e);
                }
            }
            finally {
                this.writeDelimiter();
            }
        }

        private void treeDir(File dir, int levelLimit) {
            this.treeDir(dir, 0, levelLimit, new StringBuilder());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void treeDir(File dir, int currentLevel, int levelLimit, StringBuilder buffer) {
            if (dir == null) {
                LOGGER.info("skipping null directory");
                return;
            }
            if (!dir.isDirectory()) {
                LOGGER.info(LOG_FLUSHER, "{} (not a dir)", (Object)dir);
                return;
            }
            File[] list = Objects.requireNonNull(dir.listFiles(), "dir listing: " + dir.getAbsolutePath());
            if (currentLevel == 0) {
                LOGGER.info(LOG_FLUSHER, "{}", (Object)dir);
            } else if (list.length == 0) {
                LOGGER.info(LOG_FLUSHER, "{}\u2514 [empty]", (Object)buffer);
            }
            for (int i = 0; i < list.length; ++i) {
                boolean currentlyLatestLevel;
                File file = list[i];
                StringBuilder name = new StringBuilder(file.getName());
                File[] subList = null;
                boolean skipDir = false;
                long length = 0L;
                if (file.isDirectory()) {
                    subList = file.listFiles();
                    for (String skipFolder : CrashManager.this.skipFolders) {
                        if (!file.getName().equalsIgnoreCase(skipFolder)) continue;
                        skipDir = true;
                        name.append(" [skipped]");
                        break;
                    }
                    if (!(skipDir || subList != null && subList.length != 0)) {
                        name.append(" [empty dir]");
                        skipDir = true;
                    }
                } else {
                    length = file.length();
                    if (length < 0L) {
                        name.append(" [unknown size]");
                    } else if (length == 0L) {
                        name.append(" [empty file]");
                    } else {
                        name.append(" [").append(length < 2048L ? length + " B" : length / 1024L + " KiB").append("]");
                    }
                }
                boolean bl = currentlyLatestLevel = i == list.length - 1;
                if (currentlyLatestLevel) {
                    LOGGER.info(LOG_FLUSHER, "{}\u2514 {}", (Object)buffer, (Object)name);
                } else {
                    LOGGER.info(LOG_FLUSHER, "{}\u251c {}", (Object)buffer, (Object)name);
                }
                StringBuilder subLevelBuffer = new StringBuilder().append((CharSequence)buffer).append(currentlyLatestLevel ? "  " : "\u2502 ").append(' ');
                if (file.isFile() && file.getName().endsWith(".jar")) {
                    ZipFile zipFile;
                    try {
                        zipFile = new ZipFile(file, 1);
                    }
                    catch (IOException ioE) {
                        LOGGER.info(LOG_FLUSHER, "{}\u2514 [!!!] Corrupted zip: {}", (Object)subLevelBuffer, (Object)ioE.toString());
                        continue;
                    }
                    try {
                        if (length > 0L) {
                            String md5Message;
                            try {
                                md5Message = FileUtil.getMd5(file);
                            }
                            catch (IOException e) {
                                md5Message = e.toString();
                            }
                            LOGGER.debug(LOG_FLUSHER, "{}\u251c md5 = {}", (Object)subLevelBuffer, (Object)md5Message);
                        }
                        boolean mcmod = this.tryMcModInfo(zipFile, subLevelBuffer);
                        mcmod |= this.tryModsToml(zipFile, subLevelBuffer);
                        if (mcmod |= this.tryFabricMod(zipFile, subLevelBuffer)) continue;
                        LOGGER.debug(LOG_FLUSHER, "{}\u2514 [unknown mod format]", (Object)subLevelBuffer);
                        continue;
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)zipFile);
                    }
                }
                if (!file.isDirectory() || skipDir) continue;
                if (currentLevel == levelLimit) {
                    String str;
                    if (subList != null) {
                        StringBuilder s = new StringBuilder();
                        int files = 0;
                        int directories = 0;
                        for (File subFile : subList) {
                            if (subFile.isFile()) {
                                ++files;
                            }
                            if (!subFile.isDirectory()) continue;
                            ++directories;
                        }
                        s.append("[");
                        switch (files) {
                            case 0: {
                                s.append("no files");
                                break;
                            }
                            case 1: {
                                s.append("1 file");
                                break;
                            }
                            default: {
                                s.append(files).append(" files");
                            }
                        }
                        s.append("; ");
                        switch (directories) {
                            case 0: {
                                s.append("no dirs");
                                break;
                            }
                            case 1: {
                                s.append("1 dir");
                                break;
                            }
                            default: {
                                s.append(directories).append(" dirs");
                            }
                        }
                        s.append(']');
                        str = s.toString();
                    } else {
                        str = "[empty dir]";
                    }
                    LOGGER.info(LOG_FLUSHER, "{}\u2514 {}", (Object)subLevelBuffer, (Object)str);
                    continue;
                }
                this.treeDir(file, currentLevel + 1, levelLimit, subLevelBuffer);
            }
        }

        private boolean tryFabricMod(ZipFile zipFile, StringBuilder buffer) {
            JsonElement fabricModRoot;
            ZipEntry fabricModZipEntry = zipFile.getEntry("fabric.mod.json");
            if (fabricModZipEntry == null) {
                return false;
            }
            try (InputStreamReader reader = new InputStreamReader(zipFile.getInputStream(fabricModZipEntry), StandardCharsets.UTF_8);){
                fabricModRoot = Objects.requireNonNull(JsonParser.parseReader((Reader)reader), "fabricModRoot");
            }
            catch (IOException | RuntimeException e) {
                LOGGER.info(LOG_FLUSHER, "{}\u2514 [!!!] Couldn't read fabric.mod.json: {}", (Object)buffer, (Object)e.toString());
                return false;
            }
            if (!fabricModRoot.isJsonObject()) {
                LOGGER.info(LOG_FLUSHER, "{}\u251c [!!!] Not a JSON object: {}", (Object)buffer, (Object)fabricModRoot);
                return false;
            }
            JsonObject fabricModObj = fabricModRoot.getAsJsonObject();
            List<String> keys = Arrays.asList("id", "version", "depends");
            List keyPairs = keys.stream().map(key -> Pair.of((Object)key, (Object)fabricModObj.get(key))).filter(p -> p.getValue() != null).collect(Collectors.toList());
            this.displayKeyPairs(keyPairs, buffer);
            return true;
        }

        private boolean tryModsToml(ZipFile zipFile, StringBuilder buffer) {
            Object modsObj;
            ZipEntry modsTomlZipEntry = zipFile.getEntry("META-INF/mods.toml");
            if (modsTomlZipEntry == null) {
                return false;
            }
            Toml toml = new Toml();
            try (InputStreamReader reader = new InputStreamReader(zipFile.getInputStream(modsTomlZipEntry), StandardCharsets.UTF_8);){
                toml.read((Reader)reader);
            }
            catch (IOException | RuntimeException e) {
                LOGGER.info(LOG_FLUSHER, "{}\u2514 [!!!] Couldn't read mods.toml: {}", (Object)buffer, (Object)e.toString());
                return false;
            }
            Map map = toml.toMap();
            Object dependenciesObj = map.get("dependencies");
            if (map.containsKey("mods") && (modsObj = map.get("mods")) instanceof List) {
                List mods = (List)modsObj;
                for (Map mod : mods) {
                    this.displayModsTomlMod(mod, this.findModDependenciesToml(dependenciesObj, this.getModId(mod)), buffer);
                }
            }
            return true;
        }

        private String getModId(Map<String, Object> mod) {
            Object modIdObj = mod.get("modId");
            if (modIdObj instanceof String) {
                return (String)modIdObj;
            }
            return null;
        }

        private List<Map<String, Object>> findModDependenciesToml(Object dependenciesObj, String modId) {
            if (dependenciesObj == null || modId == null) {
                return null;
            }
            if (dependenciesObj instanceof Map) {
                Map dependencies = (Map)dependenciesObj;
                Object modDependencies = dependencies.get(modId);
                if (modDependencies instanceof List) {
                    return (List)modDependencies;
                }
            } else {
                LOGGER.warn("dependenciesObj is not a Map: {}", dependenciesObj);
            }
            return null;
        }

        private void displayModsTomlMod(Map<String, Object> mod, List<Map<String, Object>> dependencies, StringBuilder buffer) {
            List<String> keys = Arrays.asList("modId", "version", "displayURL");
            List keyPairs = keys.stream().map(key -> Pair.of((Object)key, mod.get(key))).filter(p -> p.getValue() != null).filter(p -> {
                Object v = p.getValue();
                if (!(v instanceof String)) {
                    return true;
                }
                String s = (String)v;
                return !s.startsWith("${");
            }).collect(Collectors.toList());
            if (keyPairs.isEmpty()) {
                LOGGER.info(LOG_FLUSHER, "{}\u2514 [no known toml keys]: {}", (Object)buffer, mod);
            } else {
                this.displayKeyPairs(keyPairs, buffer);
                if (dependencies != null && !dependencies.isEmpty()) {
                    List depKeyPairs = dependencies.stream().filter(d -> {
                        Object side = d.get("side");
                        return "BOTH".equals(side) || "CLIENT".equals(side);
                    }).filter(d -> d.get("mandatory") == Boolean.TRUE).filter(d -> d.containsKey("modId")).map(d -> Pair.of((Object)String.valueOf(d.get("modId")), (Object)d.getOrDefault("versionRange", "any"))).collect(Collectors.toList());
                    StringBuilder depBuffer = new StringBuilder(buffer).append("    ");
                    LOGGER.info(LOG_FLUSHER, "{}\u2514 [dependencies]", (Object)buffer);
                    this.displayKeyPairs(depKeyPairs, depBuffer);
                }
            }
        }

        private boolean tryMcModInfo(ZipFile zipFile, StringBuilder buffer) {
            JsonElement modListElement;
            JsonElement mcmodRoot;
            ZipEntry mcmodZipEntry = zipFile.getEntry("mcmod.info");
            if (mcmodZipEntry == null) {
                return false;
            }
            try (InputStreamReader reader = new InputStreamReader(zipFile.getInputStream(mcmodZipEntry), StandardCharsets.UTF_8);){
                mcmodRoot = Objects.requireNonNull(JsonParser.parseReader((Reader)reader), "mcmodRoot");
            }
            catch (IOException | RuntimeException e) {
                LOGGER.info(LOG_FLUSHER, "{}\u251c [!!!] Couldn't read mcmod.info: {}", (Object)buffer, (Object)e.toString());
                return false;
            }
            if (mcmodRoot.isJsonArray()) {
                for (JsonElement mcmodEntry : mcmodRoot.getAsJsonArray()) {
                    if (mcmodEntry.isJsonObject()) {
                        this.displayMcModInfo(mcmodEntry.getAsJsonObject(), buffer);
                        continue;
                    }
                    LOGGER.info(LOG_FLUSHER, "{}\u251c [!!!] Not a JSON object: {}", (Object)buffer, (Object)mcmodRoot);
                }
                return true;
            }
            if (mcmodRoot.isJsonObject() && (modListElement = mcmodRoot.getAsJsonObject().get("modList")) != null && modListElement.isJsonArray()) {
                for (JsonElement modListEntry : modListElement.getAsJsonArray()) {
                    if (modListEntry.isJsonObject()) {
                        this.displayMcModInfo(modListEntry.getAsJsonObject(), buffer);
                        continue;
                    }
                    LOGGER.info(LOG_FLUSHER, "{}\u251c [!!!] Not a JSON object: {}", (Object)buffer, (Object)modListEntry);
                }
                return true;
            }
            LOGGER.info(LOG_FLUSHER, "{}\u251c [!!!] Unknown or invalid mcmod.info: {}", (Object)buffer, (Object)mcmodRoot);
            return false;
        }

        private void displayMcModInfo(JsonObject mcmod, StringBuilder buffer) {
            List<String> keys = Arrays.asList("modid", "version", "mcversion", "url", "requiredMods", "dependencies");
            List keyPairs = keys.stream().map(key -> Pair.of((Object)key, (Object)mcmod.get(key))).filter(p -> p.getValue() != null).filter(p -> {
                JsonElement v = (JsonElement)p.getValue();
                if (!v.isJsonPrimitive()) {
                    return true;
                }
                JsonPrimitive pv = v.getAsJsonPrimitive();
                if (!pv.isString()) {
                    return true;
                }
                String s = pv.getAsString();
                return !s.startsWith("@") || !s.endsWith("@");
            }).collect(Collectors.toList());
            if (keyPairs.isEmpty()) {
                LOGGER.info(LOG_FLUSHER, "{}\u2514 [no known mcmod keys]: {}", (Object)buffer, (Object)mcmod);
            } else {
                this.displayKeyPairs(keyPairs, buffer);
            }
        }

        private void displayKeyPairs(List<? extends Pair<String, ?>> keyPairs, StringBuilder buffer) {
            if (keyPairs.isEmpty()) {
                return;
            }
            if (keyPairs.size() > 1) {
                LOGGER.info(LOG_FLUSHER, "{}\u251c {} = {}", (Object)buffer, keyPairs.get(0).getKey(), keyPairs.get(0).getValue());
                for (int i = 1; i < keyPairs.size() - 1; ++i) {
                    Pair<String, ?> pair = keyPairs.get(i);
                    LOGGER.info(LOG_FLUSHER, "{}\u251c {} = {}", (Object)buffer, pair.getKey(), pair.getValue());
                }
            }
            int lastIndex = keyPairs.size() - 1;
            LOGGER.info(LOG_FLUSHER, "{}\u2514 {} = {}", (Object)buffer, keyPairs.get(lastIndex).getKey(), keyPairs.get(lastIndex).getValue());
        }
    }

    private class Executor
    extends ExtendedThread {
        private Exception error;

        Executor() {
            this.startAndWait();
        }

        private void scan() throws CrashManagerInterrupted, CrashEntryException {
            if (CrashManager.this.processLogger == null) {
                LOGGER.warn("Process logger not found. Assuming it is unknown crash");
                return;
            }
            Object timer = Time.start(new Object());
            CrashManager.this.setupActions();
            CrashManager.this.setupEntries();
            CrashManager.this.systemInfoReporter.queueReport();
            CrashEntry capableEntry = null;
            for (IEntry entry : CrashManager.this.crashEntries.values()) {
                if (CrashManager.this.cancelled) {
                    throw new CrashManagerInterrupted();
                }
                if (capableEntry != null && capableEntry.isFake()) break;
                if (capableEntry == null && entry instanceof CrashEntry) {
                    boolean capable;
                    try {
                        capable = ((CrashEntry)entry).checkCapability();
                    }
                    catch (Exception e) {
                        throw new CrashEntryException(entry, (Throwable)e);
                    }
                    if (!capable) continue;
                    capableEntry = (CrashEntry)entry;
                    LOGGER.info("Found relevant: {}", (Object)capableEntry.getName());
                    CrashManager.this.crash.setEntry(capableEntry);
                    if (!capableEntry.isFake()) continue;
                    LOGGER.info("It is a \"fake\" crash, skipping remaining...");
                    continue;
                }
                if (!(entry instanceof Entry)) continue;
                if (capableEntry != null && !((Entry)entry).isCapable(capableEntry)) {
                    LOGGER.trace("Skipping: {}", (Object)entry.getName());
                    continue;
                }
                LOGGER.trace("Executing: {}", (Object)entry.getName());
                try {
                    ((Entry)entry).execute();
                }
                catch (Exception e) {
                    throw new CrashEntryException(entry, (Throwable)e);
                }
            }
            LOGGER.info("Done in {} ms", (Object)Time.stop(timer));
        }

        @Override
        public void run() {
            this.lockThread("start");
            try {
                this.scan();
            }
            catch (Exception e) {
                LOGGER.error("Error", (Throwable)e);
                this.error = e;
            }
        }
    }

    private static class ErroredMod {
        private final String name;
        private final String fileName;

        ErroredMod(String name, String fileName) {
            this.name = name;
            this.fileName = fileName;
        }

        ErroredMod(Matcher matcher) {
            this(matcher.group(2), matcher.group(3));
        }

        public String toString() {
            return this.name;
        }

        void append(StringBuilder b) {
            b.append(this.name).append(" (").append(this.fileName).append(")");
        }
    }

    private static class CrashEntryException
    extends Exception {
        CrashEntryException(IEntry entry, Throwable cause) {
            super(entry.toString(), cause);
        }
    }

    private static class CrashManagerInterrupted
    extends Exception {
        CrashManagerInterrupted() {
        }

        CrashManagerInterrupted(Throwable cause) {
            super(cause);
        }
    }
}

