/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft.crash;

import com.github.zafarkhaja.semver.Version;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.minecraft.crash.Button;
import ru.turikhay.tlauncher.minecraft.crash.CrashEntry;
import ru.turikhay.tlauncher.minecraft.crash.CrashManager;
import ru.turikhay.tlauncher.minecraft.crash.PatternEntry;
import ru.turikhay.util.OS;
import ru.turikhay.util.StringUtil;
import ru.turikhay.util.git.ITokenResolver;
import ru.turikhay.util.git.MapTokenResolver;
import ru.turikhay.util.git.TokenReplacingReader;
import ru.turikhay.util.json.LegacyVersionSerializer;

public final class CrashEntryList {
    private static final Logger LOGGER = LogManager.getLogger(CrashEntryList.class);
    private final List<CrashEntry> signatures = new ArrayList<CrashEntry>();
    private final List<CrashEntry> _signatures = Collections.unmodifiableList(this.signatures);
    private int revision;
    private Version required;
    private List<String> skipFolders = new ArrayList<String>();

    private CrashEntryList() {
    }

    public List<CrashEntry> getSignatures() {
        return this._signatures;
    }

    public int getRevision() {
        return this.revision;
    }

    public Version getRequired() {
        return this.required;
    }

    public List<String> getSkipFolders() {
        return this.skipFolders;
    }

    public static String getLoc(JsonElement elem, JsonDeserializationContext context, ITokenResolver resolver) {
        if (elem == null) {
            throw new NullPointerException();
        }
        if (elem.isJsonPrimitive()) {
            return TokenReplacingReader.resolveVars(elem.getAsString(), resolver);
        }
        JsonObject obj = elem.getAsJsonObject();
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        Map map = (Map)context.deserialize((JsonElement)obj, type);
        for (Map.Entry entry : map.entrySet()) {
            Objects.requireNonNull((String)entry.getKey());
            StringUtil.requireNotBlank((String)entry.getValue());
        }
        String locale = (TLauncher.getInstance() == null ? "en_US" : TLauncher.getInstance().getLang().getLocale()).toString();
        if (!map.containsKey(locale)) {
            locale = Configuration.isLikelyRussianSpeakingLocale(locale) && map.containsKey("ru_RU") ? "ru_RU" : "en_US";
        }
        return (String)map.get(locale);
    }

    public static class ListDeserializer
    implements JsonDeserializer<CrashEntryList> {
        private final LegacyVersionSerializer versionSerializer = new LegacyVersionSerializer();
        private final Map<String, String> vars;
        private final Map<String, Button> buttonMap;
        private final MapTokenResolver varsResolver;
        private final Button.Deserializer buttonDeserializer;
        private final CrashManager manager;

        ListDeserializer(CrashManager manager) {
            this.manager = Objects.requireNonNull(manager);
            this.vars = new LinkedHashMap<String, String>();
            this.vars.put("os", OS.CURRENT.toString());
            this.vars.put("arch", OS.Arch.CURRENT.name().toLowerCase(Locale.ROOT));
            this.vars.put("locale", TLauncher.getInstance() == null ? Locale.getDefault().toString() : TLauncher.getInstance().getSettings().getLocale().toString());
            this.varsResolver = new MapTokenResolver(this.vars);
            this.buttonMap = new HashMap<String, Button>();
            this.buttonDeserializer = new Button.Deserializer(manager, this.varsResolver);
        }

        Map<String, String> getVars() {
            return this.vars;
        }

        Map<String, Button> getButtons() {
            return this.buttonMap;
        }

        public String asString(JsonElement elem) {
            return TokenReplacingReader.resolveVars(elem.getAsString(), this.varsResolver);
        }

        public CrashEntryList deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject root = json.getAsJsonObject();
            Version required = this.versionSerializer.deserialize(root.get("required"), (Type)((Object)Version.class), context);
            if (TLauncher.getVersion().lessThan(required)) {
                throw new IncompatibleEntryList(required);
            }
            CrashEntryList entryList = new CrashEntryList();
            entryList.required = required;
            entryList.revision = root.get("revision").getAsInt();
            HashMap<String, String> loadedVars = new HashMap<String, String>();
            for (Map.Entry entry : root.get("variables").getAsJsonObject().entrySet()) {
                String value = CrashEntryList.getLoc((JsonElement)entry.getValue(), context, this.varsResolver);
                loadedVars.put((String)entry.getKey(), value);
                LOGGER.trace("Processing var {} = {}", entry.getKey(), (Object)value);
            }
            this.vars.putAll(loadedVars);
            ArrayList skipFolders = new ArrayList();
            if (root.has("skip-folders")) {
                JsonArray skippingFolders = root.get("skip-folders").getAsJsonArray();
                skippingFolders.forEach(elem -> skipFolders.add(elem.getAsString()));
            } else if (this.vars.containsKey("skip-folders")) {
                Collections.addAll(skipFolders, StringUtils.split((String)this.vars.get("skip-folders"), (char)';'));
            }
            entryList.skipFolders = skipFolders;
            JsonArray buttons = root.get("buttons").getAsJsonArray();
            for (int i = 0; i < buttons.size(); ++i) {
                Button button = this.buttonDeserializer.deserialize(buttons.get(i), (Type)((Object)Button.class), context, true);
                this.buttonMap.put(button.getName(), button);
            }
            EntryDeserializer entryDeserializer = new EntryDeserializer(this.buttonMap, this.buttonDeserializer);
            JsonArray signatures = root.get("signatures").getAsJsonArray();
            for (int i = 0; i < signatures.size(); ++i) {
                CrashEntry entry = entryDeserializer.deserialize(signatures.get(i), (Type)((Object)EntryDeserializer.class), context);
                entryList.signatures.add(entry);
            }
            LOGGER.trace("{} crash entries were parsed", (Object)entryList.signatures.size());
            entryList.signatures.sort((entry1, entry2) -> {
                boolean r2;
                boolean r1 = entry1.requiresSysInfo();
                if (r1 == (r2 = entry2.requiresSysInfo())) {
                    return 0;
                }
                return r1 ? 1 : -1;
            });
            return entryList;
        }

        static class IncompatibleEntryList
        extends JsonParseException {
            IncompatibleEntryList(Version required) {
                super("required: " + required);
            }
        }

        public class EntryDeserializer
        implements JsonDeserializer<CrashEntry> {
            private final Map<String, Button> buttonMap;
            private final Button.Deserializer buttonDeserializer;

            private EntryDeserializer(Map<String, Button> buttonMap, Button.Deserializer buttonDeserializer) {
                this.buttonMap = buttonMap;
                this.buttonDeserializer = buttonDeserializer;
            }

            public CrashEntry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject object = json.getAsJsonObject();
                String name = object.get("name").getAsString();
                CrashEntry entry = object.has("pattern") ? new PatternEntry(ListDeserializer.this.manager, name, Pattern.compile(ListDeserializer.this.asString(object.get("pattern")))) : new CrashEntry(ListDeserializer.this.manager, name);
                if (object.has("fake")) {
                    entry.setFake(object.get("fake").getAsBoolean());
                }
                if (object.has("permitHelp")) {
                    entry.setPermitHelp(object.get("permitHelp").getAsBoolean());
                }
                if (object.has("exitCode")) {
                    entry.setExitCode(object.get("exitCode").getAsInt());
                }
                if (object.has("version")) {
                    entry.setVersionPattern(Pattern.compile(ListDeserializer.this.asString(object.get("version"))));
                }
                if (object.has("jre")) {
                    entry.setJrePattern(Pattern.compile(ListDeserializer.this.asString(object.get("jre"))));
                }
                if (object.has("archIssue")) {
                    entry.setArchIssue(object.get("archIssue").getAsBoolean());
                }
                if (object.has("graphicsCard")) {
                    entry.setGraphicsCardPattern(Pattern.compile(ListDeserializer.this.asString(object.get("graphicsCard"))));
                }
                if (object.has("title")) {
                    entry.setTitle(CrashEntryList.getLoc(object.get("title"), context, ListDeserializer.this.varsResolver), new Object[0]);
                }
                if (object.has("loc")) {
                    entry.setLocalizable(object.get("loc").getAsBoolean());
                }
                if (object.has("body")) {
                    entry.setBody(CrashEntryList.getLoc(object.get("body"), context, ListDeserializer.this.varsResolver), new Object[0]);
                }
                if (object.has("image")) {
                    entry.setImage(ListDeserializer.this.asString(object.get("image")));
                }
                if (object.has("os")) {
                    entry.setOS((OS[])context.deserialize(object.get("os"), new TypeToken<OS[]>(){}.getType()));
                }
                if (object.has("buttons")) {
                    JsonArray buttons = object.getAsJsonArray("buttons");
                    for (int i = 0; i < buttons.size(); ++i) {
                        JsonElement elem = buttons.get(i);
                        Button button = elem.isJsonPrimitive() ? this.buttonMap.get(elem.getAsString()) : this.buttonDeserializer.deserialize(buttons.get(i), (Type)((Object)Button.class), context, false);
                        entry.addButton(button);
                    }
                }
                return entry;
            }
        }
    }
}

