/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft.crash;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.jna.JNA;
import ru.turikhay.tlauncher.minecraft.crash.Action;
import ru.turikhay.tlauncher.minecraft.crash.Button;
import ru.turikhay.tlauncher.minecraft.crash.CrashManager;
import ru.turikhay.tlauncher.minecraft.crash.IEntry;
import ru.turikhay.util.OS;
import ru.turikhay.util.sysinfo.GraphicsCard;
import ru.turikhay.util.sysinfo.SystemInfo;

public class CrashEntry
extends IEntry {
    private static final Logger LOGGER = LogManager.getLogger(CrashEntry.class);
    private boolean localizable = true;
    private boolean fake;
    private boolean permitHelp = true;
    private int exitCode;
    private final List<OS> osList = new ArrayList<OS>(Arrays.asList(OS.values()));
    private final List<OS> _osList = Collections.unmodifiableList(this.osList);
    private boolean archIssue;
    private Pattern graphicsCardPattern;
    private Pattern versionPattern;
    private Pattern jrePattern;
    private String imagePath;
    private String title;
    private Object[] titleVars;
    private String body;
    private Object[] bodyVars;
    private final List<Button> buttons = new ArrayList<Button>();
    private final List<Button> _buttons = Collections.unmodifiableList(this.buttons);

    public CrashEntry(CrashManager manager, String name) {
        super(manager, name);
        this.setPath(null, new Object[0]);
    }

    public final boolean isLocalizable() {
        return this.localizable;
    }

    protected final void setLocalizable(boolean localizable) {
        this.localizable = localizable;
    }

    public final boolean isFake() {
        return this.fake;
    }

    protected final void setFake(boolean fake) {
        this.fake = fake;
    }

    public final boolean isPermitHelp() {
        return this.permitHelp;
    }

    public void setPermitHelp(boolean permitHelp) {
        this.permitHelp = permitHelp;
    }

    public final int getExitCode() {
        return this.exitCode;
    }

    protected final void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public final boolean isCompatibleWith(OS os) {
        return this.osList.contains((Object)os);
    }

    protected void setOS(OS ... os) {
        this.osList.clear();
        Collections.addAll(this.osList, os);
    }

    public final boolean isArchIssue() {
        return this.archIssue;
    }

    protected final void setArchIssue(boolean archIssue) {
        this.archIssue = archIssue;
    }

    public final Pattern getGraphicsCardPattern() {
        return this.graphicsCardPattern;
    }

    protected final void setGraphicsCardPattern(Pattern graphicsCardPattern) {
        this.graphicsCardPattern = graphicsCardPattern;
    }

    public final Pattern getVersionPattern() {
        return this.versionPattern;
    }

    protected final void setVersionPattern(Pattern versionPattern) {
        this.versionPattern = versionPattern;
    }

    public final Pattern getJrePattern() {
        return this.jrePattern;
    }

    protected final void setJrePattern(Pattern jrePattern) {
        this.jrePattern = jrePattern;
    }

    public final String getImage() {
        return this.imagePath;
    }

    protected final void setImage(String imagePath) {
        this.imagePath = imagePath;
    }

    public final String getTitle() {
        return this.title;
    }

    protected final void setTitle(String title, Object ... vars) {
        this.title = title;
        this.titleVars = vars;
    }

    public final Object[] getTitleVars() {
        return this.titleVars;
    }

    public final String getBody() {
        return this.body;
    }

    protected final void setBody(String body, Object ... vars) {
        this.body = body;
        this.bodyVars = vars;
    }

    public final Object[] getBodyVars() {
        return this.bodyVars;
    }

    protected final void setPath(String path, Object ... vars) {
        String prefix = this.getLocPath(path);
        this.setTitle(prefix + ".title", vars);
        this.setBody(prefix + ".body", vars);
    }

    public final List<Button> getButtons() {
        return this._buttons;
    }

    protected final void addButton(Button button) {
        this.buttons.add(Objects.requireNonNull(button));
    }

    protected final void clearButtons() {
        this.buttons.clear();
    }

    protected Button newButton(String text, Action action, Object ... vars) {
        Button button = new Button(text);
        button.setLocalizable(true, false);
        button.setText(text, vars);
        button.getActions().add(action);
        this.addButton(button);
        return button;
    }

    protected boolean requiresSysInfo() {
        return this.isCompatibleWith(OS.WINDOWS) && (this.getGraphicsCardPattern() != null || this.isArchIssue());
    }

    protected boolean checkCapability() throws Exception {
        if (this.getVersionPattern() != null && !this.getVersionPattern().matcher(this.getManager().getVersion()).matches()) {
            LOGGER.debug("{} is not relevant because of Minecraft version", (Object)this.getName());
            return false;
        }
        if (this.getExitCode() != 0 && this.getExitCode() != this.getManager().getExitCode()) {
            LOGGER.debug("{} is not relevant because of exit code", (Object)this.getName());
            return false;
        }
        if (!this.isCompatibleWith(OS.CURRENT)) {
            LOGGER.debug("{} is not relevant because of OS", (Object)this.getName());
            return false;
        }
        if (this.getJrePattern() != null && !this.getJrePattern().matcher(System.getProperty("java.version")).matches()) {
            LOGGER.debug("{} is not relevant because of Java version", (Object)this.getName());
            return false;
        }
        if (this.getGraphicsCardPattern() != null) {
            SystemInfo systemInfo;
            LOGGER.debug("graphics card pattern of {}: {}", (Object)this.getName(), (Object)this.getGraphicsCardPattern());
            try {
                systemInfo = this.getManager().getSystemInfoReporter().getReport().get();
            }
            catch (Exception e) {
                LOGGER.debug("{} is not capable because system info report is unavailable", (Object)this.getName());
                return false;
            }
            List<GraphicsCard> graphicsCards = systemInfo.getGraphicsCards();
            if (graphicsCards == null || graphicsCards.isEmpty()) {
                LOGGER.debug("{} is not capable because graphics devices list is unavailable: {}", (Object)this.getName(), graphicsCards);
                return false;
            }
            for (GraphicsCard card : graphicsCards) {
                if (!this.getGraphicsCardPattern().matcher(card.getName()).matches()) continue;
                LOGGER.debug("{} is capable, found device: {}", (Object)this.getName(), (Object)card);
                return true;
            }
            return false;
        }
        if (this.isArchIssue()) {
            if (OS.Arch.x86.isCurrent()) {
                boolean is64Bit;
                Optional<Boolean> jnaIs64Bit = JNA.is64Bit();
                if (jnaIs64Bit.isPresent()) {
                    is64Bit = jnaIs64Bit.get();
                    LOGGER.info("JNA reported system is 64-bit: {}", (Object)is64Bit);
                } else {
                    try {
                        is64Bit = this.getManager().getSystemInfoReporter().getReport().get().is64Bit();
                        LOGGER.info("DxDiag reported system is 64-bit: {}", (Object)is64Bit);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Could not detect if system is 64-bit");
                        is64Bit = false;
                    }
                }
                if (OS.Arch.x86.isCurrent() && is64Bit) {
                    return true;
                }
                LOGGER.debug("{} is not capable because OS and Java arch are the same", (Object)this.getName());
            }
            return false;
        }
        return true;
    }

    String getLocPath(String path) {
        return path == null ? "crash." + this.getName() : "crash." + this.getName() + "." + path;
    }

    @Override
    public ToStringBuilder buildToString() {
        return super.buildToString().append("exitCode", this.exitCode).append("fake", this.fake).append("permitHelp", this.permitHelp).append("os", this.osList).append("archIssue", this.archIssue).append("version", (Object)this.versionPattern).append("jre", (Object)this.jrePattern).append("graphics", (Object)this.graphicsCardPattern).append("title", (Object)this.getTitle()).append("body", (Object)this.getBody()).append("buttons", this.getButtons());
    }
}

