/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft.crash;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import ru.turikhay.tlauncher.minecraft.crash.CrashEntry;
import ru.turikhay.tlauncher.minecraft.crash.CrashManager;

public final class Crash {
    private final CrashManager manager;
    private CrashEntry entry;
    private String description;
    private String javaDescription;
    private String stackTrace;
    private File crashFile;
    private File nativeCrashFile;
    private final Map<String, String> extraInfo = new HashMap<String, String>();

    Crash(CrashManager manager) {
        this.manager = manager;
    }

    public CrashManager getManager() {
        return this.manager;
    }

    public CrashEntry getEntry() {
        return this.entry;
    }

    void setEntry(CrashEntry entry) {
        this.entry = entry;
    }

    public String getDescription() {
        return this.description;
    }

    void setDescription(String description) {
        this.description = description;
    }

    public String getJavaDescription() {
        return this.javaDescription;
    }

    void setJavaDescription(String javaDescription) {
        this.javaDescription = javaDescription;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public File getCrashFile() {
        return this.crashFile;
    }

    void setCrashFile(String path) {
        this.crashFile = new File(path);
    }

    public File getNativeCrashFile() {
        return this.nativeCrashFile;
    }

    void setNativeCrashFile(String path) {
        this.nativeCrashFile = new File(path);
    }

    public Map<String, String> getExtraInfo() {
        return new HashMap<String, String>(this.extraInfo);
    }

    void addExtra(String key, String value) {
        this.extraInfo.put(key, value);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("entry", (Object)this.entry).append("description", (Object)this.description).append("javaDesc", (Object)this.javaDescription).append("crashFile", (Object)this.crashFile).append("nativeCrashFile", (Object)this.nativeCrashFile).append("extraInfo", this.extraInfo).build();
    }
}

