/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft.crash;

import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.minecraft.crash.CrashManager;
import ru.turikhay.tlauncher.minecraft.crash.PatternEntry;

public class BadMainClassEntry
extends PatternEntry {
    private static final Logger LOGGER = LogManager.getLogger(BadMainClassEntry.class);

    public BadMainClassEntry(CrashManager manager) {
        super(manager, "bad-mainclass", Pattern.compile("^Error: Could not find or load main class (.+)$"));
        this.setExitCode(1);
    }

    @Override
    protected boolean checkCapability() throws Exception {
        String jvmArgs;
        if (!super.checkCapability()) {
            return false;
        }
        String requestedMainClass = this.getMatch().group(1);
        LOGGER.info("Found bad main class: {}", (Object)requestedMainClass);
        if (this.getManager().getLauncher() != null && (jvmArgs = this.getManager().getLauncher().getConfiguration().get("minecraft.javaargs")) != null) {
            if (jvmArgs.contains(requestedMainClass)) {
                this.setPath("check-javaargs", new Object[0]);
                this.newButton("clear-javaargs", () -> this.getManager().getLauncher().getConfiguration().set("minecraft.javaargs", null), new Object[0]);
            }
            this.addButton(this.getManager().getButton("open-settings"));
            return true;
        }
        return true;
    }
}

