/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft.auth;

import java.io.IOException;
import java.util.Objects;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.minecraft.auth.Authenticator;
import ru.turikhay.tlauncher.user.Auth;
import ru.turikhay.tlauncher.user.AuthException;
import ru.turikhay.tlauncher.user.User;

public class ValidateAuthenticator<U extends User>
extends Authenticator<U> {
    private final Account<U> account;
    private final Auth<U> auth;

    ValidateAuthenticator(Account<U> account, Auth<U> auth) {
        this.account = Objects.requireNonNull(account, "account");
        this.auth = Objects.requireNonNull(auth, "auth");
    }

    @Override
    public final Account<U> getAccount() {
        return this.account;
    }

    @Override
    public Account.AccountType getType() {
        return this.account.getType();
    }

    @Override
    protected void pass() throws AuthException, IOException {
        this.auth.validate(this.account.getUser());
    }
}

