/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft.auth;

import java.io.IOException;
import ru.turikhay.tlauncher.managers.AccountManager;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.minecraft.auth.AuthExecutor;
import ru.turikhay.tlauncher.minecraft.auth.AuthenticatorListener;
import ru.turikhay.tlauncher.minecraft.auth.ExecAuthenticator;
import ru.turikhay.tlauncher.minecraft.auth.ValidateAuthenticator;
import ru.turikhay.tlauncher.user.AuthException;
import ru.turikhay.tlauncher.user.User;
import ru.turikhay.util.async.AsyncThread;

public abstract class Authenticator<U extends User> {
    private Exception e;

    public abstract Account<U> getAccount();

    public abstract Account.AccountType getType();

    public boolean pass(AuthenticatorListener<? super U> l) {
        if (l != null) {
            l.onAuthPassing(this);
        }
        try {
            this.pass();
        }
        catch (Exception var3) {
            this.e = var3;
            if (l != null) {
                l.onAuthPassingError(this, var3);
            }
            return false;
        }
        if (l != null) {
            l.onAuthPassed(this);
        }
        return true;
    }

    public Exception getException() {
        return this.e;
    }

    public void asyncPass(AuthenticatorListener<U> l) {
        AsyncThread.execute(() -> this.pass(l));
    }

    protected abstract void pass() throws AuthException, IOException;

    public static <U extends User> ValidateAuthenticator<U> instanceFor(Account<U> account) {
        return new ValidateAuthenticator<U>(account, AccountManager.getAuthFor(account.getUser()));
    }

    public static <U extends User> ExecAuthenticator<U> instanceFor(AuthExecutor<U> executor, Account.AccountType type) {
        return new ExecAuthenticator<U>(executor, type);
    }
}

