/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft.auth;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.mojang.authlib.properties.PropertyMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.managers.AccountManager;
import ru.turikhay.tlauncher.minecraft.auth.LegacyAccount;
import ru.turikhay.tlauncher.minecraft.auth.UUIDTypeAdapter;
import ru.turikhay.tlauncher.user.ElyLegacyUser;
import ru.turikhay.tlauncher.user.MojangUser;
import ru.turikhay.tlauncher.user.User;

public class AccountMigrator {
    private static final Logger LOGGER = LogManager.getLogger(AccountMigrator.class);
    private final String clientToken;
    private final Gson gson;

    public AccountMigrator(String clientToken) {
        this.clientToken = StringUtils.isBlank((CharSequence)clientToken) ? String.valueOf(UUID.randomUUID()) : clientToken;
        this.gson = new GsonBuilder().registerTypeAdapter(PropertyMap.class, (Object)new PropertyMap.Serializer()).registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).registerTypeAdapter(MojangUser.class, MojangUser.getJsonizer()).create();
    }

    public Map<String, LegacyAccount> parse(JsonObject object) {
        Map map = (Map)this.gson.fromJson((JsonElement)object, new TypeToken<Map<String, LegacyAccount>>(){}.getType());
        String output = this.gson.toJson((Object)map);
        return map;
    }

    public List<User> migrate(Collection<LegacyAccount> unmigratedList) {
        ArrayList<User> migrated = new ArrayList<User>();
        for (LegacyAccount account : unmigratedList) {
            User user;
            block14: {
                if (account.type == null) {
                    account.type = "free";
                }
                try {
                    switch (account.type) {
                        case "free": {
                            user = AccountManager.getPlainAuth().authorize(account.username);
                            break block14;
                        }
                        case "mojang": {
                            account.clientToken = this.clientToken;
                            user = (User)this.gson.fromJson(this.gson.toJson((Object)account), MojangUser.class);
                            break block14;
                        }
                        case "ely": {
                            UUID uuid = UUIDTypeAdapter.fromString(account.uuid);
                            user = new ElyLegacyUser(account.username, uuid, account.displayName, this.clientToken, account.accessToken);
                            break block14;
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Could not migrate {}", (Object)account, (Object)e);
                }
                continue;
            }
            migrated.add(user);
        }
        return migrated;
    }
}

