/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft.auth;

import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import ru.turikhay.tlauncher.user.User;

public class Account<T extends User> {
    protected final T user;

    private Account() {
        this.user = null;
    }

    public Account(T user) {
        this.user = (User)Objects.requireNonNull(user, "user");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Account account = (Account)o;
        return this.user != null && ((User)this.user).equals(account.user);
    }

    public int hashCode() {
        return this.user != null ? ((User)this.user).hashCode() : super.hashCode();
    }

    public T getUser() {
        return this.user;
    }

    public String getUsername() {
        return ((User)this.user).getUsername();
    }

    public String getDisplayName() {
        return ((User)this.user).getDisplayName();
    }

    public AccountType getType() {
        AccountType type = AccountType.parse(((User)this.user).getType());
        if (type == null) {
            throw new IllegalArgumentException("No account type was found for value " + ((User)this.user).getType());
        }
        return type;
    }

    public boolean isFree() {
        return this.getType().equals((Object)AccountType.PLAIN);
    }

    public static Account<?> randomAccount() {
        return new Account();
    }

    public String toString() {
        return "Account{user=" + this.user + '}';
    }

    public static enum AccountType {
        ELY("logo-ely"),
        ELY_LEGACY("logo-ely"),
        MOJANG("logo-mojang"),
        MINECRAFT("logo-microsoft"),
        MCLEAKS("logo-mcleaks"),
        PLAIN(null);

        private final String icon;
        private static final Collection<AccountType> VALUES;

        private AccountType(String icon) {
            this.icon = icon;
        }

        public String getIcon() {
            return this.icon;
        }

        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }

        @Nullable
        public static AccountType parse(String name) {
            return VALUES.stream().filter(e -> e.name().equalsIgnoreCase(name)).findAny().orElse(null);
        }

        static {
            VALUES = Arrays.asList(AccountType.values());
        }
    }
}

