/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft;

import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class Server {
    public static final int DEFAULT_PORT = 25565;
    private String name;
    private String address;
    private int port;

    protected Server() {
    }

    public Server(String name, String address, int port) {
        this.setName(name);
        this.setAddress(address);
        this.setPort(port);
    }

    public final String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = Objects.requireNonNull(name, "name");
    }

    public final String getAddress() {
        return this.address;
    }

    protected void setAddress(String address) {
        this.address = address;
    }

    public final int getPort() {
        return this.port;
    }

    protected void setPort(int port) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("illegal port: " + port);
        }
        this.port = port;
    }

    protected void setPort(String port) {
        int parsedPort;
        try {
            parsedPort = Integer.parseInt(port);
        }
        catch (RuntimeException rE) {
            throw new RuntimeException("could not parse port: " + port, rE);
        }
        this.setPort(parsedPort);
    }

    public String getFullAddress() {
        return this.address + (this.port == 25565 ? "" : ":" + this.port);
    }

    protected void setFullAddress(String fullAddress) {
        if ((fullAddress = StringUtils.trim((String)fullAddress)).startsWith("[") && fullAddress.contains("]:")) {
            int port;
            String address;
            try {
                address = fullAddress.substring(0, fullAddress.indexOf(93));
                port = Integer.parseInt(fullAddress.substring(fullAddress.indexOf(93) + 2));
            }
            catch (RuntimeException rE) {
                throw new RuntimeException("could not parse ipv6 address: " + fullAddress, rE);
            }
            this.setAddress(address);
            this.setPort(port);
            return;
        }
        switch (StringUtils.countMatches((CharSequence)fullAddress, (char)':')) {
            case 0: {
                this.setAddress(fullAddress);
                this.setPort(25565);
                break;
            }
            case 1: {
                if (fullAddress.startsWith(":")) {
                    this.setAddress("");
                    this.setPort(fullAddress.substring(1));
                    break;
                }
                String[] split = StringUtils.split((String)fullAddress, (char)':');
                this.setAddress(split[0]);
                this.setPort(split[1]);
                break;
            }
            default: {
                this.setAddress('[' + fullAddress + ']');
                this.setPort(25565);
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Server)) {
            return false;
        }
        Server s = (Server)o;
        return this.getFullAddress().equalsIgnoreCase(s.getFullAddress());
    }

    public int hashCode() {
        return this.getFullAddress().toLowerCase(Locale.ROOT).hashCode();
    }

    public final String toString() {
        return this.toStringBuilder().build();
    }

    protected ToStringBuilder toStringBuilder() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", (Object)this.name).append("address", (Object)this.address).append("port", this.port);
    }
}

