/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import ru.turikhay.tlauncher.minecraft.PromotedServer;
import ru.turikhay.tlauncher.minecraft.auth.Account;

public class PromotedServerDeserializer
implements JsonDeserializer<PromotedServer> {
    public PromotedServer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        PromotedServer server = new PromotedServer();
        server.setName(this.requireString(object, "name"));
        server.setFullAddress(this.requireString(object, "address"));
        if (object.get("family").isJsonArray()) {
            server.getFamily().addAll((Collection)context.deserialize(object.get("family"), new TypeToken<List<String>>(){}.getType()));
        } else {
            server.getFamily().add(this.getString(object, "family"));
        }
        if (object.has("accounts")) {
            Set accountTypes = (Set)context.deserialize(object.get("accounts"), new TypeToken<Set<Account.AccountType>>(){}.getType());
            server.getAccountTypeSet().clear();
            server.getAccountTypeSet().addAll(accountTypes);
            if (!server.getAccountTypeSet().stream().allMatch(Objects::nonNull)) {
                throw new NullPointerException("Accounts has null value");
            }
        }
        return server;
    }

    private String requireString(JsonObject object, String key) {
        return Objects.requireNonNull(this.getString(object, key), key);
    }

    private String getString(JsonObject object, String key) {
        JsonElement value = Objects.requireNonNull(object, "object").get(key);
        if (value != null && value.isJsonPrimitive() && ((JsonPrimitive)value).isString()) {
            return value.getAsString();
        }
        return null;
    }
}

