/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.launcher.versions.Library;
import net.minecraft.launcher.versions.LibraryType;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.U;

public class ModList {
    private final String repositoryRoot;
    private final List<String> modRef;

    public ModList(File repositoryRoot, boolean absolutePrefix) {
        this.repositoryRoot = (absolutePrefix ? "absolute:" : "") + repositoryRoot.getAbsolutePath();
        this.modRef = new ArrayList<String>();
    }

    public void addMod(Library library) {
        if (library.getLibraryType() != LibraryType.MODIFICATION) {
            throw new IllegalArgumentException("not a mod: " + library);
        }
        this.modRef.add(library.getName());
    }

    public void save(File file) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), FileUtil.getCharset());){
            U.getGson().toJson((Object)this, (Appendable)writer);
        }
    }
}

