/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.managers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launcher.updater.LatestVersionSyncInfo;
import net.minecraft.launcher.updater.LocalVersionList;
import net.minecraft.launcher.updater.RawVersionList;
import net.minecraft.launcher.updater.RemoteVersionList;
import net.minecraft.launcher.updater.VersionDownloadable;
import net.minecraft.launcher.updater.VersionFilter;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.CurrentLaunchFeatureMatcher;
import net.minecraft.launcher.versions.ReleaseType;
import net.minecraft.launcher.versions.Version;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.component.ComponentDependence;
import ru.turikhay.tlauncher.component.InterruptibleComponent;
import ru.turikhay.tlauncher.managers.AssetsManager;
import ru.turikhay.tlauncher.managers.ComponentManager;
import ru.turikhay.tlauncher.managers.LibraryReplaceProcessor;
import ru.turikhay.tlauncher.managers.VersionLists;
import ru.turikhay.tlauncher.managers.VersionManagerListener;
import ru.turikhay.tlauncher.managers.VersionSyncInfoContainer;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.util.Time;
import ru.turikhay.util.U;
import ru.turikhay.util.async.AsyncObject;
import ru.turikhay.util.async.AsyncObjectContainer;
import ru.turikhay.util.async.AsyncObjectGotErrorException;
import ru.turikhay.util.async.AsyncThread;

@ComponentDependence(value={AssetsManager.class, VersionLists.class, LibraryReplaceProcessor.class})
public class VersionManager
extends InterruptibleComponent {
    private static final Logger LOGGER = LogManager.getLogger(VersionManager.class);
    private final LocalVersionList localList;
    private final RemoteVersionList[] remoteLists;
    private Map<ReleaseType, Version> latestVersions;
    private final List<VersionManagerListener> listeners;
    private final Object versionFlushLock;
    private final Object latestVersionsSync;
    private boolean hadRemote;

    public VersionManager(ComponentManager manager) throws Exception {
        super(manager);
        VersionLists list = manager.getComponent(VersionLists.class);
        this.localList = list.getLocal();
        this.remoteLists = list.getRemoteLists();
        this.latestVersions = new LinkedHashMap<ReleaseType, Version>();
        this.listeners = Collections.synchronizedList(new ArrayList());
        this.versionFlushLock = new Object();
        this.latestVersionsSync = new Object();
    }

    public void addListener(VersionManagerListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners.add(listener);
    }

    public LocalVersionList getLocalList() {
        return this.localList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ReleaseType, Version> getLatestVersions() {
        Object object = this.versionFlushLock;
        synchronized (object) {
            Object object2 = this.latestVersionsSync;
            synchronized (object2) {
                return Collections.unmodifiableMap(new HashMap<ReleaseType, Version>(this.latestVersions));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean refresh(int refreshID, boolean local) {
        List<VersionManagerListener> list;
        this.refreshList[refreshID] = true;
        this.hadRemote |= !(local |= !this.manager.getLauncher().getSettings().getBoolean("minecraft.versions.sub.remote"));
        if (local) {
            LOGGER.info("Refreshing versions locally...");
        } else {
            LOGGER.info("Refreshing versions remotely...");
            List<VersionManagerListener> list2 = this.listeners;
            synchronized (list2) {
                for (VersionManagerListener result : this.listeners) {
                    result.onVersionsRefreshing(this);
                }
            }
        }
        Object lock1 = new Object();
        Time.start(lock1);
        Map<AsyncObject<RawVersionList>, RawVersionList> result1 = null;
        Throwable e1 = null;
        try {
            result1 = this.refreshVersions(local);
        }
        catch (Throwable var12) {
            e1 = var12;
        }
        if (this.isCancelled(refreshID)) {
            LOGGER.info("Version refresh has been cancelled ({} ms)", (Object)Time.stop(lock1));
            return false;
        }
        if (e1 != null) {
            List<VersionManagerListener> var12 = this.listeners;
            synchronized (var12) {
                for (VersionManagerListener listener : this.listeners) {
                    listener.onVersionsRefreshingFailed(this);
                }
            }
            LOGGER.error("Cannot refresh versions ({} ms)", (Object)Time.stop(lock1), (Object)e1);
            return true;
        }
        if (!local) {
            Object var12 = this.latestVersionsSync;
            synchronized (var12) {
                this.latestVersions.clear();
            }
        }
        LinkedHashMap<ReleaseType, Version> latestVersions_ = new LinkedHashMap<ReleaseType, Version>();
        if (result1 != null) {
            list = this.versionFlushLock;
            synchronized (list) {
                Set<Map.Entry<AsyncObject<RawVersionList>, RawVersionList>> entrySet = result1.entrySet();
                for (Map.Entry<AsyncObject<RawVersionList>, RawVersionList> entry : entrySet) {
                    if (!this.checkConsistency(entrySet, entry)) continue;
                    AsyncRawVersionListObject object = (AsyncRawVersionListObject)entry.getKey();
                    RawVersionList list3 = entry.getValue();
                    object.getVersionList().refreshVersions(list3);
                    latestVersions_.putAll(object.getVersionList().getLatestVersions());
                }
            }
        }
        list = this.latestVersionsSync;
        synchronized (list) {
            this.latestVersions.putAll(latestVersions_);
            this.latestVersions = U.sortMap(this.latestVersions, ReleaseType.values());
        }
        LOGGER.info("Versions has been refreshed ({} ms)", (Object)Time.stop(lock1));
        this.refreshList[refreshID] = false;
        list = this.listeners;
        synchronized (list) {
            for (VersionManagerListener listener : this.listeners) {
                try {
                    listener.onVersionsRefreshed(this);
                }
                catch (Exception e) {
                    LOGGER.warn("Caught listener exception:", (Throwable)e);
                }
            }
            return true;
        }
    }

    private boolean checkConsistency(Set<Map.Entry<AsyncObject<RawVersionList>, RawVersionList>> set, Map.Entry<AsyncObject<RawVersionList>, RawVersionList> entry) {
        RawVersionList list = entry.getValue();
        if (list == null) {
            return false;
        }
        AsyncRawVersionListObject object = (AsyncRawVersionListObject)entry.getKey();
        if (object.getVersionList().getDependencies().isEmpty()) {
            return true;
        }
        for (Map.Entry<AsyncObject<RawVersionList>, RawVersionList> checkEntry : set) {
            if (checkEntry.getValue() == list && checkEntry.getKey() == object) continue;
            AsyncRawVersionListObject checkObject = (AsyncRawVersionListObject)checkEntry.getKey();
            if (!object.getVersionList().getDependencies().contains(checkObject.getVersionList()) || this.checkConsistency(set, checkEntry)) continue;
            LOGGER.warn("Version list {} depends on unavailable {}", (Object)object.getVersionList(), (Object)checkObject.getVersionList());
            return false;
        }
        return true;
    }

    @Override
    protected boolean refresh(int queueID) {
        return this.refresh(queueID, false);
    }

    public void startRefresh(boolean local) {
        this.refresh(this.nextID(), local);
    }

    @Override
    public synchronized void stopRefresh() {
        super.stopRefresh();
        this.startRefresh(true);
    }

    public void asyncRefresh(boolean local) {
        AsyncThread.execute(() -> {
            try {
                this.startRefresh(local);
            }
            catch (Exception var2) {
                LOGGER.error("Couldn't refresh versions", (Throwable)var2);
            }
        });
    }

    @Override
    public void asyncRefresh() {
        this.asyncRefresh(false);
    }

    private Map<AsyncObject<RawVersionList>, RawVersionList> refreshVersions(boolean local) throws IOException {
        this.localList.refreshVersions();
        if (local) {
            return null;
        }
        AsyncObjectContainer<RawVersionList> container = new AsyncObjectContainer<RawVersionList>();
        for (RemoteVersionList remoteList : this.remoteLists) {
            container.add(new AsyncRawVersionListObject(remoteList));
        }
        return container.execute();
    }

    public void updateVersionList() {
        if (!this.hadRemote) {
            this.asyncRefresh();
        } else {
            for (VersionManagerListener listener : this.listeners) {
                listener.onVersionsRefreshed(this);
            }
        }
    }

    public VersionSyncInfo getVersionSyncInfo(Version version) {
        if (version == null) {
            throw new NullPointerException();
        }
        return this.getVersionSyncInfo(version.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionSyncInfo getVersionSyncInfo(String name, List<String> inheritance) {
        Version var10;
        if (name == null) {
            throw new NullPointerException("Cannot get sync info of NULL!");
        }
        if (name.startsWith("latest-")) {
            String localVersion = name.substring(7);
            name = null;
            Object object = this.latestVersionsSync;
            synchronized (object) {
                for (Map.Entry entry : this.latestVersions.entrySet()) {
                    if (!((ReleaseType)((Object)entry.getKey())).toString().equals(localVersion)) continue;
                    name = ((Version)entry.getValue()).getID();
                    break;
                }
            }
            if (name == null) {
                return null;
            }
        }
        if ((var10 = this.localList.getVersion(name)) instanceof CompleteVersion && ((CompleteVersion)var10).getInheritsFrom() != null) {
            if (inheritance == null) {
                inheritance = new ArrayList<String>();
            }
            try {
                var10 = ((CompleteVersion)var10).resolve(this, false, inheritance);
            }
            catch (Exception var9) {
                LOGGER.warn("Can't resolve version {}", (Object)var10.getID(), (Object)var9);
                var10 = null;
            }
        }
        Version var11 = null;
        for (RemoteVersionList var12 : this.remoteLists) {
            Version currentVersion = var12.getVersion(name);
            if (currentVersion == null) continue;
            var11 = currentVersion;
            break;
        }
        return var10 == null && var11 == null ? null : new VersionSyncInfo(var10, var11);
    }

    public VersionSyncInfo getVersionSyncInfo(String name) {
        return this.getVersionSyncInfo(name, null);
    }

    public LatestVersionSyncInfo getLatestVersionSyncInfo(Version version) {
        if (version == null) {
            throw new NullPointerException("Cannot get latest sync info of NULL!");
        }
        VersionSyncInfo syncInfo = this.getVersionSyncInfo(version);
        return new LatestVersionSyncInfo(version.getReleaseType(), syncInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VersionSyncInfo> getVersions(VersionFilter filter, boolean includeLatest) {
        Object object = this.versionFlushLock;
        synchronized (object) {
            return this.getVersions0(filter, includeLatest);
        }
    }

    public List<VersionSyncInfo> getVersions(boolean includeLatest) {
        return this.getVersions(TLauncher.getInstance() == null ? null : TLauncher.getInstance().getSettings().getVersionFilter(), includeLatest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private List<VersionSyncInfo> getVersions0(VersionFilter filter, boolean includeLatest) {
        Version remoteList;
        RemoteVersionList[] remoteVersionListArray;
        if (filter == null) {
            filter = new VersionFilter();
        }
        ArrayList<VersionSyncInfo> plainResult = new ArrayList<VersionSyncInfo>();
        ArrayList<VersionSyncInfo> result = new ArrayList<VersionSyncInfo>();
        HashMap<String, VersionSyncInfo> lookup = new HashMap<String, VersionSyncInfo>();
        if (includeLatest) {
            remoteVersionListArray = this.latestVersionsSync;
            // MONITORENTER : this.latestVersionsSync
            for (Version version : this.latestVersions.values()) {
                LatestVersionSyncInfo syncInfo;
                remoteList = version;
                if (!filter.satisfies(remoteList) || (syncInfo = this.getLatestVersionSyncInfo(remoteList)) == null || result.contains(syncInfo)) continue;
                result.add(syncInfo);
            }
            // MONITOREXIT : remoteVersionListArray
        }
        for (Version value : this.localList.getVersions()) {
            VersionSyncInfo var15;
            remoteList = value;
            if (!filter.satisfies(remoteList) || (var15 = this.getVersionSyncInfo(remoteList)) == null) continue;
            lookup.put(remoteList.getID(), var15);
            plainResult.add(var15);
        }
        remoteVersionListArray = this.remoteLists;
        int n = remoteVersionListArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                plainResult.sort((a, b) -> {
                    Date aDate = a.getLatestVersion().getReleaseTime();
                    Date bDate = b.getLatestVersion().getReleaseTime();
                    if (aDate == null && bDate == null) {
                        return 0;
                    }
                    if (aDate == null) {
                        return 1;
                    }
                    if (bDate == null) {
                        return -1;
                    }
                    return bDate.compareTo(aDate);
                });
                result.addAll(plainResult);
                return result;
            }
            RemoteVersionList var13 = remoteVersionListArray[n2];
            for (Version version : var13.getVersions()) {
                VersionSyncInfo syncInfo1;
                if (lookup.containsKey(version.getID()) || !filter.satisfies(version) || (syncInfo1 = this.getVersionSyncInfo(version)) == null) continue;
                lookup.put(version.getID(), syncInfo1);
                plainResult.add(syncInfo1);
            }
            ++n2;
        }
    }

    public List<VersionSyncInfo> getInstalledVersions(VersionFilter filter) {
        if (filter == null) {
            new VersionFilter();
        }
        ArrayList<VersionSyncInfo> result = new ArrayList<VersionSyncInfo>();
        for (Version version : this.localList.getVersions()) {
            result.add(this.getVersionSyncInfo(version));
        }
        return result;
    }

    public List<VersionSyncInfo> getInstalledVersions() {
        return this.getInstalledVersions(TLauncher.getInstance() == null ? null : TLauncher.getInstance().getSettings().getVersionFilter());
    }

    public VersionSyncInfoContainer downloadVersion(VersionSyncInfo syncInfo, Account.AccountType type, boolean force) throws IOException {
        CurrentLaunchFeatureMatcher featureMatcher = new CurrentLaunchFeatureMatcher();
        VersionSyncInfoContainer container = new VersionSyncInfoContainer(syncInfo);
        CompleteVersion completeVersion = syncInfo.resolveCompleteVersion(this, force);
        if (type != null) {
            completeVersion = this.manager.getComponent(LibraryReplaceProcessor.class).process(completeVersion, type.toString());
        }
        File baseDirectory = this.localList.getBaseDirectory();
        try {
            container.addAll(syncInfo.getRequiredDownloadables(featureMatcher, baseDirectory, force, type == null ? Account.AccountType.PLAIN : type));
        }
        catch (IOException ioE) {
            LOGGER.warn("Could not fetch required downloads for {}", (Object)syncInfo.getID(), (Object)ioE);
        }
        LOGGER.debug("Required for version " + syncInfo.getID() + ':', container.getList());
        File destination = new File(baseDirectory, "versions/" + completeVersion.getID() + "/" + completeVersion.getID() + ".jar");
        if (!force && destination.isFile() && destination.length() > 0L) {
            return container;
        }
        VersionDownloadable jarDownloadable = new VersionDownloadable(completeVersion, destination, syncInfo.getRemote() != null ? syncInfo.getRemote().getSource() : null);
        LOGGER.debug("Jar for {}: {}", (Object)syncInfo.getID(), (Object)jarDownloadable);
        container.add(jarDownloadable);
        return container;
    }

    private static class AsyncRawVersionListObject
    extends AsyncObject<RawVersionList> {
        private final RemoteVersionList remoteList;

        AsyncRawVersionListObject(RemoteVersionList remoteList) {
            this.remoteList = remoteList;
        }

        RemoteVersionList getVersionList() {
            return this.remoteList;
        }

        @Override
        protected RawVersionList execute() throws AsyncObjectGotErrorException {
            try {
                return this.remoteList.getRawList();
            }
            catch (Exception var2) {
                LOGGER.error("Error refreshing {}", (Object)this.remoteList, (Object)var2);
                throw new AsyncObjectGotErrorException(this, (Throwable)var2);
            }
        }
    }
}

