/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.managers;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.freedesktop.dbus.connections.IDisconnectCallback;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.Properties;
import org.freedesktop.dbus.types.Variant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.turikhay.tlauncher.managers.GPUManager;
import ru.turikhay.tlauncher.minecraft.launcher.ProcessHook;
import ru.turikhay.tlauncher.minecraft.launcher.hooks.EnvHook;
import ru.turikhay.util.JavaVersion;
import ru.turikhay.util.Lazy;

public class SwitcherooControlGPUManager
implements GPUManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwitcherooControlGPUManager.class);
    private static final Pattern NAME_PATTERN = Pattern.compile(".*\\[([^]]+)]");
    private final Properties switcherooControlProperties;
    private final Lazy<List<GPUManager.GPU>> gpus;

    public SwitcherooControlGPUManager(DBusConnection system) throws DBusException {
        this.switcherooControlProperties = (Properties)system.getRemoteObject("net.hadess.SwitcherooControl", "/net/hadess/SwitcherooControl", Properties.class);
        this.gpus = Lazy.of(() -> {
            try {
                List gpus = (List)this.switcherooControlProperties.Get("net.hadess.SwitcherooControl", "GPUs");
                return gpus.stream().map(it -> {
                    String name = (String)((Variant)it.get("Name")).getValue();
                    GPUManager.Vendor vendor = GPUManager.Vendor.guessVendorByName(name);
                    boolean isDefault = (Boolean)((Variant)it.get("Default")).getValue();
                    List envList = (List)((Variant)it.get("Environment")).getValue();
                    final HashMap<String, String> env = new HashMap<String, String>();
                    for (int i = 0; i < envList.size() - 1; i += 2) {
                        String key = (String)envList.get(i);
                        String value = (String)envList.get(i + 1);
                        env.put(key, value);
                    }
                    LOGGER.info("Found GPU: {}, vendor: {}, isDefault: {}", new Object[]{name, vendor, isDefault});
                    return new GPUManager.GPU(name, vendor, isDefault){

                        @Override
                        public String getDisplayName(GPUManager gpuManager) {
                            String name = this.getName();
                            Matcher matcher = NAME_PATTERN.matcher(name);
                            if (matcher.matches()) {
                                return matcher.group(1);
                            }
                            return name;
                        }

                        @Override
                        public ProcessHook getHook(GPUManager gpuManager) {
                            return new EnvHook(env);
                        }
                    };
                }).collect(Collectors.toList());
            }
            catch (DBusExecutionException ignored) {
                LOGGER.warn("Switcheroo-Control is unavailable");
                return Collections.emptyList();
            }
        });
    }

    @Override
    @Nonnull
    public List<GPUManager.GPU> discoveryGPUs() {
        return this.gpus.get();
    }

    public String toString() {
        return "SwitcherooControlGPUManager";
    }

    protected static Optional<GPUManager> tryToCreate() {
        try {
            Callable<DBusConnection> systemFactory = () -> ((DBusConnectionBuilder)DBusConnectionBuilder.forSystemBus().withDisconnectCallback((IDisconnectCallback)new DBusDisconnectionLogger())).build();
            try {
                return Optional.of(new SwitcherooControlGPUManager(systemFactory.call()));
            }
            catch (Throwable t) {
                LOGGER.info("SwitcherooControlGPUManager is not available: {}", (Object)t.toString());
            }
        }
        catch (NoClassDefFoundError ignored) {
            LOGGER.info("SwitcherooControlGPUManager is not available because it requires org.freedesktop.dbus to be in the classpath");
        }
        return Optional.empty();
    }

    private static class DBusDisconnectionLogger
    implements IDisconnectCallback {
        private DBusDisconnectionLogger() {
        }

        public void disconnectOnError(IOException e) {
            LOGGER.error("DBus session terminated due to an error", (Throwable)e);
        }
    }

    public static class Loader {
        private static final Logger LOGGER = LoggerFactory.getLogger(Loader.class);

        public static Optional<GPUManager> tryToCreate() {
            if (JavaVersion.getCurrent().getMajor() >= 11) {
                return SwitcherooControlGPUManager.tryToCreate();
            }
            LOGGER.info("SwitcherooControlGPUManager is not available because it requires Java 11+");
            return Optional.empty();
        }
    }
}

