/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.managers;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.client.fluent.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.turikhay.util.EHttpClient;
import ru.turikhay.util.Lazy;
import ru.turikhay.util.U;
import ru.turikhay.util.async.AsyncThread;

public class PromotedStoreManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PromotedStoreManager.class);
    private final Lazy<CompletableFuture<Info>> info = Lazy.of(() -> {
        CompletableFuture<Info> info = AsyncThread.completableFuture(() -> (Info)U.getGson().fromJson(EHttpClient.toString(Request.Get((String)"https://api.llaun.ch/v1/promotedStore").addHeader("Accept", "application/json")), Info.class));
        AsyncThread.after(10L, TimeUnit.SECONDS, () -> info.completeExceptionally(new TimeoutException()));
        return info.whenComplete((r, t) -> {
            if (t != null) {
                LOGGER.info("Promoted store info is not available: {}", (Object)t.toString());
            } else {
                LOGGER.info("Promoted store info: {}", r);
            }
        });
    });

    public CompletableFuture<Info> requestOrGetInfo() {
        return this.info.get();
    }

    public Optional<Info> getInfoNow() {
        return this.info.valueIfInitialized().map(f -> {
            try {
                return f.getNow(null);
            }
            catch (RuntimeException ignored) {
                return null;
            }
        });
    }

    public static class Info {
        private String url;
        private String price;

        public Info() {
        }

        public Info(String url, String price) {
            this.url = url;
            this.price = price;
        }

        public String getUrl() {
            return this.url;
        }

        public String getPrice() {
            return this.price;
        }

        public String toString() {
            return "Info{url='" + this.url + '\'' + ", price='" + this.price + '\'' + '}';
        }
    }
}

