/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.managers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import io.sentry.Sentry;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.interfaces.ExceptionInterface;
import io.sentry.event.interfaces.SentryInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.launcher.versions.json.DateTypeAdapter;
import net.minecraft.launcher.versions.json.FileTypeAdapter;
import net.minecraft.launcher.versions.json.LowerCaseEnumTypeAdapterFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.component.RefreshableComponent;
import ru.turikhay.tlauncher.managers.AccountManager;
import ru.turikhay.tlauncher.managers.ComponentManager;
import ru.turikhay.tlauncher.managers.McleaksManager;
import ru.turikhay.tlauncher.managers.ProfileManagerListener;
import ru.turikhay.tlauncher.minecraft.auth.AccountMigrator;
import ru.turikhay.tlauncher.minecraft.auth.AuthenticatorDatabase;
import ru.turikhay.tlauncher.minecraft.auth.LegacyAccount;
import ru.turikhay.tlauncher.minecraft.auth.UUIDTypeAdapter;
import ru.turikhay.tlauncher.pasta.Pasta;
import ru.turikhay.tlauncher.pasta.PastaFormat;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.user.User;
import ru.turikhay.tlauncher.user.UserSet;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.MinecraftUtil;
import ru.turikhay.util.json.InstantAdapter;

public class ProfileManager
extends RefreshableComponent {
    private static final Logger LOGGER = LogManager.getLogger(ProfileManager.class);
    public static final String DEFAULT_PROFILE_FILENAME = "tlauncher_profiles.json";
    private final AccountManager accountManager;
    private final List<ProfileManagerListener> listeners;
    private final Gson gson;
    private File file;
    private final AuthenticatorDatabase authDatabase;

    public ProfileManager(ComponentManager manager, File file) {
        super(manager);
        Objects.requireNonNull(file);
        this.file = file;
        this.listeners = new CopyOnWriteArrayList<ProfileManagerListener>();
        this.accountManager = new AccountManager();
        this.authDatabase = new AuthenticatorDatabase(this.accountManager);
        this.accountManager.addListener((UserSet set) -> {
            for (ProfileManagerListener l : this.listeners) {
                try {
                    l.onProfilesRefreshed(this);
                }
                catch (Exception e) {
                    LOGGER.warn("Caught exception on one of profile manager listeners", (Throwable)e);
                }
            }
            try {
                this.saveProfiles();
            }
            catch (IOException var3) {
                LOGGER.warn("Could not save profiles", (Throwable)var3);
            }
        });
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapterFactory((TypeAdapterFactory)new LowerCaseEnumTypeAdapterFactory());
        builder.registerTypeAdapter(Date.class, (Object)new DateTypeAdapter(true));
        builder.registerTypeAdapter(Instant.class, (Object)new InstantAdapter());
        builder.registerTypeAdapter(File.class, (Object)new FileTypeAdapter());
        builder.registerTypeAdapter(UserSet.class, (Object)this.accountManager.getTypeAdapter());
        builder.registerTypeAdapter(UUIDTypeAdapter.class, (Object)new UUIDTypeAdapter());
        builder.setPrettyPrinting();
        this.gson = builder.create();
    }

    public ProfileManager(ComponentManager manager) {
        this(manager, ProfileManager.getDefaultFile(manager));
    }

    public void recreate() {
        this.setFile(ProfileManager.getDefaultFile(this.manager));
        this.refresh();
    }

    @Override
    public boolean refresh() {
        this.loadProfiles();
        for (ProfileManagerListener e : this.listeners) {
            e.onProfilesRefreshed(this);
        }
        try {
            this.saveProfiles();
            return true;
        }
        catch (IOException var3) {
            Alert.showError("Could not save profiles!", var3);
            return false;
        }
    }

    private void loadProfiles() {
        LOGGER.debug("Refreshing profiles from: {}", (Object)this.file);
        File oldFile = new File(this.file.getParentFile(), "launcher_profiles.json");
        if (!oldFile.isFile()) {
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(oldFile), StandardCharsets.UTF_8);){
                this.gson.toJson((Object)new OldProfileList(), (Appendable)writer);
            }
            catch (Exception var17) {
                LOGGER.warn("Cannot write into {}", (Object)oldFile, (Object)var17);
            }
        }
        JsonObject object = null;
        File readFile = this.file.isFile() ? this.file : oldFile;
        String saveBackup = null;
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(readFile), StandardCharsets.UTF_8);){
            object = (JsonObject)this.gson.fromJson((Reader)reader, JsonObject.class);
        }
        catch (Exception var15) {
            LOGGER.warn("Cannot read from {}", (Object)readFile, (Object)var15);
        }
        String outputJson = this.gson.toJson(object);
        RawProfileList raw = new RawProfileList();
        try {
            if (object != null) {
                if (object.has("authenticationDatabase") && object.has("clientToken")) {
                    raw.userSet = this.accountManager.getUserSet();
                    AccountMigrator migrator = new AccountMigrator(object.get("clientToken").getAsString());
                    Map<String, LegacyAccount> accountMap = migrator.parse(object.getAsJsonObject("authenticationDatabase"));
                    for (User user : migrator.migrate(accountMap.values())) {
                        raw.userSet.add(user);
                    }
                    saveBackup = "migrated";
                } else {
                    raw.userSet = (UserSet)this.gson.fromJson((JsonElement)object.getAsJsonObject("userSet"), UserSet.class);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error parsing profile list: {}", (Object)readFile, (Object)e);
            Sentry.capture((EventBuilder)new EventBuilder().withMessage("bad profile list").withSentryInterface((SentryInterface)new ExceptionInterface((Throwable)e)).withLevel(Event.Level.ERROR).withExtra("data", (Object)Pasta.paste(String.valueOf(object), PastaFormat.JSON)));
            saveBackup = "errored";
        }
        if (saveBackup != null) {
            File backupFile = new File(readFile.getAbsolutePath() + "." + saveBackup + ".bak");
            try {
                FileUtil.createFile(backupFile);
                try (FileOutputStream backupOut = new FileOutputStream(backupFile);){
                    IOUtils.write((String)outputJson, (OutputStream)backupOut, (Charset)FileUtil.getCharset());
                }
            }
            catch (Exception e) {
                LOGGER.error("Could not save backup into {}", (Object)backupFile, (Object)e);
                Alert.showError("Could not save profile backup. Accounts will be lost :(", e);
            }
        }
        if (raw.userSet != null) {
            for (User user : raw.userSet.getSet()) {
                if (!user.getType().equals("mcleaks")) continue;
                McleaksManager.triggerConnection();
            }
        }
        this.accountManager.setUserSet(raw.userSet);
    }

    public void saveProfiles() throws IOException {
        RawProfileList raw = new RawProfileList();
        raw.userSet = this.accountManager.getUserSet();
        File tmpFile = new File(this.file.getAbsolutePath() + ".tmp");
        FileUtil.createFile(tmpFile);
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(tmpFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            this.gson.toJson((Object)raw, (Appendable)writer);
        }
        Files.move(tmpFile.toPath(), this.file.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public AccountManager getAccountManager() {
        return this.accountManager;
    }

    public AuthenticatorDatabase getAuthDatabase() {
        return this.authDatabase;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
        for (ProfileManagerListener listener : this.listeners) {
            listener.onProfileManagerChanged(this);
        }
    }

    public void addListener(ProfileManagerListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    private static File getDefaultFile(ComponentManager manager) {
        String profileFile = manager.getLauncher().getSettings().get("profiles");
        return StringUtils.isNotEmpty((CharSequence)profileFile) ? new File(profileFile) : new File(MinecraftUtil.getWorkingDirectory(), DEFAULT_PROFILE_FILENAME);
    }

    static class OldProfileList {
        UUID clientToken = UUID.randomUUID();
        Map<Object, Object> profiles = new HashMap<Object, Object>();

        OldProfileList() {
        }
    }

    static class RawProfileList {
        UserSet userSet;

        RawProfileList() {
        }
    }
}

