/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.managers;

import java.nio.file.Path;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import net.minecraft.launcher.versions.Version;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.managers.BaseVersionTable;
import ru.turikhay.util.Lazy;
import ru.turikhay.util.OS;
import ru.turikhay.util.async.AsyncThread;

public class MemoryAllocationService {
    private static final Logger LOGGER = LogManager.getLogger(MemoryAllocationService.class);
    static final int DEFAULT_BASE_REQUIREMENT = 2048;
    private final OsInfo os;
    private final MemoryInfo mem;
    private final Lazy<Range> range = Lazy.of(this::doQueryRange);
    private final Lazy<Hint> fallbackHint = Lazy.of(() -> new Hint(this.doQueryDefaultXmx(), 2048, false));

    MemoryAllocationService(OsInfo os, MemoryInfo context) {
        this.os = os;
        this.mem = context;
    }

    public MemoryAllocationService() {
        this(new OsInfo(OS.CURRENT, OS.Arch.CURRENT), new MemoryInfo((int)Math.min(OS.Arch.TOTAL_RAM_MB, Integer.MAX_VALUE)));
    }

    public MemoryInfo getMemoryInfo() {
        return this.mem;
    }

    public Range getRange() {
        return this.range.get();
    }

    public Future<Hint> queryHint(VersionContext versionContext) {
        return AsyncThread.future(() -> this.doQueryHint(versionContext));
    }

    public Hint getFallbackHint() {
        return this.fallbackHint.get();
    }

    private int doQueryDefaultXmx() {
        if (this.os.isArch(OS.Arch.x86) || this.mem.total <= 2000) {
            return Math.min(1024, this.mem.total);
        }
        if (this.mem.total <= 2500) {
            return 1536;
        }
        return 2048;
    }

    private Range doQueryRange() {
        if (this.os.isArch(OS.Arch.x86) || this.mem.total <= 1200) {
            return new Range(Math.min(512, this.mem.total), Math.min(1024, this.mem.total));
        }
        return new Range(Math.min(1024, this.mem.total), this.mem.total);
    }

    private Hint doQueryHint(VersionContext versionCtx) {
        int baseRequirement;
        BaseVersionTable table = BaseVersionTable.getInstance();
        BaseVersionTable.BaseVersion base = table.findBaseVersion(versionCtx);
        if (base == null) {
            base = table.getDefaultBaseVersion();
            LOGGER.warn("No base version found for {}, will use fallback: {}", (Object)versionCtx.id, (Object)base.family);
        }
        int xmx = baseRequirement = base.requirement.apply(new QueryContext(this.os, this.mem, versionCtx)).intValue();
        if (this.mem.total >= 6000 && versionCtx.isForge()) {
            xmx = Math.min(this.mem.safeMax, xmx * 2);
            LOGGER.debug("Detected Forge version: bumping x 2: {} -> {} MiB", (Object)baseRequirement, (Object)xmx);
        }
        int actual = Math.min(this.mem.safeMax, xmx);
        if (!this.os.is64Bit()) {
            actual = Math.min(1024, actual);
        }
        return new Hint(actual, xmx, true);
    }

    public String toString() {
        return "MemoryAllocationService{os=" + this.os + ", mem=" + this.mem + ", range=" + this.range + ", fallbackHint=" + this.fallbackHint + '}';
    }

    private static int roundToClosestBase(Number value, int base) {
        return (int)(Math.round(value.doubleValue() / (double)base) * (long)base);
    }

    private static int computeClosestBase(Number value) {
        if (value.intValue() < 4779) {
            return 256;
        }
        return 1024;
    }

    public static class OsInfo {
        final OS os;
        final OS.Arch arch;

        public OsInfo(OS os, OS.Arch arch) {
            this.os = os;
            this.arch = arch;
        }

        public boolean isOs(OS os) {
            return this.os == os;
        }

        public boolean isArch(OS.Arch arch) {
            return this.arch == arch;
        }

        public boolean isArm() {
            return this.arch.isARM();
        }

        public boolean is64Bit() {
            return this.arch.is64Bit();
        }

        public String toString() {
            return "OsInfo{os=" + (Object)((Object)this.os) + ", arch=" + (Object)((Object)this.arch) + '}';
        }
    }

    public static class MemoryInfo {
        final int total;
        final int base;
        final int safeMax;

        MemoryInfo(int total) {
            this.total = total;
            this.base = MemoryAllocationService.computeClosestBase(total);
            this.safeMax = Math.max(Math.min(total, 1024), MemoryAllocationService.roundToClosestBase((double)total * (total < 2048 ? 0.5 : 0.75), this.base));
        }

        public int getTotal() {
            return this.total;
        }

        public int getBase() {
            return this.base;
        }

        public int getSafeMax() {
            return this.safeMax;
        }

        public String toString() {
            return "MemoryInfo{total=" + this.total + ", base=" + this.base + ", safeMax=" + this.safeMax + '}';
        }
    }

    public static class Range {
        private final int min;
        private final int max;

        public Range(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public String toString() {
            return "Range{min=" + this.min + ", max=" + this.max + '}';
        }
    }

    public static class VersionContext {
        private final String id;
        private final Date releaseTime;
        @Nullable
        private final Path gameDir;

        public VersionContext(String id, Date releaseTime, @Nullable Path gameDir) {
            this.id = id;
            this.releaseTime = releaseTime;
            this.gameDir = gameDir;
        }

        public VersionContext(Version version, @Nullable Path gameDir) {
            this(version.getID(), version.getReleaseTime(), gameDir);
        }

        public String getId() {
            return this.id;
        }

        public Date getReleaseTime() {
            return this.releaseTime;
        }

        public boolean isForge() {
            return this.id.toLowerCase(Locale.ROOT).contains("forge");
        }

        public String toString() {
            return "VersionContext{id='" + this.id + '\'' + ", releaseTime=" + this.releaseTime + ", gameDir=" + this.gameDir + '}';
        }
    }

    public static class Hint {
        private final int actual;
        private final int desired;
        private final boolean confident;

        public Hint(int actual, int desired, boolean confident) {
            this.actual = actual;
            this.desired = desired;
            this.confident = confident;
        }

        public int getActual() {
            return this.actual;
        }

        public int getDesired() {
            return this.desired;
        }

        public boolean isConfident() {
            return this.confident;
        }

        public boolean isUnderAllocation() {
            return this.actual < this.desired;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Hint hint = (Hint)o;
            return this.actual == hint.actual && this.desired == hint.desired && this.confident == hint.confident;
        }

        public int hashCode() {
            return Objects.hash(this.actual, this.desired, this.confident);
        }

        public String toString() {
            return "Hint{actual=" + this.actual + ", desired=" + this.desired + ", confident=" + this.confident + '}';
        }
    }

    static class QueryContext {
        final OsInfo os;
        final MemoryInfo mem;
        final VersionContext versionCtx;

        QueryContext(OsInfo os, MemoryInfo mem, VersionContext versionCtx) {
            this.os = os;
            this.mem = mem;
            this.versionCtx = versionCtx;
        }
    }
}

