/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.managers;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import ru.turikhay.tlauncher.managers.McleaksStatus;
import ru.turikhay.util.async.ExtendedThread;

class McleaksStatusThread
extends ExtendedThread {
    private final McleaksStatus parent;

    McleaksStatusThread(McleaksStatus status) {
        this.parent = status;
    }

    @Override
    public void run() {
        this.checkCurrent();
        try {
            this.receivePayload();
        }
        catch (Exception e) {
            this.parent.receiveNothing();
        }
    }

    private void receivePayload() throws IOException {
        Gson gson = new Gson();
        URL url = new URL("https://api.mcleaks.net/");
        String response = IOUtils.toString((InputStream)url.openStream(), (Charset)StandardCharsets.UTF_8);
        Payload payload = (Payload)gson.fromJson(response, Payload.class);
        if (payload == null || payload.serverip == null) {
            throw new IOException("cannot parse response: " + response);
        }
        this.parent.receiveStatus(payload);
    }

    static class Payload {
        String serverip;
        String altdispenserip;
        String updateurl;
        String version;
        String osxVersion;
        String macosVersion;
        String linuxVersion;

        Payload() {
        }
    }
}

