/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.managers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import ru.turikhay.tlauncher.managers.McleaksManager;
import ru.turikhay.tlauncher.managers.McleaksStatusListener;
import ru.turikhay.tlauncher.managers.McleaksStatusThread;

public class McleaksStatus {
    private final List<McleaksStatusListener> listeners = Collections.synchronizedList(new ArrayList());
    private final McleaksStatusThread thread;
    private final AtomicBoolean started = new AtomicBoolean();
    private String serverIp;

    McleaksStatus() {
        this.thread = new McleaksStatusThread(this);
    }

    public void addListener(McleaksStatusListener listener) {
        this.listeners.add(listener);
        if (this.hasStatus()) {
            listener.onMcleaksUpdated(this);
        } else {
            listener.onMcleaksUpdating(this);
        }
    }

    public boolean hasStatus() {
        return this.started.get() && !this.thread.isAlive();
    }

    public String getServerIp(long millis) throws TimeoutException, InterruptedException {
        this.waitForResponse(millis);
        return this.serverIp;
    }

    public String getServerIp() {
        return this.serverIp;
    }

    void triggerFetch() {
        if (!this.started.getAndSet(true)) {
            this.thread.start();
        }
    }

    public void waitForResponse(long millis) throws InterruptedException, TimeoutException {
        this.triggerFetch();
        if (this.thread.isAlive()) {
            this.thread.join(millis);
            if (this.thread.isAlive()) {
                throw new TimeoutException();
            }
        }
    }

    void receiveStatus(McleaksStatusThread.Payload payload) {
        this.serverIp = payload.serverip;
        McleaksManager.getConnector().receiveServerIp(this.serverIp);
        for (McleaksStatusListener listener : this.listeners) {
            listener.onMcleaksUpdated(this);
        }
    }

    void receiveNothing() {
        for (McleaksStatusListener listener : this.listeners) {
            listener.onMcleaksUpdated(this);
        }
    }
}

