/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.managers;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.HttpsURLConnection;
import ru.turikhay.app.nstweaker.IsolatedTweakedConnector;
import ru.turikhay.app.nstweaker.TweakHostname;
import ru.turikhay.app.nstweaker.TweakHostnameService;
import ru.turikhay.util.StringUtil;

public class McleaksConnector {
    private static final String[] HOSTS = new String[]{"authserver.mojang.com", "sessionserver.mojang.com"};
    private List<TweakHostname> hostnameList;
    private IsolatedTweakedConnector connector;

    McleaksConnector() {
    }

    public List<TweakHostname> getList() {
        return this.hostnameList;
    }

    public HttpsURLConnection setupHttpsConnection(URL url) throws IOException {
        Objects.requireNonNull(url, "url");
        if (this.connector == null) {
            throw new IllegalStateException("connector is not available");
        }
        return this.connector.setupHttpsConnection(url);
    }

    void receiveServerIp(String ip) {
        StringUtil.requireNotBlank(ip, "ip");
        this.hostnameList = McleaksConnector.createHostnameList(ip);
        this.connector = McleaksConnector.createIsolatedConnector(this.hostnameList);
    }

    private static List<TweakHostname> createHostnameList(String ip) {
        ArrayList<TweakHostname> hostnameList = new ArrayList<TweakHostname>();
        for (String host : HOSTS) {
            hostnameList.add(TweakHostname.ipv4((String)ip, (String)host));
        }
        return hostnameList;
    }

    private static IsolatedTweakedConnector createIsolatedConnector(List<TweakHostname> list) {
        return new IsolatedTweakedConnector(new TweakHostnameService(list));
    }
}

