/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.managers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.Library;
import net.minecraft.launcher.versions.LibraryReplace;
import net.minecraft.launcher.versions.Version;
import net.minecraft.launcher.versions.json.LowerCaseEnumTypeAdapterFactory;
import net.minecraft.launcher.versions.json.PatternTypeAdapter;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Unbox;
import ru.turikhay.tlauncher.component.InterruptibleComponent;
import ru.turikhay.tlauncher.managers.ComponentManager;
import ru.turikhay.tlauncher.managers.LibraryReplaceProcessorListener;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.repository.Repository;

public class LibraryReplaceProcessor
extends InterruptibleComponent {
    private static final Logger LOGGER = LogManager.getLogger(LibraryReplaceProcessor.class);
    private static final String PATCHY_TYPE = "patchy";
    private final List<LibraryReplaceProcessorListener> listeners = Collections.synchronizedList(new ArrayList());
    private final Map<String, List<LibraryReplace>> libraries = Collections.synchronizedMap(new HashMap());
    private final Gson gson = new GsonBuilder().registerTypeAdapter(Pattern.class, (Object)new PatternTypeAdapter()).registerTypeAdapterFactory((TypeAdapterFactory)new LowerCaseEnumTypeAdapterFactory()).create();
    private boolean refreshed;
    private boolean allowElyEverywhere;

    public LibraryReplaceProcessor(ComponentManager manager) throws Exception {
        super(manager);
    }

    public boolean isAllowElyEverywhere() {
        return this.allowElyEverywhere;
    }

    public void setAllowElyEverywhere(boolean allowElyEverywhere) {
        this.allowElyEverywhere = allowElyEverywhere;
    }

    public boolean hasLibraries(Version version, String type) {
        return this.hasLibrariesExplicitly(version, type) || this.hasLibrariesExplicitly(version, PATCHY_TYPE);
    }

    public boolean hasLibrariesExplicitly(VersionSyncInfo version, String type) {
        return version.isInstalled() && this.hasLibrariesExplicitly(version.getLocal(), type) || version.hasRemote() && this.hasLibrariesExplicitly(version.getRemote(), type);
    }

    public boolean hasLibrariesExplicitly(Version version, String type) {
        CompleteVersion complete;
        List<Library> libraries;
        if (this.hasLibrariesExplicitly(version.getID(), type)) {
            return true;
        }
        List<LibraryReplace> list = this.forType(type);
        if (list == null) {
            return false;
        }
        if (version instanceof CompleteVersion && (libraries = (complete = (CompleteVersion)version).getLibraries()) != null) {
            for (LibraryReplace lib : list) {
                for (Library replacingLib : libraries) {
                    if (!lib.replaces(replacingLib)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasLibrariesExplicitly(String version, String type) {
        List<LibraryReplace> list = this.forType(type);
        if (list == null) {
            return false;
        }
        for (LibraryReplace lib : list) {
            if (!lib.supports(version)) continue;
            return true;
        }
        return false;
    }

    private List<LibraryReplace> forType(String type) {
        return this.libraries.get(type);
    }

    private List<LibraryReplace> getLibraries(CompleteVersion complete, String type) {
        String id = complete.getID();
        List<LibraryReplace> list = this.forType(type);
        if (list == null) {
            return Collections.emptyList();
        }
        return list.stream().filter(lib -> {
            if (lib.supports(id)) return true;
            if (!complete.getLibraries().stream().anyMatch(lib::replaces)) return false;
            return true;
        }).collect(Collectors.toList());
    }

    public CompleteVersion process(CompleteVersion original, String type) {
        CompleteVersion result = this.processExplicitly(original, type);
        result = this.processExplicitly(result, PATCHY_TYPE);
        return result;
    }

    public CompleteVersion processExplicitly(CompleteVersion original, String type) {
        LOGGER.debug("Processing version {} for type {}", (Object)original.getID(), (Object)type);
        if (original.isProceededFor(type)) {
            LOGGER.debug("... already proceeded");
            return original;
        }
        CompleteVersion target = original.copyInto(new CompleteVersion());
        target.setProceededFor(type);
        List<LibraryReplace> libraries = this.getLibraries(original, type);
        for (LibraryReplace replacementLib : libraries) {
            Library library;
            int i;
            LOGGER.debug("Now processing: {}", (Object)replacementLib.getName());
            if (target.getLibraries().contains(replacementLib)) {
                LOGGER.debug("... already contains");
                continue;
            }
            if (replacementLib.getRequirementList() != null) {
                ArrayList<Library> requiredLibs = new ArrayList<Library>(replacementLib.getRequirementList());
                for (i = 0; i < target.getLibraries().size(); ++i) {
                    library = target.getLibraries().get(i);
                    Iterator requiredIterator = requiredLibs.iterator();
                    while (requiredIterator.hasNext()) {
                        Library requiredLib = (Library)requiredIterator.next();
                        if (!library.getPlainName().equals(requiredLib.getPlainName())) continue;
                        LOGGER.debug("... replacing required at index {}: {} -> {}", (Object)Unbox.box((int)i), (Object)library.getName(), (Object)requiredLib.getName());
                        target.getLibraries().set(i, requiredLib);
                        requiredIterator.remove();
                    }
                }
                if (!requiredLibs.isEmpty()) {
                    LOGGER.debug("... prepending required: {}", requiredLibs);
                    target.getLibraries().addAll(0, requiredLibs);
                }
            }
            if (replacementLib.getPattern() != null) {
                Pattern pattern = replacementLib.getPattern();
                for (i = 0; i < target.getLibraries().size(); ++i) {
                    library = target.getLibraries().get(i);
                    if (!pattern.matcher(library.getName()).matches()) continue;
                    LOGGER.debug("... replacing at index {}: {}", (Object)Unbox.box((int)i), (Object)library.getName());
                    target.getLibraries().set(i, replacementLib);
                }
            } else {
                LOGGER.debug("... prepending: {}", (Object)replacementLib.getName());
                target.getLibraries().add(0, replacementLib);
            }
            if (StringUtils.isNotBlank((CharSequence)replacementLib.getArgs())) {
                String args = target.getMinecraftArguments();
                args = StringUtils.isBlank((CharSequence)args) ? replacementLib.getArgs() : args + ' ' + replacementLib.getArgs();
                target.setMinecraftArguments(args);
            }
            if (!StringUtils.isNotBlank((CharSequence)replacementLib.getMainClass())) continue;
            target.setMainClass(replacementLib.getMainClass());
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean refresh(int session) {
        if (this.refreshed) {
            return true;
        }
        LOGGER.debug("Refreshing libraries...");
        for (LibraryReplaceProcessorListener l : this.listeners) {
            l.onLibraryReplaceRefreshing(this);
        }
        try {
            this.refreshDirectly();
        }
        catch (Exception e) {
            LOGGER.warn("Ely refresh failed", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            for (LibraryReplaceProcessorListener l : this.listeners) {
                l.onLibraryReplaceRefreshed(this);
            }
        }
        LOGGER.debug("Refreshed successfully");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshDirectly() throws Exception {
        Payload resp = (Payload)this.gson.fromJson((Reader)Repository.EXTRA_VERSION_REPO.read("libraries/replace.json"), Payload.class);
        double VERSION = 1.0;
        if (resp.version != VERSION) {
            throw new IllegalArgumentException("incompatible version; required: " + VERSION + ", got: " + resp.version);
        }
        Map<String, List<LibraryReplace>> map = this.libraries;
        synchronized (map) {
            this.libraries.clear();
            this.libraries.putAll(resp.libraries);
            if (!this.libraries.containsKey(Account.AccountType.ELY_LEGACY.toString()) && resp.libraries.containsKey(Account.AccountType.ELY.toString())) {
                this.libraries.put(Account.AccountType.ELY_LEGACY.toString(), (List)resp.libraries.get(Account.AccountType.ELY.toString()));
            }
        }
        this.refreshed = true;
    }

    public void addListener(LibraryReplaceProcessorListener listener) {
        this.listeners.add(listener);
    }

    private static class Payload {
        private double version;
        private boolean allowElyEveywhere;
        private Map<String, List<LibraryReplace>> libraries;

        private Payload() {
        }
    }
}

