/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.managers;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import ru.turikhay.tlauncher.configuration.AbstractConfiguration;
import ru.turikhay.tlauncher.configuration.Configurable;
import ru.turikhay.util.MinecraftUtil;

public class JavaManagerConfig
implements Configurable {
    public static final String PATH_ROOT_DIR = "minecraft.jre.dir";
    public static final String PATH_ARGS = "minecraft.javaargs";
    public static final String PATH_MC_ARGS = "minecraft.args";
    public static final String PATH_JRE_TYPE = "minecraft.jre.type";
    public static final String PATH_USE_OPTIMIZED_ARGS = "minecraft.improvedargs";
    private String rootDir;
    private String args;
    private String mcArgs;
    private JreType jreType;
    private boolean useOptimizedArguments;
    private static final Map<String, Class<? extends JreType>> TYPES = new LinkedHashMap<String, Class<? extends JreType>>();

    public JavaManagerConfig(String rootDir, String args, String mcArgs, JreType jreType, boolean useOptimizedArguments) {
        this.rootDir = rootDir;
        this.args = args;
        this.mcArgs = mcArgs;
        this.jreType = jreType;
        this.useOptimizedArguments = useOptimizedArguments;
    }

    public JavaManagerConfig() {
    }

    public Optional<String> getRootDir() {
        return Optional.ofNullable(this.rootDir);
    }

    public String getRootDirOrDefault() {
        return this.getRootDir().orElse(JavaManagerConfig.getDefaultRootDir());
    }

    public Optional<String> getArgs() {
        return Optional.ofNullable(this.args);
    }

    public Optional<String> getMinecraftArgs() {
        return Optional.ofNullable(this.mcArgs);
    }

    public Optional<JreType> getJreType() {
        return Optional.ofNullable(this.jreType);
    }

    public JreType getJreTypeOrDefault() {
        return this.getJreType().orElse(new Recommended());
    }

    public void setRootDir(String rootDir) {
        this.rootDir = rootDir;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public void setMcArgs(String mcArgs) {
        this.mcArgs = mcArgs;
    }

    public void setJreType(JreType jreType) {
        this.jreType = jreType;
    }

    public boolean useOptimizedArguments() {
        return this.useOptimizedArguments;
    }

    public void setUseOptimizedArguments(boolean useOptimizedArguments) {
        this.useOptimizedArguments = useOptimizedArguments;
    }

    @Override
    public void load(AbstractConfiguration configuration) {
        JreType jreType;
        this.rootDir = configuration.get(PATH_ROOT_DIR);
        this.args = configuration.get(PATH_ARGS);
        this.mcArgs = configuration.get(PATH_MC_ARGS);
        String jreTypeString = configuration.get(PATH_JRE_TYPE);
        if (jreTypeString == null) {
            jreTypeString = "recommended";
        }
        switch (jreTypeString) {
            case "current": {
                jreType = new Current();
                break;
            }
            case "custom": {
                jreType = new Custom();
                break;
            }
            default: {
                jreType = new Recommended();
            }
        }
        if (jreType instanceof Configurable) {
            ((Configurable)((Object)jreType)).load(configuration);
        }
        this.jreType = jreType;
        this.useOptimizedArguments = configuration.getBoolean(PATH_USE_OPTIMIZED_ARGS);
    }

    @Override
    public void save(AbstractConfiguration configuration) {
        configuration.set(PATH_ROOT_DIR, this.rootDir);
        configuration.set(PATH_ARGS, this.args);
        configuration.set(PATH_MC_ARGS, this.mcArgs);
        if (this.jreType == null) {
            configuration.set(PATH_JRE_TYPE, null);
        } else {
            configuration.set(PATH_JRE_TYPE, this.jreType.getType());
        }
        configuration.set(PATH_USE_OPTIMIZED_ARGS, this.useOptimizedArguments);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaManagerConfig)) {
            return false;
        }
        JavaManagerConfig that = (JavaManagerConfig)o;
        if (this.useOptimizedArguments != that.useOptimizedArguments) {
            return false;
        }
        if (!Objects.equals(this.rootDir, that.rootDir)) {
            return false;
        }
        if (!Objects.equals(this.args, that.args)) {
            return false;
        }
        if (!Objects.equals(this.mcArgs, that.mcArgs)) {
            return false;
        }
        return Objects.equals(this.jreType, that.jreType);
    }

    public int hashCode() {
        int result = this.rootDir != null ? this.rootDir.hashCode() : 0;
        result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
        result = 31 * result + (this.mcArgs != null ? this.mcArgs.hashCode() : 0);
        result = 31 * result + (this.jreType != null ? this.jreType.hashCode() : 0);
        result = 31 * result + (this.useOptimizedArguments ? 1 : 0);
        return result;
    }

    public static String getDefaultRootDir() {
        return MinecraftUtil.getSystemRelatedDirectory("tlauncher/mojang_jre").getAbsolutePath();
    }

    public static Set<String> keys() {
        return Collections.unmodifiableSet(TYPES.keySet());
    }

    public static JreType createByType(String type) throws IllegalArgumentException {
        Class<? extends JreType> jreTypeClass = TYPES.get(type);
        if (jreTypeClass == null) {
            throw new IllegalArgumentException("unknown jreType: " + type);
        }
        try {
            return jreTypeClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("couldn't create jreType: " + jreTypeClass, e);
        }
    }

    static {
        TYPES.put("recommended", Recommended.class);
        TYPES.put("current", Current.class);
        TYPES.put("custom", Custom.class);
    }

    public static interface JreType {
        public String getType();
    }

    public static class Recommended
    implements JreType {
        public static final String TYPE = "recommended";

        public int hashCode() {
            return Recommended.class.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Recommended;
        }

        @Override
        public String getType() {
            return TYPE;
        }
    }

    public static class Current
    implements JreType {
        public static final String TYPE = "current";

        public int hashCode() {
            return Current.class.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Current;
        }

        @Override
        public String getType() {
            return TYPE;
        }
    }

    public static class Custom
    implements JreType,
    Configurable {
        public static final String PATH_CUSTOM_PATH = "minecraft.jre.custom.path";
        public static final String TYPE = "custom";
        private String path;

        public Optional<String> getPath() {
            return Optional.ofNullable(this.path);
        }

        public Custom() {
        }

        public Custom(String path) {
            this.path = path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Custom)) {
                return false;
            }
            Custom custom = (Custom)o;
            return Objects.equals(this.path, custom.path);
        }

        public int hashCode() {
            return this.path != null ? this.path.hashCode() : 0;
        }

        @Override
        public void load(AbstractConfiguration configuration) {
            this.path = configuration.get(PATH_CUSTOM_PATH);
        }

        @Override
        public void save(AbstractConfiguration configuration) {
            configuration.set(PATH_CUSTOM_PATH, this.path);
        }

        @Override
        public String getType() {
            return TYPE;
        }
    }
}

