/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.managers;

import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.Version;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.downloader.DownloadableContainer;
import ru.turikhay.tlauncher.downloader.DownloadableContainerHandler;
import ru.turikhay.tlauncher.jre.FileIntegrityEntry;
import ru.turikhay.tlauncher.jre.JavaPlatform;
import ru.turikhay.tlauncher.jre.JavaRuntimeLocal;
import ru.turikhay.tlauncher.jre.JavaRuntimeLocalDiscoverer;
import ru.turikhay.tlauncher.jre.JavaRuntimeManifest;
import ru.turikhay.tlauncher.jre.JavaRuntimeRemote;
import ru.turikhay.tlauncher.jre.JavaRuntimeRemoteListFetcher;
import ru.turikhay.util.OS;

public class JavaManager {
    private static final Logger LOGGER = LogManager.getLogger(JavaManager.class);
    private static final long EXTRA_SPACE = 0x4000000L;
    public static final Instant JAVA16_UPGRADE_POINT = Instant.ofEpochSecond(1620818355L);
    private final JavaRuntimeRemoteListFetcher fetcher;
    private final JavaRuntimeLocalDiscoverer discoverer;

    public JavaManager(JavaRuntimeRemoteListFetcher fetcher, JavaRuntimeLocalDiscoverer discoverer) {
        this.fetcher = fetcher;
        this.discoverer = discoverer;
    }

    public JavaManager(File rootDir) {
        this(new JavaRuntimeRemoteListFetcher(), new JavaRuntimeLocalDiscoverer(rootDir));
    }

    public JavaRuntimeLocalDiscoverer getDiscoverer() {
        return this.discoverer;
    }

    public JavaRuntimeRemoteListFetcher getFetcher() {
        return this.fetcher;
    }

    public Optional<JavaRuntimeLocal> getLatestVersionInstalled(String name) throws InterruptedException {
        String localVersion;
        Optional<JavaRuntimeRemote> remoteRuntimeOpt;
        Optional<JavaRuntimeLocal> localRuntimeOpt = this.discoverer.getCurrentPlatformRuntime(name);
        if (!localRuntimeOpt.isPresent()) {
            return Optional.empty();
        }
        JavaRuntimeLocal localRuntime = localRuntimeOpt.get();
        if (localRuntime.hasOverride()) {
            LOGGER.debug("Local JRE {} has override file, and thus always considered latest", (Object)localRuntime.getName());
            return localRuntimeOpt;
        }
        try {
            remoteRuntimeOpt = this.fetcher.fetch().get().getCurrentPlatformFirstRuntimeCandidate(name);
        }
        catch (ExecutionException e) {
            LOGGER.warn("Couldn't fetch the remote list. Assuming {} is the latest version", (Object)name);
            return localRuntimeOpt;
        }
        if (!remoteRuntimeOpt.isPresent()) {
            LOGGER.warn("Couldn't find {} in the remote list. Assuming it is the latest version", (Object)name);
            return localRuntimeOpt;
        }
        JavaRuntimeRemote remoteRuntime = remoteRuntimeOpt.get();
        try {
            localVersion = localRuntime.getVersion();
        }
        catch (IOException ioE) {
            LOGGER.warn("Couldn't read version file of {}. Assuming the local version NOT the latest version", (Object)name);
            return Optional.empty();
        }
        String remoteVersion = remoteRuntime.getVersion().getName();
        if (remoteVersion.equals(localVersion)) {
            JavaRuntimeManifest manifest;
            try {
                manifest = remoteRuntime.getManifest();
            }
            catch (ExecutionException e) {
                LOGGER.debug("Couldn't fetch manifest. Assuming the version {} is latest", (Object)name, (Object)e);
                return localRuntimeOpt;
            }
            File workingDirectory = localRuntime.getWorkingDirectory();
            LOGGER.info("Checking integrity of {}", (Object)workingDirectory.getAbsolutePath());
            if (this.checkIntegrity(manifest, workingDirectory)) {
                return localRuntimeOpt;
            }
            LOGGER.info("Local version {} is incomplete or tampered with", (Object)name);
            return Optional.empty();
        }
        LOGGER.debug("Local ({}) and remote ({}) versions of {} don't match. Assuming the installed version is NOT latest.", (Object)localVersion, (Object)remoteVersion, (Object)name);
        return Optional.empty();
    }

    private boolean checkIntegrity(JavaRuntimeManifest manifest, File workingDirectory) {
        List<FileIntegrityEntry> entries = manifest.toIntegrityEntries();
        return entries.parallelStream().noneMatch(e -> e.isTamperedWithAt(workingDirectory));
    }

    public CompleteVersion.JavaVersion getFallbackRecommendedVersion(Version version, boolean debugging) {
        String id = version.getID();
        if (JavaPlatform.CURRENT_PLATFORM_CANDIDATES.isEmpty()) {
            if (debugging) {
                LOGGER.debug("Current platform is unsupported, and {} won't have fallback JRE", (Object)id);
            }
            return null;
        }
        if (version.getReleaseTime() == null) {
            if (debugging) {
                LOGGER.debug("Version {} has no release time", (Object)id);
            }
            return null;
        }
        if (OS.JAVA_VERSION.getMajor() < 9) {
            if (debugging) {
                LOGGER.debug("We're running Java 8; no fallback JRE is required for {}", (Object)id);
            }
            return null;
        }
        if (version.getReleaseTime().toInstant().compareTo(JAVA16_UPGRADE_POINT) >= 0) {
            if (debugging) {
                LOGGER.debug("Version {} was released after Java 16 upgrade point; no fallback JRE for it.", (Object)id);
            }
            return null;
        }
        if (debugging) {
            LOGGER.debug("Fallback JRE for {} is {}", (Object)id, (Object)"jre-legacy");
        }
        return new CompleteVersion.JavaVersion("jre-legacy", 8);
    }

    public boolean hasEnoughSpaceToInstall(JavaRuntimeRemote remote) throws ExecutionException, InterruptedException {
        long usableSpace = this.discoverer.getRootDir().getUsableSpace();
        if (usableSpace < 1L) {
            LOGGER.warn("Couldn't query usable space left on {}. Result is {}. Probably has no space left.", (Object)this.discoverer.getRootDir().getAbsolutePath(), (Object)usableSpace);
            return false;
        }
        long size = remote.getManifest().countBytes();
        if (size + 0x4000000L >= usableSpace) {
            LOGGER.warn("Usable space is almost or already exhausted. Need {} + {} bytes,but only got {}", (Object)size, (Object)usableSpace, (Object)0x4000000L);
            return false;
        }
        return true;
    }

    public DownloadableContainer installVersionNow(JavaRuntimeRemote remote, File rootDir, boolean forceDownload) throws ExecutionException, InterruptedException {
        return new JreDownloadableContainer(remote, rootDir, forceDownload);
    }

    private static class JreDownloadableContainer
    extends DownloadableContainer {
        JreDownloadableContainer(final JavaRuntimeRemote remote, final File rootDir, boolean forceDownload) throws ExecutionException, InterruptedException {
            this.addAll(remote.getManifest().toDownloadableList(remote.getWorkingDir(rootDir), forceDownload));
            this.addHandler(new DownloadableContainerHandler(){

                @Override
                public void onFullComplete(DownloadableContainer var1) {
                    try {
                        remote.toLocal(rootDir).writeVersion(remote.getVersion().getName());
                    }
                    catch (IOException e) {
                        LOGGER.error("Couldn't write version info", (Throwable)e);
                    }
                }
            });
        }
    }
}

