/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.managers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import ru.turikhay.tlauncher.minecraft.launcher.ProcessHook;
import ru.turikhay.tlauncher.minecraft.launcher.hooks.WindowsGpuPreferenceHook;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.util.OS;

public interface GPUManager {
    default public boolean isEmpty() {
        return false;
    }

    @Nonnull
    public List<GPU> discoveryGPUs();

    default public Optional<GPU> findGPU(String name) {
        return this.discoveryGPUs().stream().filter(it -> ((GPU)it).name.equalsIgnoreCase(name)).findAny();
    }

    default public Optional<GPU> findIntegratedGPU() {
        return this.discoveryGPUs().stream().filter(it -> ((GPU)it).isDefault).findAny();
    }

    default public Optional<GPU> findDiscreteGPU() {
        return this.discoveryGPUs().stream().filter(it -> !((GPU)it).isDefault).findAny();
    }

    public static abstract class GPU {
        private final String name;
        private final Vendor vendor;
        private final boolean isDefault;
        public static final GPU DEFAULT = new GPU("SYSTEM", Vendor.Unknown, false){

            @Override
            public String getDisplayName(GPUManager gpuManager) {
                return Localizable.get("settings.gpu.default.label");
            }

            @Override
            public ProcessHook getHook(GPUManager gpuManager) {
                return ProcessHook.None.INSTANCE;
            }
        };
        public static final GPU INTEGRATED;
        public static final GPU DISCRETE;
        public static final List<GPU> GLOBAL_DEFINED;

        public GPU(String name, Vendor vendor, boolean isDefault) {
            this.name = name;
            this.vendor = vendor;
            this.isDefault = isDefault;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName(GPUManager gpuManager) {
            return this.getName();
        }

        public Vendor getVendor() {
            return this.vendor;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public abstract ProcessHook getHook(GPUManager var1);

        static {
            if (OS.WINDOWS.isCurrent()) {
                INTEGRATED = new GPU("INTEGRATED", Vendor.Unknown, false){

                    @Override
                    public String getDisplayName(GPUManager gpuManager) {
                        return Localizable.get("settings.gpu.integrated.label");
                    }

                    @Override
                    public ProcessHook getHook(GPUManager gpuManager) {
                        if (WindowsGpuPreferenceHook.isSupported()) {
                            return new WindowsGpuPreferenceHook(WindowsGpuPreferenceHook.Preference.MinimumPower);
                        }
                        return ProcessHook.None.INSTANCE;
                    }
                };
                DISCRETE = new GPU("DISCRETE", Vendor.Unknown, false){

                    @Override
                    public String getDisplayName(GPUManager gpuManager) {
                        return Localizable.get("settings.gpu.discrete.label");
                    }

                    @Override
                    public ProcessHook getHook(GPUManager gpuManager) {
                        if (WindowsGpuPreferenceHook.isSupported()) {
                            return new WindowsGpuPreferenceHook(WindowsGpuPreferenceHook.Preference.HighPerformance);
                        }
                        return ProcessHook.None.INSTANCE;
                    }
                };
            } else {
                INTEGRATED = new GPU("INTEGRATED", Vendor.Unknown, false){

                    @Override
                    public String getDisplayName(GPUManager gpuManager) {
                        return gpuManager.findIntegratedGPU().map(it -> Localizable.get("settings.gpu.integrated.specific.label", it.getDisplayName(gpuManager))).orElse(Localizable.get("settings.gpu.integrated.label"));
                    }

                    @Override
                    public ProcessHook getHook(GPUManager gpuManager) {
                        return gpuManager.findIntegratedGPU().map(gpu -> gpu.getHook(gpuManager)).orElse(ProcessHook.None.INSTANCE);
                    }
                };
                DISCRETE = new GPU("DISCRETE", Vendor.Unknown, false){

                    @Override
                    public String getDisplayName(GPUManager gpuManager) {
                        return gpuManager.findDiscreteGPU().map(it -> Localizable.get("settings.gpu.discrete.specific.label", it.getDisplayName(gpuManager))).orElse(Localizable.get("settings.gpu.discrete.label"));
                    }

                    @Override
                    public ProcessHook getHook(GPUManager gpuManager) {
                        return gpuManager.findDiscreteGPU().map(gpu -> gpu.getHook(gpuManager)).orElse(ProcessHook.None.INSTANCE);
                    }
                };
            }
            GLOBAL_DEFINED = Collections.unmodifiableList(Arrays.asList(DEFAULT, INTEGRATED, DISCRETE));
        }
    }

    public static enum Vendor {
        Unknown,
        AMD,
        Intel,
        Nvidia;

        private static final Map<Vendor, Collection<String>> KEYWORDS;

        public static Vendor guessVendorByName(String name) {
            String nameLowercase = name.toLowerCase(Locale.ROOT);
            for (Map.Entry<Vendor, Collection<String>> entry : KEYWORDS.entrySet()) {
                if (!entry.getValue().stream().anyMatch(nameLowercase::contains)) continue;
                return entry.getKey();
            }
            return Unknown;
        }

        static {
            KEYWORDS = new EnumMap<Vendor, Collection<String>>(Vendor.class);
            KEYWORDS.put(AMD, Arrays.asList("amd", "radeon", "vega"));
            KEYWORDS.put(Intel, Arrays.asList("intel", "uhd"));
            KEYWORDS.put(Nvidia, Arrays.asList("nvidia", "geforce", "gtx", "rtx"));
        }
    }

    public static final class Empty
    implements GPUManager {
        public static final GPUManager INSTANCE = new Empty();

        private Empty() {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @Nonnull
        public List<GPU> discoveryGPUs() {
            return Collections.emptyList();
        }

        @Override
        public Optional<GPU> findGPU(String name) {
            return Optional.empty();
        }

        @Override
        public Optional<GPU> findIntegratedGPU() {
            return Optional.empty();
        }

        @Override
        public Optional<GPU> findDiscreteGPU() {
            return Optional.empty();
        }

        public String toString() {
            return "Empty";
        }
    }
}

