/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.managers;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.component.ComponentDependence;
import ru.turikhay.tlauncher.component.InterruptibleComponent;
import ru.turikhay.tlauncher.component.LauncherComponent;
import ru.turikhay.tlauncher.component.RefreshableComponent;
import ru.turikhay.util.async.LoopedThread;

public class ComponentManager {
    private final TLauncher tlauncher;
    private final Set<Class<? extends LauncherComponent>> loaded = new HashSet<Class<? extends LauncherComponent>>();
    private final List<LauncherComponent> components;
    private final ComponentManagerRefresher refresher;

    public ComponentManager(TLauncher tlauncher) {
        if (tlauncher == null) {
            throw new NullPointerException();
        }
        this.tlauncher = tlauncher;
        this.components = Collections.synchronizedList(new ArrayList());
        this.refresher = new ComponentManagerRefresher(this);
        this.refresher.start();
    }

    public TLauncher getLauncher() {
        return this.tlauncher;
    }

    public <T extends LauncherComponent> T loadComponent(Class<T> classOfT) {
        if (classOfT == null) {
            throw new NullPointerException();
        }
        this.preloadComponent(classOfT);
        return this.getComponent(classOfT);
    }

    private <T extends LauncherComponent> void preloadComponent(@Nonnull Class<T> classOfT) {
        if (this.hasComponent(classOfT)) {
            return;
        }
        this.loaded.add(classOfT);
        ComponentDependence dependence = classOfT.getAnnotation(ComponentDependence.class);
        if (dependence != null) {
            for (Class<? extends LauncherComponent> requiredClass : dependence.value()) {
                this.preloadComponent(requiredClass);
            }
        }
        this.rawLoadComponent(classOfT);
    }

    private <T extends LauncherComponent> void rawLoadComponent(Class<T> classOfT) {
        LauncherComponent component;
        Constructor<T> constructor;
        if (classOfT == null) {
            throw new NullPointerException();
        }
        if (!LauncherComponent.class.isAssignableFrom(classOfT)) {
            throw new IllegalArgumentException("Given class is not a LauncherComponent: " + classOfT.getSimpleName());
        }
        try {
            constructor = classOfT.getConstructor(ComponentManager.class);
        }
        catch (Exception var6) {
            throw new IllegalStateException("Cannot get constructor for component: " + classOfT.getSimpleName(), var6);
        }
        try {
            component = (LauncherComponent)constructor.newInstance(this);
        }
        catch (Exception var5) {
            throw new IllegalStateException("Cannot create a new instance for component: " + classOfT.getSimpleName(), var5);
        }
        this.components.add(component);
    }

    public <T extends LauncherComponent> T getComponent(Class<T> classOfT) {
        if (classOfT == null) {
            throw new NullPointerException();
        }
        for (LauncherComponent component : this.components) {
            if (!classOfT.isInstance(component)) continue;
            return (T)((LauncherComponent)classOfT.cast(component));
        }
        throw new IllegalArgumentException("Cannot find the component!");
    }

    <T extends LauncherComponent> boolean hasComponent(Class<T> classOfT) {
        if (classOfT == null) {
            return false;
        }
        for (LauncherComponent launcherComponent : this.components) {
            if (!classOfT.isInstance(launcherComponent)) continue;
            return true;
        }
        for (Class clazz : this.loaded) {
            if (!classOfT.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public <T> List<T> getComponentsOf(Class<T> classOfE) {
        if (classOfE == null) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>();
        for (LauncherComponent component : this.components) {
            if (!classOfE.isInstance(component)) continue;
            list.add(classOfE.cast(component));
        }
        return list;
    }

    public void startAsyncRefresh() {
        this.refresher.iterate();
    }

    void startRefresh() {
        for (LauncherComponent component : this.components) {
            if (!(component instanceof RefreshableComponent)) continue;
            RefreshableComponent interruptible = (RefreshableComponent)component;
            interruptible.refreshComponent();
        }
    }

    public void stopRefresh() {
        for (LauncherComponent component : this.components) {
            if (!(component instanceof InterruptibleComponent)) continue;
            InterruptibleComponent interruptible = (InterruptibleComponent)component;
            interruptible.stopRefresh();
        }
    }

    static class ComponentManagerRefresher
    extends LoopedThread {
        private final ComponentManager parent;

        ComponentManagerRefresher(ComponentManager manager) {
            super("ComponentManagerRefresher");
            this.parent = manager;
        }

        @Override
        protected void iterateOnce() {
            this.parent.startRefresh();
        }
    }
}

