/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.managers;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.managers.MemoryAllocationService;
import ru.turikhay.util.Lazy;
import ru.turikhay.util.OS;

class BaseVersionTable {
    private static final int ONE_GIG = 1024;
    private static final int TWO_GIGS = 2048;
    private static final int THREE_GIGS = 3072;
    private static final int FOUR_GIGS = 4096;
    private static final Logger LOGGER = LogManager.getLogger(BaseVersionTable.class);
    private static final Lazy<BaseVersionTable> TABLE = Lazy.of(BaseVersionTable::new);
    private final Date firstVersionReleaseDate = BaseVersionTable.parseDate("2009-05-13T20:11:00+00:00");
    private final List<BaseVersion> versions = new ArrayList<BaseVersion>();
    private boolean hasSimulationDistance;

    public static BaseVersionTable getInstance() {
        return TABLE.get();
    }

    BaseVersionTable() {
        this.init();
    }

    public BaseVersion findBaseVersion(MemoryAllocationService.VersionContext version) {
        Date releaseTime = version.getReleaseTime();
        if (releaseTime.compareTo(this.firstVersionReleaseDate) >= 0) {
            BaseVersion match = null;
            for (BaseVersion baseVersion : this.versions) {
                if (releaseTime.compareTo(baseVersion.releaseTime) < 0) break;
                match = baseVersion;
            }
            if (match != null) {
                LOGGER.debug("Found match for {} ({}): {}", (Object)version.getId(), (Object)releaseTime, (Object)match.family);
                return match;
            }
        }
        LOGGER.warn("No match found for {} ({})", (Object)version.getId(), (Object)releaseTime);
        return null;
    }

    public BaseVersion getDefaultBaseVersion() {
        return this.versions.get(this.versions.size() - 1);
    }

    private void init() {
        this.add("old", "rd-132211", "2009-05-13T20:11:00+00:00", ctx -> 1024);
        this.add("1.3", "1.3", "2012-07-25T22:00:00+00:00", ctx -> 1024);
        this.add("1.13", "18w07a", "2018-02-14T17:34:13+00:00", ctx -> 2048);
        this.hasSimulationDistance = true;
        this.add("1.18", "1.18_experimental-snapshot-1", "2021-07-13T12:54:19+00:00", ctx -> {
            boolean isMacOsArm;
            boolean bl = isMacOsArm = ctx.os.isOs(OS.OSX) && ctx.os.arch.isARM();
            if (ctx.mem.total < 5500) {
                if (isMacOsArm || ctx.mem.total < 3500) {
                    return 2048;
                }
                return 3072;
            }
            if (isMacOsArm && ctx.mem.total < 12000) {
                return 2048;
            }
            return 4096;
        });
    }

    private void add(String family, String id, String releaseTime, Function<MemoryAllocationService.QueryContext, Integer> baseRequirement) {
        BaseVersion baseVersion = new BaseVersion(family, id, BaseVersionTable.parseDate(releaseTime), baseRequirement, this.hasSimulationDistance);
        this.versions.add(baseVersion);
    }

    static Date parseDate(String date) {
        return Date.from(OffsetDateTime.parse(date).toInstant());
    }

    static class BaseVersion
    implements Comparable<BaseVersion> {
        final String family;
        final String id;
        final Date releaseTime;
        final Function<MemoryAllocationService.QueryContext, Integer> requirement;
        final boolean hasSimulationDistance;

        BaseVersion(String family, String id, Date releaseTime, Function<MemoryAllocationService.QueryContext, Integer> requirement, boolean hasSimulationDistance) {
            this.family = family;
            this.id = id;
            this.releaseTime = releaseTime;
            this.requirement = requirement;
            this.hasSimulationDistance = hasSimulationDistance;
        }

        @Override
        public int compareTo(BaseVersion o) {
            return this.releaseTime.compareTo(o.releaseTime);
        }
    }
}

