/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.managers;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.sentry.Sentry;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import org.apache.http.client.fluent.Request;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.managers.ConnectivityManager;
import ru.turikhay.tlauncher.pasta.Pasta;
import ru.turikhay.util.EHttpClient;
import sun.security.validator.ValidatorException;

public class AuthServerChecker
implements ConnectivityManager.EntryChecker {
    private static final Logger LOGGER = LogManager.getLogger(AuthServerChecker.class);
    public static final String AUTH_SERVER_HOST = "authserver.mojang.com";
    private static final String AUTH_SERVER_STATUS_PAGE = "https://authserver.mojang.com";
    private static final String AUTH_SERVER_STATUS_OK = "OK";
    private volatile DetectedThirdPartyAuthenticatorInfo detectedThirdPartyAuthenticator;
    private String authServerIp;
    private String statusJsonString;

    public DetectedThirdPartyAuthenticatorInfo getDetectedThirdPartyAuthenticator() {
        return this.detectedThirdPartyAuthenticator;
    }

    @Override
    public Boolean checkConnection() throws Exception {
        Callable validator;
        DetectedThirdPartyAuthenticatorInfo detectedAuthenticator = null;
        List<Callable> validators = Arrays.asList(this::queryDns, this::queryJsonStatus);
        Iterator<Callable> iterator = validators.iterator();
        while (iterator.hasNext() && (detectedAuthenticator = (DetectedThirdPartyAuthenticatorInfo)(validator = iterator.next()).call()) == null) {
        }
        if (detectedAuthenticator != null) {
            String name = detectedAuthenticator.getName();
            if (name == null) {
                LOGGER.warn("Detected unknown third-party authenticator");
            } else {
                LOGGER.warn("Detected third-party authenticator: {}", (Object)name);
            }
            Sentry.capture((EventBuilder)new EventBuilder().withLevel(Event.Level.WARNING).withMessage(name == null ? "unknown third party authenticator" : "third party authenticator: " + name).withTag("authServerIp", this.authServerIp).withExtra("statusJson", (Object)Pasta.pasteJson(this.statusJsonString)));
            this.detectedThirdPartyAuthenticator = detectedAuthenticator;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private DetectedThirdPartyAuthenticatorInfo queryDns() throws IOException {
        InetAddress address = Inet4Address.getByName(AUTH_SERVER_HOST);
        LOGGER.debug("{} resolves to {}", (Object)AUTH_SERVER_HOST, (Object)address.getHostAddress());
        this.authServerIp = address.getHostAddress();
        switch (address.getHostAddress()) {
            case "51.68.172.243": {
                return new DetectedThirdPartyAuthenticatorInfo("EasyMC");
            }
            case "134.209.132.125": {
                return new DetectedThirdPartyAuthenticatorInfo("MCLeaks");
            }
            case "142.44.142.126": {
                return new DetectedThirdPartyAuthenticatorInfo("The Altening");
            }
            case "127.0.0.1": {
                return new DetectedThirdPartyAuthenticatorInfo(null);
            }
        }
        return null;
    }

    private DetectedThirdPartyAuthenticatorInfo queryJsonStatus() throws Exception {
        CloseableHttpClient httpClient = EHttpClient.createRepeatable();
        try {
            this.queryJsonStatusUsingClient(httpClient);
        }
        catch (SSLException e) {
            if (!(e.getCause() instanceof ValidatorException)) {
                LOGGER.warn("Couldn't query json status because of SSL error, but it is not caused by validation failure");
                throw e;
            }
            LOGGER.warn("Couldn't query json status because of SSL validation error", (Throwable)e);
            LOGGER.debug("Now trying with unsafe http client");
            try {
                return this.queryJsonStatusUsingUnsafeClient(e);
            }
            catch (Exception e1) {
                e1.addSuppressed(e);
                throw e1;
            }
        }
        return null;
    }

    private DetectedThirdPartyAuthenticatorInfo queryJsonStatusUsingUnsafeClient(SSLException e) throws Exception {
        CloseableHttpClient unsafeHttpsClient;
        try {
            unsafeHttpsClient = AuthServerChecker.createUnsafeHttpsClient();
        }
        catch (Exception e1) {
            LOGGER.warn("Couldn't create unsafe http client", (Throwable)e1);
            throw e;
        }
        try {
            this.queryJsonStatusUsingClient(unsafeHttpsClient);
        }
        catch (UnexpectedStatus e1) {
            return new DetectedThirdPartyAuthenticatorInfo(null);
        }
        catch (IOException e1) {
            LOGGER.debug("Unsafe http client request also failed");
            throw e1;
        }
        LOGGER.warn("Unsafe http client request succeeded. Probably third party authenticator");
        return new DetectedThirdPartyAuthenticatorInfo(null);
    }

    private void queryJsonStatusUsingClient(CloseableHttpClient httpClient) throws IOException, UnexpectedStatus {
        String status;
        this.statusJsonString = EHttpClient.toString(httpClient, Request.Get((String)AUTH_SERVER_STATUS_PAGE));
        LOGGER.debug("Status page ({}) returned: {}", (Object)AUTH_SERVER_STATUS_PAGE, (Object)this.statusJsonString);
        try {
            JsonElement statusJson = JsonParser.parseString((String)this.statusJsonString);
            status = statusJson.getAsJsonObject().getAsJsonPrimitive("Status").getAsString();
        }
        catch (RuntimeException parseException) {
            throw new UnexpectedStatus(parseException);
        }
        if (!AUTH_SERVER_STATUS_OK.equals(status)) {
            LOGGER.warn("Status is not {}: \"{}\"", (Object)AUTH_SERVER_STATUS_OK, (Object)status);
            throw new UnexpectedStatus(status);
        }
    }

    public static ConnectivityManager.Entry createEntry() {
        return new ConnectivityManager.Entry(AUTH_SERVER_HOST, AUTH_SERVER_HOST, (ConnectivityManager.EntryChecker)new AuthServerChecker());
    }

    private static CloseableHttpClient createUnsafeHttpsClient() throws Exception {
        return EHttpClient.builder().setSSLContext(new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)TrustAllStrategy.INSTANCE).build()).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build();
    }

    public static class DetectedThirdPartyAuthenticatorInfo {
        private final String name;

        DetectedThirdPartyAuthenticatorInfo(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    private static class UnexpectedStatus
    extends Exception {
        public UnexpectedStatus(String status) {
            super(status, null, true, false);
        }

        public UnexpectedStatus(Throwable cause) {
            super(null, cause, true, false);
        }
    }
}

