/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.managers;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import net.minecraft.launcher.updater.AssetDownloadable;
import net.minecraft.launcher.updater.AssetIndex;
import net.minecraft.launcher.versions.CompleteVersion;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.component.ComponentDependence;
import ru.turikhay.tlauncher.component.LauncherComponent;
import ru.turikhay.tlauncher.downloader.Downloadable;
import ru.turikhay.tlauncher.downloader.DownloadableContainer;
import ru.turikhay.tlauncher.managers.AssetsNotFoundException;
import ru.turikhay.tlauncher.managers.ComponentManager;
import ru.turikhay.tlauncher.managers.VersionLists;
import ru.turikhay.tlauncher.managers.VersionManager;
import ru.turikhay.tlauncher.repository.Repository;
import ru.turikhay.tlauncher.repository.RepositoryProxy;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.Time;
import ru.turikhay.util.U;
import ru.turikhay.util.async.ExtendedThread;

@ComponentDependence(value={VersionManager.class, VersionLists.class})
public class AssetsManager
extends LauncherComponent {
    private static final Logger LOGGER = LogManager.getLogger(AssetsManager.class);
    private final Gson gson = U.getGson();
    private final Object assetsFlushLock = new Object();

    public AssetsManager(ComponentManager manager) {
        super(manager);
    }

    public DownloadableContainer downloadResources(CompleteVersion version, List<AssetIndex.AssetObject> list) {
        File baseDirectory = this.manager.getLauncher().getVersionManager().getLocalList().getBaseDirectory();
        DownloadableContainer container = new DownloadableContainer();
        container.addAll(this.getResourceFiles(version, baseDirectory, list));
        return container;
    }

    private Set<Downloadable> getResourceFiles(CompleteVersion version, File baseDirectory, List<AssetIndex.AssetObject> list) {
        File objectsFolder = new File(baseDirectory, "assets/objects");
        HashSet<Downloadable> result = new HashSet<Downloadable>();
        for (AssetIndex.AssetObject object : list) {
            File destination = new File(objectsFolder, object.getHash());
            if (destination.isFile()) {
                String hash = FileUtil.getDigest(destination, "SHA", 40);
                if (object.getHash().equals(hash)) continue;
            }
            result.add(new AssetDownloadable(object, objectsFolder));
        }
        return result;
    }

    List<AssetIndex.AssetObject> getResourceFiles(CompleteVersion version, File baseDirectory, boolean local) {
        List<AssetIndex.AssetObject> list = null;
        if (!local) {
            try {
                list = this.getRemoteResourceFilesList(version, baseDirectory, true);
            }
            catch (Exception var7) {
                LOGGER.error("Cannot get remote assets list. Trying to use the local one.", (Throwable)var7);
            }
        }
        if (list == null) {
            list = this.getLocalResourceFilesList(version, baseDirectory);
        }
        if (list == null) {
            try {
                list = this.getRemoteResourceFilesList(version, baseDirectory, true);
            }
            catch (Exception var6) {
                LOGGER.error("Gave up trying to get assets list", (Throwable)var6);
            }
        }
        return list;
    }

    private List<AssetIndex.AssetObject> getLocalResourceFilesList(CompleteVersion version, File baseDirectory) {
        AssetIndex index;
        String indexName = version.getAssetIndex().getId();
        File indexesFolder = new File(baseDirectory, "assets/indexes/");
        File indexFile = new File(indexesFolder, indexName + ".json");
        LOGGER.debug("Reading indexes from file {}", (Object)indexFile);
        try (FileReader reader = new FileReader(indexFile);){
            AssetIndex obj = (AssetIndex)this.gson.fromJson((Reader)reader, AssetIndex.class);
            index = Objects.requireNonNull(obj);
        }
        catch (Exception e) {
            LOGGER.error("could not read index file {}", (Object)indexFile, (Object)e);
            return null;
        }
        return new ArrayList<AssetIndex.AssetObject>(index.getUniqueObjects());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AssetIndex.AssetObject> getRemoteResourceFilesList(CompleteVersion version, File baseDirectory, boolean save) throws IOException {
        Reader json;
        String indexName = version.getAssetIndex().getId();
        if (indexName == null) {
            indexName = "legacy";
        }
        File assets = new File(baseDirectory, "assets");
        File indexesFolder = new File(assets, "indexes");
        File indexFile = new File(indexesFolder, indexName + ".json");
        if (StringUtils.isBlank((CharSequence)version.getAssetIndex().getUrl())) {
            LOGGER.debug("Reading from repository...");
            json = Repository.OFFICIAL_VERSION_REPO.read("indexes/" + indexName + ".json");
        } else {
            LOGGER.debug("Reading from index: {}", (Object)version.getAssetIndex().getUrl());
            json = new StringReader(RepositoryProxy.requestMaybeProxy(version.getAssetIndex().getUrl()));
        }
        File tempIndexFile = null;
        if (save) {
            tempIndexFile = File.createTempFile("tlauncher-assets", null);
            tempIndexFile.deleteOnExit();
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tempIndexFile), StandardCharsets.UTF_8);){
                IOUtils.copy((Reader)json, (Writer)writer);
            }
            json = new FileReader(tempIndexFile);
        }
        AssetIndex index = (AssetIndex)this.gson.fromJson(json, AssetIndex.class);
        ArrayList<AssetIndex.AssetObject> result = new ArrayList<AssetIndex.AssetObject>(index.getUniqueObjects());
        if (save) {
            Object object = this.assetsFlushLock;
            synchronized (object) {
                try (FileInputStream in = new FileInputStream(tempIndexFile);
                     FileOutputStream out = new FileOutputStream(indexFile);){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                finally {
                    tempIndexFile.delete();
                }
            }
            LOGGER.debug("Assets index has been saved into file: {}", (Object)indexFile);
        }
        return result;
    }

    public ResourceChecker checkResources(CompleteVersion version, File baseDirectory, boolean local, boolean fast) throws AssetsNotFoundException {
        LOGGER.debug("Checking resources...");
        List<AssetIndex.AssetObject> list = local ? this.getLocalResourceFilesList(version, baseDirectory) : this.getResourceFiles(version, baseDirectory, false);
        if (list == null) {
            LOGGER.warn("Cannot check resources, because assets list is unavailable");
            throw new AssetsNotFoundException();
        }
        return new ResourceChecker(baseDirectory, list, fast);
    }

    public ResourceChecker checkResources(CompleteVersion version, boolean fast) throws AssetsNotFoundException {
        return this.checkResources(version, this.manager.getComponent(VersionLists.class).getLocal().getBaseDirectory(), false, fast);
    }

    private static boolean checkResource(File baseDirectory, AssetIndex.AssetObject local, boolean fast) {
        File assetFile = new File(baseDirectory, "assets/objects/" + AssetIndex.getPath(local.getHash()));
        if (fast) {
            return AssetsManager.checkFile(assetFile, local.size());
        }
        if (AssetsManager.checkFile(assetFile, local.size(), local.getHash())) {
            return true;
        }
        if (!local.isCompressed()) {
            return false;
        }
        FileUtil.deleteFile(assetFile);
        File compressedAssetFile = new File(baseDirectory, "assets/objects/" + AssetIndex.getPath(local.getCompressedHash()));
        if (AssetsManager.checkFile(assetFile, local.getCompressedSize(), local.getCompressedHash())) {
            try {
                AssetsManager.decompress(compressedAssetFile, assetFile, local.getHash());
            }
            catch (IOException ioE) {
                LOGGER.error("Could not decompress assets", (Throwable)ioE);
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean checkFile(File assetFile, long size) {
        return assetFile.isFile() && assetFile.length() == size;
    }

    private static boolean checkFile(File assetFile, long size, String hash) {
        return AssetsManager.checkFile(assetFile, size) && hash.equals(AssetIndex.getHash(assetFile));
    }

    public static void decompress(File compressedInput, File uncompressedOutput, String expectHash) throws IOException {
        String hash;
        try (GZIPInputStream in = new GZIPInputStream(new FileInputStream(compressedInput));
             FileOutputStream out = new FileOutputStream(uncompressedOutput);){
            hash = FileUtil.copyAndDigest(in, out, "SHA", 40);
        }
        if (!expectHash.equals(hash)) {
            throw new IOException("could not decompress asset got: " + hash + ", expected: " + expectHash);
        }
    }

    public static final class ResourceChecker
    extends ExtendedThread {
        final File baseDirectory;
        final boolean fast;
        final List<AssetIndex.AssetObject> objectList;
        private volatile List<AssetIndex.AssetObject> result;
        private volatile AssetIndex.AssetObject current;
        private long delta;
        private Exception e;

        ResourceChecker(File baseDirectory, List<AssetIndex.AssetObject> objectList, boolean fast) {
            this.baseDirectory = baseDirectory;
            this.objectList = objectList;
            this.fast = fast;
            this.startAndWait();
            this.unlockThread("start");
        }

        public boolean checkWorking() throws InterruptedException {
            if (this.isInterrupted()) {
                throw new InterruptedException();
            }
            return this.result == null && this.isAlive();
        }

        public AssetIndex.AssetObject getCurrent() {
            return this.current;
        }

        public List<AssetIndex.AssetObject> getAssetList() {
            return this.result;
        }

        public long getDelta() {
            return this.delta;
        }

        public Exception getError() {
            return this.e;
        }

        @Override
        public void run() {
            this.checkCurrent();
            this.lockThread("start");
            try {
                this.check();
            }
            catch (Exception e) {
                this.e = e;
            }
        }

        private void check() {
            LOGGER.info("Executing {} assets comparison", (Object)(this.fast ? "fast" : "deep"));
            ArrayList<AssetIndex.AssetObject> result = new ArrayList<AssetIndex.AssetObject>();
            Time.start();
            Iterator<AssetIndex.AssetObject> iterator = this.objectList.iterator();
            while (iterator.hasNext()) {
                AssetIndex.AssetObject object;
                this.current = object = iterator.next();
                if (AssetsManager.checkResource(this.baseDirectory, object, this.fast)) continue;
                if (Thread.interrupted()) {
                    throw new RuntimeException("interrupted");
                }
                result.add(object);
            }
            this.current = null;
            this.delta = Time.stop();
            this.result = result;
        }
    }
}

