/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.managers;

import java.util.Objects;
import ru.turikhay.tlauncher.managed.ManagedListener;
import ru.turikhay.tlauncher.managed.ManagedListenerHelper;
import ru.turikhay.tlauncher.user.Auth;
import ru.turikhay.tlauncher.user.ElyAuth;
import ru.turikhay.tlauncher.user.ElyLegacyAuth;
import ru.turikhay.tlauncher.user.McleaksAuth;
import ru.turikhay.tlauncher.user.MinecraftAuth;
import ru.turikhay.tlauncher.user.MojangAuth;
import ru.turikhay.tlauncher.user.PlainAuth;
import ru.turikhay.tlauncher.user.User;
import ru.turikhay.tlauncher.user.UserSet;
import ru.turikhay.tlauncher.user.UserSetJsonizer;
import ru.turikhay.tlauncher.user.UserSetListener;

public final class AccountManager {
    private static final MojangAuth MOJANG_AUTH = new MojangAuth();
    private static final ElyAuth ELY_AUTH = new ElyAuth();
    private static final ElyLegacyAuth ELY_LEGACY_AUTH = new ElyLegacyAuth();
    private static final PlainAuth PLAIN_AUTH = new PlainAuth();
    private static final McleaksAuth MCLEAKS_AUTH = new McleaksAuth();
    private static final MinecraftAuth MINECRAFT_AUTH = new MinecraftAuth();
    private final ManagedListenerHelper<User> helper = new ManagedListenerHelper();
    private final UserSetJsonizer jsonizer = new UserSetJsonizer(this.helper);
    private UserSet userSet;

    public AccountManager() {
        this.setUserSet(null);
    }

    public UserSet getUserSet() {
        return this.userSet;
    }

    void setUserSet(UserSet userSet) {
        this.userSet = userSet == null ? new UserSet((ManagedListener<User>)this.helper) : userSet;
    }

    public UserSetJsonizer getTypeAdapter() {
        return this.jsonizer;
    }

    public void addListener(UserSetListener listener) {
        this.helper.addListener(listener);
    }

    public static MojangAuth getMojangAuth() {
        return MOJANG_AUTH;
    }

    public static ElyAuth getElyAuth() {
        return ELY_AUTH;
    }

    public static ElyLegacyAuth getElyLegacyAuth() {
        return ELY_LEGACY_AUTH;
    }

    public static PlainAuth getPlainAuth() {
        return PLAIN_AUTH;
    }

    public static McleaksAuth getMcleaksAuth() {
        return MCLEAKS_AUTH;
    }

    public static MinecraftAuth getMinecraftAuth() {
        return MINECRAFT_AUTH;
    }

    public static Auth<?> getAuthFor(User user) {
        Objects.requireNonNull(user, "user");
        switch (user.getType()) {
            case "mojang": {
                return MOJANG_AUTH;
            }
            case "ely": {
                return ELY_AUTH;
            }
            case "ely_legacy": {
                return ELY_LEGACY_AUTH;
            }
            case "plain": {
                return PLAIN_AUTH;
            }
            case "mcleaks": {
                return MCLEAKS_AUTH;
            }
            case "minecraft": {
                return MINECRAFT_AUTH;
            }
        }
        throw new IllegalArgumentException("cannot find Auth for: " + user);
    }
}

