/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.managed;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import ru.turikhay.tlauncher.managed.ManagedListener;

public abstract class ManagedSet<T> {
    private final Set<T> set = new LinkedHashSet<T>();
    private final Set<T> set_ = Collections.unmodifiableSet(this.set);
    private final ManagedListener<T> listener;
    private T selected;

    protected ManagedSet(ManagedListener<T> listener) {
        this.listener = Objects.requireNonNull(listener, "listener");
    }

    protected void fireSetChanged() {
        this.listener.changedSet(this);
    }

    public void add(T obj) {
        if (this.set.add(Objects.requireNonNull(obj, "user"))) {
            this.fireSetChanged();
        }
    }

    public void remove(T obj) {
        if (obj == null) {
            return;
        }
        if (this.set.remove(obj)) {
            if (obj.equals(this.selected)) {
                this.selected = null;
            }
            this.fireSetChanged();
        }
    }

    public void select(T obj, boolean fireRefresh) {
        if (!Objects.equals(this.selected, obj)) {
            this.selected = obj;
            if (fireRefresh) {
                this.fireSetChanged();
            }
        }
    }

    public void select(T obj) {
        this.select(obj, true);
    }

    public T getSelected() {
        return this.selected;
    }

    public Set<T> getSet() {
        return this.set_;
    }
}

